/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.id.IdCreator$;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.UserTokenMapper;
import com.xebialabs.xlrelease.repository.sql.UserTokenQueryBuilder$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceConstants$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.support.SqlBinaryValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u0012$\u00019B\u0001B\u0014\u0001\u0003\u0006\u0004%\u0019a\u0014\u0005\tO\u0002\u0011\t\u0011)A\u0005!\"A\u0001\u000e\u0001BC\u0002\u0013\r\u0011\u000e\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003k\u0011!9\bA!b\u0001\n\u0007A\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u000bu\u0004A\u0011\u0001@\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0004\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002\u000e!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBAI\u0001\u0011\u0005\u00131\u0013\u0005\n\u0003O\u0003!\u0019!C\u0005\u0003\u0017A\u0001\"!+\u0001A\u0003%\u0011Q\u0002\u0005\b\u0003W\u0003A\u0011IAW\u0011%\tI\f\u0001b\u0001\n\u0013\tY\f\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BA_\u0011\u001d\tI\r\u0001C!\u0003\u0017D\u0011\"!5\u0001\u0005\u0004%I!a/\t\u0011\u0005M\u0007\u0001)A\u0005\u0003{Cq!!6\u0001\t\u0003\n9\u000eC\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002\f!A\u0011\u0011\u001d\u0001!\u0002\u0013\ti\u0001C\u0004\u0002d\u0002!\t%!:\t\u0013\u0005}\bA1A\u0005\n\u0005-\u0001\u0002\u0003B\u0001\u0001\u0001\u0006I!!\u0004\t\u000f\t\r\u0001\u0001\"\u0011\u0003\u0006!I!\u0011\u0003\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0005'\u0001\u0001\u0015!\u0003\u0002\u000e!9!Q\u0003\u0001\u0005B\t]\u0001b\u0002B\u0010\u0001\u0011\u0005#\u0011\u0005\u0002\u0017'FdWk]3s)>\\WM\u001c*fa>\u001c\u0018\u000e^8ss*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003Q%\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005)Z\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0013aA2p[\u000e\u00011c\u0002\u00010kez$I\u0012\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y:T\"A\u0013\n\u0005a*#aE+tKJ$vn[3o%\u0016\u0004xn]5u_JL\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f$\u0003-\u0001XM]:jgR,gnY3\n\u0005yZ$A\u0005)feNL7\u000f^3oG\u0016\u001cV\u000f\u001d9peR\u0004\"A\u000f!\n\u0005\u0005[$!B+uS2\u001c\bCA\"E\u001b\u0005\u0019\u0013BA#$\u0005=)6/\u001a:U_.,g.T1qa\u0016\u0014\bCA$M\u001b\u0005A%BA%K\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0015\u0001C4sSjTH.\u001a3\n\u00055C%a\u0002'pO\u001eLgnZ\u0001\bI&\fG.Z2u+\u0005\u0001\u0006CA)e\u001d\t\u0011\u0016M\u0004\u0002T?:\u0011A+\u0018\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005ek\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\tQ3&\u0003\u0002)S%\u0011alJ\u0001\u0003I\nL!\u0001\n1\u000b\u0005y;\u0013B\u00012d\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003I\u0001L!!\u001a4\u0003\u000f\u0011K\u0017\r\\3di*\u0011!mY\u0001\tI&\fG.Z2uA\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t!\u000e\u0005\u0002li6\tAN\u0003\u0002n]\u0006!1m\u001c:f\u0015\ty\u0007/\u0001\u0003kI\n\u001c'BA9s\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A:\u0002\u0007=\u0014x-\u0003\u0002vY\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nAc]9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A=\u0011\u0005\rS\u0018BA>$\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006)2/\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0001\u0000)!\t\t!a\u0001\u0002\u0006\u0005\u001d\u0001CA\"\u0001\u0011\u0015qu\u0001q\u0001Q\u0011\u0015Aw\u0001q\u0001k\u0011\u00159x\u0001q\u0001z\u0003Y\u0019F+\u0014+`\u0013:\u001bVI\u0015+`+N+%k\u0018+P\u0017\u0016sUCAA\u0007!\u0011\ty!a\u0006\u000f\t\u0005E\u00111\u0003\t\u0003/FJ1!!\u00062\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011DA\u000e\u0005\u0019\u0019FO]5oO*\u0019\u0011QC\u0019\u0002/M#V\nV0J\u001dN+%\u000bV0V'\u0016\u0013v\fV(L\u000b:\u0003\u0013AB2sK\u0006$X\r\u0006\u0004\u0002$\u0005\u0005\u0013Q\n\t\u0005\u0003K\tYD\u0004\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003_q1\u0001VA\u0016\u0013\r\ticJ\u0001\u0007I>l\u0017-\u001b8\n\t\u0005E\u00121G\u0001\u0003S\u0012T1!!\f(\u0013\u0011\t9$!\u000f\u0002\u000fA\f7m[1hK*!\u0011\u0011GA\u001a\u0013\u0011\ti$a\u0010\u0003\u000b\rKW+\u001b3\u000b\t\u0005]\u0012\u0011\b\u0005\b\u0003\u0007R\u0001\u0019AA#\u0003%)8/\u001a:U_.,g\u000e\u0005\u0003\u0002H\u0005%SBAA\u001a\u0013\u0011\tY%a\r\u0003\u0013U\u001bXM\u001d+pW\u0016t\u0007bBA(\u0015\u0001\u0007\u0011QB\u0001\ni>\\WM\u001c%bg\"D3ACA*!\u0011\t)&!\u001a\u000e\u0005\u0005]#\u0002BA-\u00037\n!\"\u00198o_R\fG/[8o\u0015\ri\u0017Q\f\u0006\u0005\u0003?\n\t'\u0001\u0006nS\u000e\u0014x.\\3uKJT!!a\u0019\u0002\u0005%|\u0017\u0002BA4\u0003/\u0012Q\u0001V5nK\u0012\fQc\u0015+N)~+\u0006\u000bR!U\u000b~c\u0015i\u0015+`+N+E)\u0001\fT)6#v,\u0016)E\u0003R+u\fT!T)~+6+\u0012#!\u00039)\b\u000fZ1uK2\u000b7\u000f^+tK\u0012$b!!\u001d\u0002x\u0005m\u0004c\u0001\u0019\u0002t%\u0019\u0011QO\u0019\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011P\u0007A\u0002\u0005\r\u0012!B2j+&$\u0007bBA?\u001b\u0001\u0007\u0011qP\u0001\tY\u0006\u001cH/V:fIB!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001B;uS2T!!!#\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\u000b\u0019I\u0001\u0003ECR,\u0007fA\u0007\u0002T\u0005\u0019R\u000f\u001d3bi\u0016d\u0015m\u001d;Vg\u0016$')\u0019;dQR!\u0011QSAN!\r\u0001\u0014qS\u0005\u0004\u00033\u000b$aA%oi\"9\u0011Q\u0014\bA\u0002\u0005}\u0015aB3oiJLWm\u001d\t\t\u0003\u001f\t\t+a\t\u0002\u0000%!\u00111UA\u000e\u0005\ri\u0015\r\u001d\u0015\u0004\u001d\u0005M\u0013!I*U\u001bR{V\u000b\u0015#B)\u0016{FkT&F\u001d~+\u0005\fU%S\u000b~su\nV%G\u0013\u0016#\u0015AI*U\u001bR{V\u000b\u0015#B)\u0016{FkT&F\u001d~+\u0005\fU%S\u000b~su\nV%G\u0013\u0016#\u0005%\u0001\u000eva\u0012\fG/\u001a+pW\u0016tW\t\u001f9je\u0016$gj\u001c;jM&,G\r\u0006\u0003\u00020\u0006U\u0006c\u0001\u0019\u00022&\u0019\u00111W\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003s\n\u0002\u0019AA\u0012Q\r\t\u00121K\u0001 'RkEk\u0018#F\u0019\u0016#ViX+T\u000bJ{FkT&F\u001d~\u0013\u0015lX\"J+&#UCAA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000f\u000bA\u0001\\1oO&!\u0011\u0011DAa\u0003\u0001\u001aF+\u0014+`\t\u0016cU\tV#`+N+%k\u0018+P\u0017\u0016suLQ-`\u0007&+\u0016\n\u0012\u0011\u0002\r\u0011,G.\u001a;f)\u0011\ty+!4\t\u000f\u0005eD\u00031\u0001\u0002$!\u001aA#a\u0015\u0002EM#V\nV0E\u000b2+E+R0V'\u0016\u0013v\fV(L\u000b:{&)W0V'\u0016\u0013f*Q'F\u0003\r\u001aF+\u0014+`\t\u0016cU\tV#`+N+%k\u0018+P\u0017\u0016suLQ-`+N+%KT!N\u000b\u0002\n\u0001\u0003Z3mKR,')_+tKJt\u0017-\\3\u0015\t\u0005=\u0016\u0011\u001c\u0005\b\u00037<\u0002\u0019AA\u0007\u0003!)8/\u001a:oC6,\u0007fA\f\u0002T\u0005I\u0012+V#S3~+6+\u0012*`)>[UIT0C3~\u001b\u0015*V%E\u0003i\tV+\u0012*Z?V\u001bVIU0U\u001f.+ej\u0018\"Z?\u000eKU+\u0013#!\u0003-1\u0017N\u001c3Cs\u000eKW+\u001b3\u0015\t\u0005\u001d\u0018Q\u001e\t\u0006a\u0005%\u0018QI\u0005\u0004\u0003W\f$AB(qi&|g\u000eC\u0004\u0002zi\u0001\r!a\t)\u0007i\t\u0019\u0006K\u0002\u001b\u0003g\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0004\u0003s\u001c\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:LA!!@\u0002x\nQ\u0011j\u001d*fC\u0012|e\u000e\\=\u0002CE+VIU-`+N+%k\u0018+P\u0017\u0016suLQ-`+N+%kX!O\t~su\nV#\u0002EE+VIU-`+N+%k\u0018+P\u0017\u0016suLQ-`+N+%kX!O\t~su\nV#!\u0003E1\u0017N\u001c3CsV\u001bXM]!oI:{G/\u001a\u000b\u0007\u0003O\u00149A!\u0003\t\u000f\u0005mW\u00041\u0001\u0002\u000e!9!1B\u000fA\u0002\u00055\u0011!\u0003;pW\u0016tgj\u001c;fQ\ri\u00121\u000b\u0015\u0004;\u0005M\u0018AH)V\u000bJKv,V*F%~#vjS#O?\nKv\fV(L\u000b:{\u0006*Q*I\u0003}\tV+\u0012*Z?V\u001bVIU0U\u001f.+ej\u0018\"Z?R{5*\u0012(`\u0011\u0006\u001b\u0006\nI\u0001\u0010M&tGMQ=Vg\u0016\u0014Hk\\6f]R!\u0011q\u001dB\r\u0011\u001d\ty\u0005\ta\u0001\u0003\u001bA3\u0001IA*Q\r\u0001\u00131_\u0001\u0006cV,'/\u001f\u000b\u0007\u0005G\u0011\tDa\u0012\u0011\r\t\u0015\"QFA#\u001b\t\u00119C\u0003\u0003\u0002.\t%\"b\u0001B\u0016a\u0006!A-\u0019;b\u0013\u0011\u0011yCa\n\u0003\tA\u000bw-\u001a\u0005\b\u0005g\t\u0003\u0019\u0001B\u001b\u0003%y\u0007/\u001a:bi&|g\u000e\u0005\u0003\u00038\t\u0005c\u0002\u0002B\u001d\u0005{q1\u0001\u0016B\u001e\u0013\t1s%C\u0002\u0003@\u0015\n1#V:feR{7.\u001a8SKB|7/\u001b;pefLAAa\u0011\u0003F\tq\u0011+^3ss>\u0003XM]1uS>t'b\u0001B K!9!\u0011J\u0011A\u0002\t-\u0013\u0001\u00039bO\u0016\f'\r\\3\u0011\t\t\u0015\"QJ\u0005\u0005\u0005\u001f\u00129C\u0001\u0005QC\u001e,\u0017M\u00197fQ\r\t\u00131\u000b\u0015\u0004C\u0005M\bf\u0001\u0001\u0003XA!\u0011Q\u001fB-\u0013\u0011\u0011Y&a>\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlUserTokenRepository
implements UserTokenRepository,
PersistenceSupport,
UserTokenMapper,
Logging {
    private final SqlBuilder.Dialect dialect;
    private final JdbcTemplate jdbcTemplate;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final String STMT_INSERT_USER_TOKEN;
    private final String STMT_UPDATE_LAST_USED;
    private final String STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED;
    private final String STMT_DELETE_USER_TOKEN_BY_CIUID;
    private final String STMT_DELETE_USER_TOKEN_BY_USERNAME;
    private final String QUERY_USER_TOKEN_BY_CIUID;
    private final String QUERY_USER_TOKEN_BY_USER_AND_NOTE;
    private final String QUERY_USER_TOKEN_BY_TOKEN_HASH;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public RowMapper<UserToken> userTokenMapper() {
        return UserTokenMapper.userTokenMapper$(this);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public void sqlInsert(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, sqlStatement, params);
    }

    @Override
    public void sqlInsertTask(String sqlStatement, Map<String, Object> params) {
        PersistenceSupport.sqlInsertTask$(this, sqlStatement, params);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public void sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam) {
        PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Long uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Long uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserTokenRepository sqlUserTokenRepository = this;
        synchronized (sqlUserTokenRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlUserTokenRepository sqlUserTokenRepository = this;
        synchronized (sqlUserTokenRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlRepositoryAdapter sqlRepositoryAdapter() {
        return this.sqlRepositoryAdapter;
    }

    private String STMT_INSERT_USER_TOKEN() {
        return this.STMT_INSERT_USER_TOKEN;
    }

    @Timed
    public Long create(UserToken userToken, String tokenHash) {
        this.logger().trace((Function0 & Serializable)() -> "creating user token " + userToken);
        Long id = IdCreator$.MODULE$.generateId();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(Schema.USER_TOKENS$.MODULE$.CI_UID(), (Object)id);
        params.addValue(Schema.USER_TOKENS$.MODULE$.USERNAME(), (Object)userToken.username().toLowerCase());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE(), (Object)userToken.tokenNote());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_HASH(), (Object)tokenHash);
        params.addValue(Schema.USER_TOKENS$.MODULE$.CREATED_DATE(), (Object)userToken.createdDate());
        params.addValue(Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE(), (Object)userToken.expiryDate());
        params.addValue(Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS(), Option$.MODULE$.apply((Object)userToken.userTokenPermission()).map((Function1 & Serializable)permission -> new SqlBinaryValue(CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)permission).getBytes(StandardCharsets.UTF_8))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), PersistenceConstants$.MODULE$.BLOB_TYPE());
        this.sqlInsert(this.STMT_INSERT_USER_TOKEN(), params);
        return id;
    }

    private String STMT_UPDATE_LAST_USED() {
        return this.STMT_UPDATE_LAST_USED;
    }

    @Timed
    public boolean updateLastUsed(Long ciUid, Date lastUsed) {
        return BoxesRunTime.unboxToBoolean(this.sqlUpdate(this.STMT_UPDATE_LAST_USED(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastUsed"), (Object)lastUsed)}))), (Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 == 1));
    }

    @Timed
    public int updateLastUsedBatch(Map<Long, Date> entries) {
        return BoxesRunTime.unboxToInt((Object)this.sqlBatch(this.STMT_UPDATE_LAST_USED(), (Set<Map<String, Object>>)((IterableOnceOps)entries.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Long ciUid = (Long)tuple2._1();
                Date lastUsed = (Date)tuple2._2();
                return Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lastUsed"), (Object)lastUsed)}));
            }
            throw new MatchError((Object)tuple2);
        })).toSet()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private String STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED() {
        return this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED;
    }

    @Timed
    public void updateTokenExpiredNotified(Long ciUid) {
        this.sqlUpdate(this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ciUid"), (Object)ciUid)}))), (Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {});
    }

    private String STMT_DELETE_USER_TOKEN_BY_CIUID() {
        return this.STMT_DELETE_USER_TOKEN_BY_CIUID;
    }

    @Timed
    public void delete(Long ciUid) {
        this.logger().trace((Function0 & Serializable)() -> "deleting user token with ciUid[" + ciUid + "]");
        this.sqlExec(this.STMT_DELETE_USER_TOKEN_BY_CIUID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_TOKENS$.MODULE$.CI_UID()), (Object)ciUid)})), x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.execute()));
    }

    private String STMT_DELETE_USER_TOKEN_BY_USERNAME() {
        return this.STMT_DELETE_USER_TOKEN_BY_USERNAME;
    }

    @Timed
    public void deleteByUsername(String username) {
        this.logger().trace((Function0 & Serializable)() -> "deleting all user tokens with username[" + username + "]");
        this.sqlExec(this.STMT_DELETE_USER_TOKEN_BY_USERNAME(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.USER_TOKENS$.MODULE$.USERNAME()), (Object)username.toLowerCase())})), x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute()));
    }

    private String QUERY_USER_TOKEN_BY_CIUID() {
        return this.QUERY_USER_TOKEN_BY_CIUID;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByCiUid(Long ciUid) {
        this.logger().trace((Function0 & Serializable)() -> "finding user token with ciUid[" + ciUid + "]");
        return this.findOptional((Function1 & Serializable)x$5 -> (UserToken)x$5.queryForObject(this.QUERY_USER_TOKEN_BY_CIUID(), this.userTokenMapper(), new Object[]{ciUid}), this.jdbcTemplate());
    }

    private String QUERY_USER_TOKEN_BY_USER_AND_NOTE() {
        return this.QUERY_USER_TOKEN_BY_USER_AND_NOTE;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByUserAndNote(String username, String tokenNote) {
        this.logger().trace((Function0 & Serializable)() -> "finding user token with username[" + username + "] and tokenNote[" + tokenNote + "]");
        return this.findOptional((Function1 & Serializable)x$6 -> (UserToken)x$6.queryForObject(this.QUERY_USER_TOKEN_BY_USER_AND_NOTE(), this.userTokenMapper(), new Object[]{username.toLowerCase(), tokenNote}), this.jdbcTemplate());
    }

    private String QUERY_USER_TOKEN_BY_TOKEN_HASH() {
        return this.QUERY_USER_TOKEN_BY_TOKEN_HASH;
    }

    @Timed
    @IsReadOnly
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.findOptional((Function1 & Serializable)x$7 -> (UserToken)x$7.queryForObject(this.QUERY_USER_TOKEN_BY_TOKEN_HASH(), this.userTokenMapper(), new Object[]{tokenHash}), this.jdbcTemplate());
    }

    @Timed
    @IsReadOnly
    public Page<UserToken> query(UserTokenRepository.QueryOperation operation, Pageable pageable) {
        return UserTokenQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.sqlRepositoryAdapter()).from(operation).withPageable(pageable).build().execute();
    }

    public SqlUserTokenRepository(SqlBuilder.Dialect dialect, JdbcTemplate jdbcTemplate, SqlRepositoryAdapter sqlRepositoryAdapter) {
        this.dialect = dialect;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        UserTokenMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_USER_TOKEN = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.USER_TOKENS$.MODULE$.TABLE() + " (\n       |  " + Schema.USER_TOKENS$.MODULE$.CI_UID() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.USERNAME() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.CREATED_DATE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE() + ",\n       |  " + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + "\n       | ) VALUES (\n       |  :" + Schema.USER_TOKENS$.MODULE$.CI_UID() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.USERNAME() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.CREATED_DATE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.EXPIRY_DATE() + ",\n       |  :" + Schema.USER_TOKENS$.MODULE$.TOKEN_PERMISSIONS() + "\n       | )\n       |"));
        this.STMT_UPDATE_LAST_USED = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.USER_TOKENS$.MODULE$.TABLE() + "\n       |  SET " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " = CASE\n       |    WHEN " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " < :lastUsed OR " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + " IS NULL THEN :lastUsed\n       |    ELSE " + Schema.USER_TOKENS$.MODULE$.LAST_USED_DATE() + "\n       |  END\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :ciUid\n       |"));
        this.STMT_UPDATE_TOKEN_EXPIRE_NOTIFIED = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.USER_TOKENS$.MODULE$.TABLE() + "\n       |  SET " + Schema.USER_TOKENS$.MODULE$.IS_TOKEN_EXPIRE_NOTIFIED() + " = 1\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :ciUid\n       |"));
        this.STMT_DELETE_USER_TOKEN_BY_CIUID = "DELETE FROM " + Schema.USER_TOKENS$.MODULE$.TABLE() + " WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = :" + Schema.USER_TOKENS$.MODULE$.CI_UID();
        this.STMT_DELETE_USER_TOKEN_BY_USERNAME = "DELETE FROM " + Schema.USER_TOKENS$.MODULE$.TABLE() + " WHERE " + Schema.USER_TOKENS$.MODULE$.USERNAME() + " = :" + Schema.USER_TOKENS$.MODULE$.USERNAME();
        this.QUERY_USER_TOKEN_BY_CIUID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.CI_UID() + " = ?\n       |"));
        this.QUERY_USER_TOKEN_BY_USER_AND_NOTE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.USERNAME() + " = ?\n       |  AND " + Schema.USER_TOKENS$.MODULE$.TOKEN_NOTE() + " = ?\n       |"));
        this.QUERY_USER_TOKEN_BY_TOKEN_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |" + UserTokenQueryBuilder$.MODULE$.STMT_USER_TOKEN_SELECT() + "\n       |  WHERE " + Schema.USER_TOKENS$.MODULE$.TOKEN_HASH() + " = ?\n       |"));
    }
}

