/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion4;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.exception.LicenseLimitReachedException;
import com.xebialabs.xlrelease.limits.LimitEnforcer;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.ReleasePersistenceInterceptor$;
import com.xebialabs.xlrelease.repository.sql.WorkflowInterceptorLogic;
import com.xebialabs.xlrelease.repository.sql.WorkflowTaskValidator;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.utils.TenantContext$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001\u0002\u0010 \u0001)B\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t!\u0002\u0011)\u0019!C\u0001#\"A\u0001\f\u0001B\u0001B\u0003%!\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u000b5\u0004A\u0011\u00018\t\u000bU\u0004A\u0011\t<\t\r}\u0004A\u0011IA\u0001\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Bq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBA7\u0001\u0011%\u0011qN\u0004\b\u00037{\u0002\u0012AAO\r\u0019qr\u0004#\u0001\u0002 \"1Q\u000e\u0007C\u0001\u0003OC\u0011\"!+\u0019\u0005\u0004%I!a+\t\u0011\u0005M\u0006\u0004)A\u0005\u0003[C\u0011\"!.\u0019\u0005\u0004%I!a.\t\u0011\u0005-\u0007\u0004)A\u0005\u0003s\u0013QDU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK&sG/\u001a:dKB$xN\u001d\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%\u0001\u0006sKB|7/\u001b;pefT!\u0001J\u0013\u0002\u0013ad'/\u001a7fCN,'B\u0001\u0014(\u0003%AXMY5bY\u0006\u00147OC\u0001)\u0003\r\u0019w.\\\u0002\u0001'\u0019\u00011fM\u001fB\tB\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB(cU\u0016\u001cG\u000fE\u00025k]j\u0011!I\u0005\u0003m\u0005\u0012a\u0003U3sg&\u001cH/\u001a8dK&sG/\u001a:dKB$xN\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003u\r\na\u0001Z8nC&t\u0017B\u0001\u001f:\u0005\u001d\u0011V\r\\3bg\u0016\u0004\"AP \u000e\u0003}I!\u0001Q\u0010\u0003+]{'o\u001b4m_^$\u0016m]6WC2LG-\u0019;peB\u0011aHQ\u0005\u0003\u0007~\u0011\u0001dV8sW\u001adwn^%oi\u0016\u00148-\u001a9u_JdunZ5d!\t)%*D\u0001G\u0015\t9\u0005*A\u0003tY\u001a$$NC\u0001J\u0003!9'/\u001b>{Y\u0016$\u0017BA&G\u0005\u001daunZ4j]\u001e\f\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z!\t!d*\u0003\u0002PC\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+~\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011q\u000b\u0016\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0011M>dG-\u001a:SKB|7/\u001b;pef\u0004\"\u0001N.\n\u0005q\u000b#\u0001\u0005$pY\u0012,'OU3q_NLGo\u001c:z\u00039a\u0017nY3og\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u000fM,'O^5dK*\u00111-J\u0001\bY&\u001cWM\\:f\u0013\t)\u0007M\u0001\bMS\u000e,gn]3TKJ4\u0018nY3\u0002\u001b1LW.\u001b;F]\u001a|'oY3s!\tA7.D\u0001j\u0015\tQ7%\u0001\u0004mS6LGo]\u0005\u0003Y&\u0014Q\u0002T5nSR,eNZ8sG\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004paF\u00148\u000f\u001e\t\u0003}\u0001AQ\u0001T\u0004A\u00025CQ\u0001U\u0004A\u0002ICQ!W\u0004A\u0002iCQ!X\u0004A\u0002yCQAZ\u0004A\u0002\u001d\f\u0001b\u001c8De\u0016\fG/\u001a\u000b\u0003ov\u0004\"\u0001_>\u000e\u0003eT\u0011A_\u0001\u0006g\u000e\fG.Y\u0005\u0003yf\u0014A!\u00168ji\")a\u0010\u0003a\u0001o\u0005\u00111-[\u0001\t_:,\u0006\u000fZ1uKR\u0019q/a\u0001\t\u000byL\u0001\u0019A\u001c\u0002'Q,g.\u00198u)\u0016l\u0007\u000f\\1uK\u000e{WO\u001c;\u0015\t\u0005%\u0011q\u0002\t\u0004Y\u0005-\u0011bAA\u0007[\t9\u0011J\u001c;fO\u0016\u0014\bbBA\t\u0015\u0001\u0007\u00111C\u0001\ti\u0016t\u0017M\u001c;JIB!\u0011QCA\u0012\u001d\u0011\t9\"a\b\u0011\u0007\u0005e\u00110\u0004\u0002\u0002\u001c)\u0019\u0011QD\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t\t#_\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005\u00120\u0001\nuK:\fg\u000e\u001e*fY\u0016\f7/Z\"pk:$H\u0003BA\u0005\u0003[Aq!!\u0005\f\u0001\u0004\t\u0019\"\u0001\tp]\u000e\u0013X-\u0019;f\u001fJ,\u0006\u000fZ1uKR\u0019q/a\r\t\r\u0005UB\u00021\u00018\u0003\u001d\u0011X\r\\3bg\u0016\f1D^1mS\u0012\fG/\u001a#fM\u0006,H\u000e\u001e+be\u001e,GOR8mI\u0016\u0014HcA<\u0002<!1\u0011QG\u0007A\u0002]\n!D^1mS\u0012\fG/Z,pe.4Gn\\<Qe>\u0004XM\u001d;jKN$2a^A!\u0011\u0019\t)D\u0004a\u0001o\u0005Ab/\u00197jI\u0006$XMT8u\u0003J{w\u000e^,pe.4Gn\\<\u0015\u0007]\f9\u0005\u0003\u0004\u00026=\u0001\raN\u0001\u001fm\u0006d\u0017\u000eZ1uK:{G)Y:iE>\f'\u000f\u001a$pe^{'o\u001b4m_^$2a^A'\u0011\u0019\t)\u0004\u0005a\u0001o\u0005!c/\u00197jI\u0006$XMT8M_\u000e\\G+Y:l!J,7/\u001a8u\r>\u0014xk\u001c:lM2|w\u000fF\u0002x\u0003'Ba!!\u000e\u0012\u0001\u00049\u0014\u0001\t<bY&$\u0017\r^3O_JK7o\u001b)s_\u001aLG.\u001a$pe^{'o\u001b4m_^$2a^A-\u0011\u0019\t)D\u0005a\u0001o\u0005Yc/\u00197jI\u0006$XMT8V]N,\b\u000f]8si\u0016$G+Y:l!J,7/\u001a8u\r>\u0014xk\u001c:lM2|w\u000fF\u0002x\u0003?Ba!!\u000e\u0014\u0001\u00049\u0014A\u000b<bY&$\u0017\r^3O_6+H\u000e^5MKZ,GNT3ti\u0016$G+Y:lg\u001a{'oV8sW\u001adwn\u001e\u000b\u0004o\u0006\u0015\u0004BBA\u001b)\u0001\u0007q'\u0001\u0012wC2LG-\u0019;f)>$\u0018\r\u001c(p\u001f\u001a<vN]6gY><H+Z7qY\u0006$Xm\u001d\u000b\u0004o\u0006-\u0004BBA\u001b+\u0001\u0007q'A\thKRd\u0015nY3og\u0016,E-\u001b;j_:$\"!a\u0005)\u0007\u0001\t\u0019\b\u0005\u0003\u0002v\u0005\rUBAA<\u0015\u0011\tI(a\u001f\u0002\u0015M$XM]3pif\u0004XM\u0003\u0003\u0002~\u0005}\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005\u0005\u0015aA8sO&!\u0011QQA<\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0002\u0001\u0003\u0013\u0003B!a#\u0002\u00186\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0006ue\u0006t7/Y2uS>t'b\u0001\u0011\u0002\u0014*\u0019\u0011QS\u0012\u0002\u0005\u0011\u0014\u0017\u0002BAM\u0003\u001b\u0013q\"S:Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u001e%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-\u00138uKJ\u001cW\r\u001d;peB\u0011a\bG\n\u00041\u0005\u0005\u0006c\u0001=\u0002$&\u0019\u0011QU=\u0003\r\u0005s\u0017PU3g)\t\ti*A\u0011N\u0003b{fjT0X\u001fJ[e\tT(X?R+U\n\u0015'B)\u0016\u001bv,\u0011'M\u001f^+E)\u0006\u0002\u0002.B\u0019\u00010a,\n\u0007\u0005E\u0016PA\u0002J]R\f!%T!Y?:{ulV(S\u0017\u001acujV0U\u000b6\u0003F*\u0011+F'~\u000bE\nT(X\u000b\u0012\u0003\u0013!H+O%\u0016\u001bFKU%D)\u0016#u\fT%D\u000b:\u001bViX#E\u0013RKuJT*\u0016\u0005\u0005e\u0006CBA^\u0003\u000b\f\u0019B\u0004\u0003\u0002>\u0006\u0005g\u0002BA\r\u0003\u007fK\u0011A_\u0005\u0004\u0003\u0007L\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\fIMA\u0002TKFT1!a1z\u0003y)fJU#T)JK5\tV#E?2K5)\u0012(T\u000b~+E)\u0013+J\u001f:\u001b\u0006\u0005")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release>,
WorkflowTaskValidator,
WorkflowInterceptorLogic,
Logging {
    private final ReleaseRepository releaseRepository;
    private final TaskPersistence taskPersistence;
    private final FolderRepository folderRepository;
    private final LicenseService licenseService;
    private final LimitEnforcer limitEnforcer;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateWorkflowProperties(Release release) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, release);
    }

    @Override
    public void updateWorkflowProperties(Task task) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateWorkflowTaskCount(Release release) {
        WorkflowTaskValidator.validateWorkflowTaskCount$(this, release);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Task task) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, tasks);
    }

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePersistenceInterceptor releasePersistenceInterceptor = this;
        synchronized (releasePersistenceInterceptor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public void onCreate(Release ci) {
        String string;
        if (StringUtils.hasText((String)ci.getTenantId())) {
            string = ci.getTenantId();
        } else {
            String tenantIdFromContext = TenantContext$.MODULE$.getTenant();
            ci.setTenantId(tenantIdFromContext);
            string = tenantIdFromContext;
        }
        String tenantId = string;
        ReleaseStatus releaseStatus = ci.getStatus();
        if (ReleaseStatus.TEMPLATE.equals(releaseStatus)) {
            this.limitEnforcer.enforceLimit(tenantId, LimitEnforcer.LimitType.TEMPLATES, 1, () -> Predef$.MODULE$.Integer2int(this.tenantTemplateCount(tenantId)));
        } else if (ReleaseStatus.PLANNED.equals(releaseStatus) ? true : (ReleaseStatus.IN_PROGRESS.equals(releaseStatus) ? true : (ReleaseStatus.PAUSED.equals(releaseStatus) ? true : (ReleaseStatus.FAILED.equals(releaseStatus) ? true : ReleaseStatus.FAILING.equals(releaseStatus))))) {
            this.limitEnforcer.enforceLimit(tenantId, LimitEnforcer.LimitType.RELEASES, 1, () -> Predef$.MODULE$.Integer2int(this.tenantReleaseCount(tenantId)));
        }
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private Integer tenantTemplateCount(String tenantId) {
        return this.releaseRepository.tenantTemplateCountByKind(tenantId, ReleaseKind.RELEASE);
    }

    private Integer tenantReleaseCount(String tenantId) {
        return this.releaseRepository.tenantReleaseCountByKind(tenantId, ReleaseKind.RELEASE);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateTotalNoOfWorkflowTemplates(release);
        this.updateWorkflowProperties(release);
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoUnsupportedTaskPresentForWorkflow(release);
        this.validateWorkflowTaskCount(release);
        this.validateNoMultiLevelNestedTasksForWorkflow(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$1)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoLockTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateNoUnsupportedTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoUnsupportedTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoMultiLevelNestedTasksForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoMultiLevelNestedTasks((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateTotalNoOfWorkflowTemplates(Release release) {
        if (release.isTemplate() && release.isWorkflow()) {
            String licenseEdition = this.getLicenseEdition();
            if (!ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$UNRESTRICTED_LICENSE_EDITIONS().contains((Object)licenseEdition)) {
                int totalWorkflowTemplates = this.releaseRepository.countTemplatesByKind(ReleaseKind.WORKFLOW);
                if (totalWorkflowTemplates >= ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$MAX_NO_WORKFLOW_TEMPLATES_ALLOWED()) {
                    throw new LicenseLimitReachedException("License limit reached. You have exceeded the limit on the number of workflow templates supported with your license.");
                }
                return;
            }
            return;
        }
    }

    private String getLicenseEdition() {
        License license = this.licenseService.getLicense();
        if (license.isDummyLicense()) {
            return LicenseVersion4.Edition4.Unregistered.name();
        }
        return this.licenseService.getLicense().getStringValue(LicenseProperty.EDITION);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$1) {
        return x$1 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, TaskPersistence taskPersistence, FolderRepository folderRepository, LicenseService licenseService, LimitEnforcer limitEnforcer) {
        this.releaseRepository = releaseRepository;
        this.taskPersistence = taskPersistence;
        this.folderRepository = folderRepository;
        this.licenseService = licenseService;
        this.limitEnforcer = limitEnforcer;
        WorkflowTaskValidator.$init$(this);
        WorkflowInterceptorLogic.$init$(this);
        Logging.$init$((Logging)this);
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

