/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceConstants$;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.SqlBinaryValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@CacheConfig(cacheManager="tenantCacheManager")
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u0010\u0001\u0003\u0006\u0004%\u0019A\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u007f!AA\n\u0001BC\u0002\u0013\rQ\n\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003O\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001di\u0007A1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%IA\u001c\u0005\u0007s\u0002\u0001\u000b\u0011B8\t\u000fi\u0004!\u0019!C\u0005]\"11\u0010\u0001Q\u0001\n=Dq\u0001 \u0001C\u0002\u0013%a\u000e\u0003\u0004~\u0001\u0001\u0006Ia\u001c\u0005\b}\u0002\u0011\r\u0011\"\u0003o\u0011\u0019y\b\u0001)A\u0005_\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA(\u0001\u0011\u0005\u0013\u0011\u000b\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!!&\u0001\t\u0003\n9\nC\u0004\u0002 \u0002!I!!)\u00031M\u000bH\u000eV3oC:$H*[7jiJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011adH\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001I\u0011\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001)3fL\u001b\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\taS&D\u0001\u001c\u0013\tq3DA\u000bUK:\fg\u000e\u001e'j[&$(+\u001a9pg&$xN]=\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IJ\u0012a\u00039feNL7\u000f^3oG\u0016L!\u0001N\u0019\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQa\u001d7gi)T\u0011AO\u0001\tOJL'P\u001f7fI&\u0011Ah\u000e\u0002\b\u0019><w-\u001b8h\u00031QGMY2UK6\u0004H.\u0019;f+\u0005y\u0004C\u0001!J\u001b\u0005\t%B\u0001\"D\u0003\u0011\u0019wN]3\u000b\u0005\u0011+\u0015\u0001\u00026eE\u000eT!AR$\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&B\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u00059A-[1mK\u000e$X#\u0001(\u0011\u0005=\u0013gB\u0001)`\u001d\t\tVL\u0004\u0002S7:\u00111K\u0017\b\u0003)fs!!\u0016-\u000e\u0003YS!aV\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002];\u0005\u0011AMY\u0005\u00035yS!\u0001X\u000f\n\u0005\u0001\f\u0017AC*rY\n+\u0018\u000e\u001c3fe*\u0011!DX\u0005\u0003G\u0012\u0014q\u0001R5bY\u0016\u001cGO\u0003\u0002aC\u0006AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0002QR\u0019\u0011n\u001b7\u0011\u0005)\u0004Q\"A\r\t\u000bu*\u00019A \t\u000b1+\u00019\u0001(\u0002=M#V\nV0T\u000b2+5\tV0M\u00136KEk\u0018\"Z?R+e*\u0011(U?&#U#A8\u0011\u0005A$hBA9s!\t)v%\u0003\u0002tO\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019x%A\u0010T)6#vlU#M\u000b\u000e#v\fT%N\u0013R{&)W0U\u000b:\u000be\nV0J\t\u0002\nac\u0015+N)~\u001bV\tT#D)~\u000bE\nT0M\u00136KEkU\u0001\u0018'RkEkX*F\u0019\u0016\u001bEkX!M\u0019~c\u0015*T%U'\u0002\n\u0011c\u0015+N)~KejU#S)~c\u0015*T%U\u0003I\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u0019&k\u0015\n\u0016\u0011\u0002#M#V\nV0V!\u0012\u000bE+R0M\u00136KE+\u0001\nT)6#v,\u0016)E\u0003R+u\fT%N\u0013R\u0003\u0013!E*U\u001bR{F)\u0012'F)\u0016{F*S'J)\u0006\u00112\u000bV'U?\u0012+E*\u0012+F?2KU*\u0013+!\u0003Q!XM\\1oi2KW.\u001b;S_^l\u0015\r\u001d9feV\u0011\u0011Q\u0001\t\u0006\u0001\u0006\u001d\u00111B\u0005\u0004\u0003\u0013\t%!\u0003*po6\u000b\u0007\u000f]3s!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t;\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!!\u0006\u0002\u0010\tYA+\u001a8b]Rd\u0015.\\5u\u0003U!XM\\1oi2KW.\u001b;S_^l\u0015\r\u001d9fe\u0002\naBZ5oI\nKH+\u001a8b]RLE\r\u0006\u0003\u0002\u001e\u0005\r\u0002#\u0002\u0014\u0002 \u0005-\u0011bAA\u0011O\t1q\n\u001d;j_:Da!!\n\u0013\u0001\u0004y\u0017\u0001\u0003;f]\u0006tG/\u00133)\u0007I\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#Y\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u00024\u00055\"AC%t%\u0016\fGm\u00148ms\":!#a\u000e\u0002H\u0005%\u0003\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u000bC:tw\u000e^1uS>t'bAA!\u000b\u0006)1-Y2iK&!\u0011QIA\u001e\u0005%\u0019\u0015m\u00195fC\ndW-\u0001\u0006dC\u000eDWMT1nKNd#!a\u0013\"\u0005\u00055\u0013!\u0004;f]\u0006tG/\f7j[&$8/A\u0004gS:$\u0017\t\u001c7\u0015\u0005\u0005M\u0003CBA+\u0003?\nYA\u0004\u0003\u0002X\u0005mcbA+\u0002Z%\t\u0001&C\u0002\u0002^\u001d\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0005\r$aA*fc*\u0019\u0011QL\u0014)\u0007M\tI\u0003K\u0004\u0014\u0003o\t9%!\u001b-\u0005\u0005-\u0014EAA7\u0003E\tG\u000e\\\u0017uK:\fg\u000e^\u0017mS6LGo]\u0001\u0007GJ,\u0017\r^3\u0015\t\u0005-\u00111\u000f\u0005\b\u0003k\"\u0002\u0019AA\u0006\u0003\u0015a\u0017.\\5uQ-!\u0012\u0011PA$\u0003\u007f\n\t)a!\u0011\t\u0005e\u00121P\u0005\u0005\u0003{\nYD\u0001\u0006DC\u000eDW-\u0012<jGRdC!a\u001b\u0002L\u0005Q\u0011\r\u001c7F]R\u0014\u0018.Z:\u001a\u0003\u0005\ta!\u001e9eCR,G\u0003BAE\u0003\u001f\u00032AJAF\u0013\r\tii\n\u0002\u0005+:LG\u000fC\u0004\u0002vU\u0001\r!a\u0003)\u0017U\tI(a\u0012\u0002\u0014\u0006\u0005\u00151\u0011\u0017\u0005\u0003W\nY%\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0013\u000bI\n\u0003\u0004\u0002&Y\u0001\ra\u001c\u0015\f-\u0005e\u0014qIAO\u0003\u0003\u000b\u0019\t\f\u0003\u0002l\u0005-\u0013!C:fe&\fG.\u001b>f)\ry\u00171\u0015\u0005\b\u0003k:\u0002\u0019AA\u0006Q\r\u0001\u0011q\u0015\t\u0005\u0003W\tI+\u0003\u0003\u0002,\u00065\"aD%t)J\fgn]1di&|g.\u00197)\u000f\u0001\ty+!.\u00028B!\u0011\u0011HAY\u0013\u0011\t\u0019,a\u000f\u0003\u0017\r\u000b7\r[3D_:4\u0017nZ\u0001\rG\u0006\u001c\u0007.Z'b]\u0006<WM]\u0011\u0003\u0003s\u000b!\u0003^3oC:$8)Y2iK6\u000bg.Y4fe\u0002")
public class SqlTenantLimitRepository
implements TenantLimitRepository,
PersistenceSupport,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final String STMT_SELECT_LIMIT_BY_TENANT_ID;
    private final String STMT_SELECT_ALL_LIMITS;
    private final String STMT_INSERT_LIMIT;
    private final String STMT_UPDATE_LIMIT;
    private final String STMT_DELETE_LIMIT;
    private final RowMapper<TenantLimit> tenantLimitRowMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public Long sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsertTask$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsertTask(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Long, R> mapper) {
        return (R)PersistenceSupport.sqlInsertTask$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    public TenantLimit getEffectiveLimit(String tenantId) {
        return TenantLimitRepository.getEffectiveLimit$((TenantLimitRepository)this, (String)tenantId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTenantLimitRepository sqlTenantLimitRepository = this;
        synchronized (sqlTenantLimitRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlTenantLimitRepository sqlTenantLimitRepository = this;
        synchronized (sqlTenantLimitRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    private String STMT_SELECT_LIMIT_BY_TENANT_ID() {
        return this.STMT_SELECT_LIMIT_BY_TENANT_ID;
    }

    private String STMT_SELECT_ALL_LIMITS() {
        return this.STMT_SELECT_ALL_LIMITS;
    }

    private String STMT_INSERT_LIMIT() {
        return this.STMT_INSERT_LIMIT;
    }

    private String STMT_UPDATE_LIMIT() {
        return this.STMT_UPDATE_LIMIT;
    }

    private String STMT_DELETE_LIMIT() {
        return this.STMT_DELETE_LIMIT;
    }

    private RowMapper<TenantLimit> tenantLimitRowMapper() {
        return this.tenantLimitRowMapper;
    }

    @IsReadOnly
    @Cacheable(cacheNames={"tenant-limits"})
    public Option<TenantLimit> findByTenantId(String tenantId) {
        None$ none$;
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("tenantId", (Object)tenantId);
            TenantLimit limit = (TenantLimit)this.namedTemplate().queryForObject(this.STMT_SELECT_LIMIT_BY_TENANT_ID(), (SqlParameterSource)params, this.tenantLimitRowMapper());
            none$ = new Some((Object)limit);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @IsReadOnly
    @Cacheable(cacheNames={"all-tenant-limits"})
    public Seq<TenantLimit> findAll() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.namedTemplate().query(this.STMT_SELECT_ALL_LIMITS(), this.tenantLimitRowMapper())).asScala().toSeq();
    }

    @CacheEvict(cacheNames={"all-tenant-limits", "tenant-limits"}, allEntries=true)
    public TenantLimit create(TenantLimit limit) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("tenantId", (Object)limit.getTenantId());
        params.addValue("limitData", (Object)new SqlBinaryValue(this.serialize(limit).getBytes(StandardCharsets.UTF_8)), PersistenceConstants$.MODULE$.BLOB_TYPE());
        this.namedTemplate().update(this.STMT_INSERT_LIMIT(), (SqlParameterSource)params);
        return limit;
    }

    @CacheEvict(cacheNames={"all-tenant-limits", "tenant-limits"}, allEntries=true)
    public void update(TenantLimit limit) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("tenantId", (Object)limit.getTenantId());
        params.addValue("limitData", (Object)new SqlBinaryValue(this.serialize(limit).getBytes(StandardCharsets.UTF_8)), PersistenceConstants$.MODULE$.BLOB_TYPE());
        int rowsAffected = this.namedTemplate().update(this.STMT_UPDATE_LIMIT(), (SqlParameterSource)params);
        if (rowsAffected == 0) {
            throw new IllegalArgumentException("Tenant limit with tenant ID '" + limit.getTenantId() + "' does not exist");
        }
    }

    @CacheEvict(cacheNames={"all-tenant-limits", "tenant-limits"}, allEntries=true)
    public void delete(String tenantId) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("tenantId", (Object)tenantId);
        this.namedTemplate().update(this.STMT_DELETE_LIMIT(), (SqlParameterSource)params);
    }

    private String serialize(TenantLimit limit) {
        limit.setId(limit.getTenantId());
        return CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)limit);
    }

    public SqlTenantLimitRepository(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        TenantLimitRepository.$init$((TenantLimitRepository)this);
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_SELECT_LIMIT_BY_TENANT_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n       | " + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + ",\n       | " + Schema.TENANT_LIMITS$.MODULE$.LIMIT_DATA() + "\n       |FROM " + Schema.TENANT_LIMITS$.MODULE$.TABLE() + "\n       |WHERE " + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + " = :tenantId"));
        this.STMT_SELECT_ALL_LIMITS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT\n       | " + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + ",\n       | " + Schema.TENANT_LIMITS$.MODULE$.LIMIT_DATA() + "\n       |FROM " + Schema.TENANT_LIMITS$.MODULE$.TABLE()));
        this.STMT_INSERT_LIMIT = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TENANT_LIMITS$.MODULE$.TABLE() + "\n       | (" + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + ", " + Schema.TENANT_LIMITS$.MODULE$.LIMIT_DATA() + ")\n       |VALUES (:tenantId, :limitData)"));
        this.STMT_UPDATE_LIMIT = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.TENANT_LIMITS$.MODULE$.TABLE() + "\n       |SET " + Schema.TENANT_LIMITS$.MODULE$.LIMIT_DATA() + " = :limitData\n       |WHERE " + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + " = :tenantId"));
        this.STMT_DELETE_LIMIT = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TENANT_LIMITS$.MODULE$.TABLE() + "\n       |WHERE " + Schema.TENANT_LIMITS$.MODULE$.TENANT_ID() + " = :tenantId"));
        this.tenantLimitRowMapper = (rs, x$1) -> {
            String tenantId = rs.getString(Schema.TENANT_LIMITS$.MODULE$.TENANT_ID());
            byte[] limitDataBytes = rs.getBytes(Schema.TENANT_LIMITS$.MODULE$.LIMIT_DATA());
            String limitDataJson = new String(limitDataBytes, StandardCharsets.UTF_8);
            TenantLimit limit = (TenantLimit)CiSerializerHelper$.MODULE$.deserialize(limitDataJson, null);
            limit.setTenantId(tenantId);
            return limit;
        };
    }
}

