package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.CustomLogoSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

/**
 * Creates the CustomLogoSettings by default
 * If an instance is new it will create it
 * If an instance is being upgraded and never created the settings, it will create
 */
@Component
class XLRelease2410CustomLogoSettingsUpgrade(configurationRepository: ConfigurationRepository) extends BaseInitializingUpgrade with Logging {

  override def doUpgrade(): Boolean = {
    if (!configurationRepository.exists(CustomLogoSettings.CUSTOM_LOGO_SETTINGS_ID)) {
      val customLogo: CustomLogoSettings = Type.valueOf(classOf[CustomLogoSettings]).getDescriptor.newInstance(CustomLogoSettings.CUSTOM_LOGO_SETTINGS_ID)
      configurationRepository.create(customLogo)
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#2")
}
