/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnEnabledHealthIndicator(value="db")
public class DatasourceHealthAutoConfiguration {
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private DataSourcePoolMetadataProvider poolMetadataProvider;
    private HikariDataSource rawReportingDataSource;
    private HikariDataSource rawRepositoryDataSource;

    public DatasourceHealthAutoConfiguration(@Qualifier(value="rawReportingDataSource") HikariDataSource rawReportingDataSource, @Qualifier(value="rawRepositoryDataSource") HikariDataSource rawRepositoryDataSource, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        this.metadataProviders = metadataProviders.orderedStream().toList();
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider(this.metadataProviders);
        this.rawRepositoryDataSource = rawRepositoryDataSource;
        this.rawReportingDataSource = rawReportingDataSource;
    }

    @Bean
    public HealthContributor dbHealth() {
        return this.createContributor(Map.of("rawReportingDataSource", this.rawReportingDataSource, "rawRepositoryDataSource", this.rawRepositoryDataSource));
    }

    private HealthContributor createContributor(Map<String, HikariDataSource> beans) {
        Assert.notEmpty(beans, (String)"Beans must not be empty");
        if (beans.size() == 1) {
            return this.createContributor(beans.values().iterator().next());
        }
        return CompositeHealthContributor.fromMap(beans, this::createContributor);
    }

    private HealthContributor createContributor(HikariDataSource source) {
        return new DataSourceHealthIndicator((DataSource)source, source.getConnectionTestQuery());
    }
}

