package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.domain.{Dependency, GateTask}
import com.xebialabs.xlrelease.repository.sql.persistence.TaskCiUid
import com.xebialabs.xlrelease.utils.FolderId

case class DependencyRow(folderId: FolderId,
                         taskId: String,
                         taskCiUid: TaskCiUid,
                         dependencyId: String,
                         gateStatus: String,
                         gateReleaseStatus: String,
                         targetRow: TargetRow)

object DependencyRow {
  def apply(folderId: FolderId,
            taskId: String,
            taskCiUid: TaskCiUid,
            dependencyId: String,
            gateStatus: String,
            gateReleaseStatus: String,
            targetReleaseId: Option[String],
            targetId: String): DependencyRow = new DependencyRow(folderId, taskId, taskCiUid, dependencyId, gateStatus, gateReleaseStatus, TargetRow(targetReleaseId, Option(targetId)))

  implicit class DependencyRowOps(val data: DependencyRow) {
    def fullDependencyId: String =
      (data.folderId / data.taskId / data.dependencyId).absolute

    def targetReleaseId: Option[String] = data.targetRow.releaseId

    def targetId: String = data.targetRow.targetId.orNull

    def asDependency: Dependency = {
      val gateTaskId = (data.folderId / data.taskId).absolute
      val dependency = new Dependency
      dependency.setId(
        gateTaskId ++ "/" ++ data.dependencyId
      )
      val gateTaskStatus = TaskStatus.valueOf(data.gateStatus.toUpperCase)

      val gateTask = Type.valueOf(classOf[GateTask]).getDescriptor.newInstance[GateTask](gateTaskId)
      gateTask.setCiUid(data.taskCiUid)
      gateTask.setStatus(gateTaskStatus)
      gateTask.addDependency(dependency)
      dependency.setGateTask(gateTask)
      dependency.setTargetId(data.targetRow.getTargetId.orNull)

      dependency
    }
  }

  implicit class DependencyDataSeqOps(val dataList: Seq[DependencyRow]) {
    def asDependencies: Seq[Dependency] = dataList.map(_.asDependency)
  }

}
