package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow
import com.xebialabs.xlrelease.utils.Tree
import com.xebialabs.xlrelease.utils.Tree.Node

import scala.collection.mutable

object FolderTreeUtils {
  // Note: this assumes the results are given from top to bottom, with the first entry being the one asked for.
  def buildTree(topDownRows: mutable.Buffer[FolderRow]): Tree[FolderRow] = topDownRows.toList match {
    case Nil => Tree.empty[FolderRow]
    case root :: rest =>
      val rowMap = rest.groupBy(_.parentUid)
      buildTree0(root, rowMap)
  }

  protected def buildTree0(row: FolderRow, rowsMap: Map[CiUid, List[FolderRow]]): Node[FolderRow] = {
    rowsMap.get(row.uid).fold(Node(row)) { children =>
      val rest = rowsMap - row.uid
      Node(row, children.map(buildTree0(_, rest)))
    }
  }

}
