package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.CacheManagementConstants._
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.security.DistributedUserGroupEventListener
import com.xebialabs.xlrelease.security.sql.UserGroupCacheConfigurationCondition
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.context.annotation.{Bean, Conditional, Configuration}

@Configuration
@Conditional(value = Array(classOf[UserGroupCacheConfigurationCondition]))
class UserGroupCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean(name = Array(SECURITY_USER_GROUP_CACHE_MANAGER))
  def securityUserGroupCacheManager(): CacheManager = {
    new XlrCaffeineCacheManager(SECURITY_USER_GROUP_CACHE_MANAGER, xlrConfig.getCacheSettings())
  }

  @Bean
  def distributedUserGroupEventListener(): DistributedUserGroupEventListener = {
    new DistributedUserGroupEventListener(securityUserGroupCacheManager())
  }

}
