package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.{BaseConfiguration, Configuration}
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, PersistenceInterceptor}
import com.xebialabs.xlrelease.utils.TenantContext
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
@IsTransactional
class ConfigurationLimitPersistenceInterceptor(limitEnforcer: LimitEnforcer,
                                               configurationRepository: ConfigurationRepository)
  extends PersistenceInterceptor[BaseConfiguration] with Logging {

  configurationRepository.registerPersistenceInterceptor(this)

  override def onCreate(ci: BaseConfiguration): Unit = {
    if (ci.isInstanceOf[Configuration]) {
      val  tenantId = TenantContext.getTenant()
      limitEnforcer.enforceLimit(tenantId, LimitType.CONNECTIONS, 1, () => configurationRepository.tenantConnectionCount(tenantId))
    }
  }
}

