package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence.ConfigurationRow

trait ConfigurationRowReader {
  def sqlRepositoryAdapter: SqlRepositoryAdapter

  def readConfiguration[T <: BaseConfiguration](row: ConfigurationRow): Option[T] = {
    row match {
      case (folderIdOpt, rawConfiguration, ciUid) =>
        sqlRepositoryAdapter.deserialize[T](rawConfiguration).map { conf =>
          conf.setCiUid(ciUid)
          folderIdOpt.fold(conf) { folderId =>
            conf.setFolderId(folderId.absolute)
            conf
          }
        }
    }
  }
}
