package com.xebialabs.xlrelease.repository.sql.query

import com.xebialabs.xlrelease.api.v1.filters.RolePrincipalsFilters
import com.xebialabs.xlrelease.db.sql.DatabaseInfo
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.query.FiltersQueryBuilder
import com.xebialabs.xlrelease.security.SqlReleaseRoleRepository.GlobalRolePrincipalTableView
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate

trait RolePrincipalsQueryBuilder extends FiltersQueryBuilder[RolePrincipalsFilters, GlobalRolePrincipalTableView]

object RolePrincipalsQueryBuilder {
  def apply(dbInfo: DatabaseInfo, dialect: Dialect, jdbcTemplate: NamedParameterJdbcTemplate): RolePrincipalsQueryBuilder = {
    new SqlRolePrincipalsQueryBuilder(dbInfo, dialect, jdbcTemplate)
  }
}