package com.xebialabs.xlrelease.repository.sql.security

import com.xebialabs.xlrelease.domain.distributed.events.EvictRolesEvent
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.repository.SecuredCis
import com.xebialabs.xlrelease.service.BroadcastService
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

import scala.util.{Failure, Success, Try}

@Component
@EventListener
class TeamEventHandler(broadcastService: BroadcastService, securedCis: SecuredCis) extends Logging {

  @Subscribe
  def onEvent(event: TeamEvent): Unit = {
    val ciId: String = event match {
      case TeamCreatedEvent(containerId, _) => containerId
      case TeamUpdatedEvent(containerId, _, _) => containerId
      case TeamDeletedEvent(containerId, _) => containerId
      case TeamsMergedEvent(templateId, _) => templateId
      case TeamsRemovedInTemplateEvent(templateId, _) => templateId
    }
    logger.debug(s"Publishing event to evict cache for configurationItem [$ciId]")
    Try(securedCis.getSecuredCi(ciId)) match {
      case Success(securityId) =>
        broadcastService.broadcast(EvictRolesEvent(securityId.getSecurityUid), publishEventOnSelf = true)
      case Failure(ex) => logger.error(ex)
    }
  }
}
