package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.limits.LimitEnforcer
import com.xebialabs.xlrelease.limits.LimitEnforcer.LimitType

private[sql] trait ReleaseVariableLimitValidator {
  def limitEnforcer: LimitEnforcer

  def enforceReleaseVariableLimits(ci: Release, tenantId: String): Unit = {
    if (!ci.getStatus.isInactive) {
      // Enforce release variable count limit
      limitEnforcer.enforceLimit(tenantId, LimitType.RELEASE_VARIABLES, 0, () => ci.getVariables.size())
    }
  }

}
