/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.limits.LimitEnforcer;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.sql.VariableSizeLimitValidator;
import com.xebialabs.xlrelease.utils.TenantContext$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u0006\r\u0001]A\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0006\u0001\"\u0003^\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015!\b\u0001\"\u0003v\u0005%2u\u000e\u001c3feZ\u000b'/[1cY\u0016d\u0015.\\5u!\u0016\u00148/[:uK:\u001cW-\u00138uKJ\u001cW\r\u001d;pe*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011#\u0002\u0001\u0019A1\u0002\u0004CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011a\u0017M\\4\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0005\u0012C%D\u0001\u000f\u0013\t\u0019cB\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s!\t)#&D\u0001'\u0015\t9\u0003&A\u0005wCJL\u0017M\u00197fg*\u0011\u0011\u0006E\u0001\u0007I>l\u0017-\u001b8\n\u0005-2#\u0001\u0003,be&\f'\r\\3\u0011\u00055rS\"\u0001\u0007\n\u0005=b!A\u0007,be&\f'\r\\3TSj,G*[7jiZ\u000bG.\u001b3bi>\u0014\bCA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005)\u0014\u0001C4sSjTH.\u001a3\n\u0005]\u0012$a\u0002'pO\u001eLgnZ\u0001\u000eY&l\u0017\u000e^#oM>\u00148-\u001a:\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\t\u0002\r1LW.\u001b;t\u0013\tyDHA\u0007MS6LG/\u00128g_J\u001cWM]\u0001\u000fY&l\u0017\u000e^#oM>\u00148-\u001a:!\u0003A1w\u000e\u001c3feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\"\u0007&\u0011AI\u0004\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pef\f\u0001DZ8mI\u0016\u0014h+\u0019:jC\ndWMU3q_NLGo\u001c:z!\t\ts)\u0003\u0002I\u001d\tAbi\u001c7eKJ4\u0016M]5bE2,'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u00055\u0002\u0001\"\u0002\u001d\u0006\u0001\u0004Q\u0004\"B!\u0006\u0001\u0004\u0011\u0005\"B#\u0006\u0001\u00041\u0015\u0001C8o\u0007J,\u0017\r^3\u0015\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRDQ\u0001\u0017\u0004A\u0002\u0011\n\u0001B^1sS\u0006\u0014G.Z\u0001\t_:,\u0006\u000fZ1uKR\u0011\u0011k\u0017\u0005\u00061\u001e\u0001\r\u0001J\u0001\u0011SN4u\u000e\u001c3feZ\u000b'/[1cY\u0016$\"AX1\u0011\u0005I{\u0016B\u00011T\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0017\u0005A\u0002\u0011\nQdZ3u\u0007V\u0014(/\u001a8u\r>dG-\u001a:WCJL\u0017M\u00197f\u0007>,h\u000e\u001e\u000b\u0003I\u001e\u0004\"AU3\n\u0005\u0019\u001c&aA%oi\")\u0001.\u0003a\u0001S\u0006Aam\u001c7eKJLE\r\u0005\u0002kc:\u00111n\u001c\t\u0003YNk\u0011!\u001c\u0006\u0003]Z\ta\u0001\u0010:p_Rt\u0014B\u00019T\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u001c\u0016!F4fiR+g.\u00198u\u0013\u00124%o\\7G_2$WM\u001d\u000b\u0003SZDQ\u0001\u001b\u0006A\u0002%D#\u0001\u0001=\u0011\u0007e\f\t!D\u0001{\u0015\tYH0\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T!! @\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a`\u0001\u0004_J<\u0017bAA\u0002u\nI1i\\7q_:,g\u000e\u001e\u0015\u0004\u0001\u0005\u001d\u0001\u0003BA\u0005\u0003+i!!a\u0003\u000b\t\u00055\u0011qB\u0001\fiJ\fgn]1di&|gNC\u0002\u000e\u0003#Q1!a\u0005\u0011\u0003\t!'-\u0003\u0003\u0002\u0018\u0005-!aD%t)J\fgn]1di&|g.\u00197")
public class FolderVariableLimitPersistenceInterceptor
implements PersistenceInterceptor<Variable>,
VariableSizeLimitValidator,
Logging {
    private final LimitEnforcer limitEnforcer;
    private final FolderRepository folderRepository;
    private final FolderVariableRepository folderVariableRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void enforceVariableSizeLimits(Release ci, String tenantId) {
        VariableSizeLimitValidator.enforceVariableSizeLimits$((VariableSizeLimitValidator)this, ci, tenantId);
    }

    @Override
    public void enforceVariableSizeLimits(Variable ci, String tenantId) {
        VariableSizeLimitValidator.enforceVariableSizeLimits$((VariableSizeLimitValidator)this, ci, tenantId);
    }

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderVariableLimitPersistenceInterceptor folderVariableLimitPersistenceInterceptor = this;
        synchronized (folderVariableLimitPersistenceInterceptor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public LimitEnforcer limitEnforcer() {
        return this.limitEnforcer;
    }

    public void onCreate(Variable variable) {
        if (this.isFolderVariable(variable)) {
            this.logger().debug((Function0 & Serializable)() -> "[FolderVariableLimitPersistenceInterceptor] Enforcing folder variable limits for folder: " + variable.getFolderId() + ", key: " + variable.getKey());
            String tenantId = this.getTenantIdFromFolder(variable.getFolderId());
            this.limitEnforcer().enforceLimit(tenantId, LimitEnforcer.LimitType.FOLDER_VARIABLES, 1, () -> this.getCurrentFolderVariableCount(variable.getFolderId()));
            this.enforceVariableSizeLimits(variable, tenantId);
            return;
        }
    }

    public void onUpdate(Variable variable) {
        if (this.isFolderVariable(variable)) {
            String tenantId = this.getTenantIdFromFolder(variable.getFolderId());
            this.enforceVariableSizeLimits(variable, tenantId);
            return;
        }
    }

    private boolean isFolderVariable(Variable variable) {
        return variable.getFolderId() != null && StringUtils.hasText((String)variable.getFolderId());
    }

    private int getCurrentFolderVariableCount(String folderId) {
        int n;
        try {
            n = this.folderVariableRepository.getAllFromParent(folderId).size();
        }
        catch (Exception ex) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to get current folder variable count for folder " + folderId, (Function0 & Serializable)() -> ex);
            n = 0;
        }
        return n;
    }

    private String getTenantIdFromFolder(String folderId) {
        String tenantIdFromContext = TenantContext$.MODULE$.getTenant();
        if (StringUtils.hasText((String)tenantIdFromContext)) {
            return tenantIdFromContext;
        }
        return this.folderRepository.getFolderTenant(folderId);
    }

    public FolderVariableLimitPersistenceInterceptor(LimitEnforcer limitEnforcer, FolderRepository folderRepository, FolderVariableRepository folderVariableRepository) {
        this.limitEnforcer = limitEnforcer;
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        VariableSizeLimitValidator.$init$(this);
        Logging.$init$((Logging)this);
        folderVariableRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

