package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.util.Try

@Component
class XLRelease2610FeatureSettingsSchemaUpgrade @Autowired()(configurationRepository: ConfigurationRepository) extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "26.1.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Upgrading feature settings schema")
    val allFeatureSettings = configurationRepository.findAllByType[FeatureSettings](Type.valueOf(classOf[FeatureSettings])).asScala
    allFeatureSettings.foreach { featureSetting =>
      Try {
        configurationRepository.update(featureSetting)
        logger.info(s"Updated configuration of type ${featureSetting.getType}")
      }.recover {
        case e: Exception =>
          logger.error(s"Failed to update configuration of type ${featureSetting.getType}: ${e.getMessage}", e)
      }
    }
    logger.info("Completed feature settings schema upgrade")
    true
  }
}