package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.SECURITY_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.features.CacheManagementFeature
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import com.xebialabs.xlrelease.support.cache.config.ConfigCacheSettings
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class SecurityCacheConfiguration(xlrConfig: XlrConfig) {

  @Bean(name = Array(SECURITY_CACHE_MANAGER))
  def securityCacheManager(): XlrCaffeineCacheManager = {
    val configSetting = xlrConfig.getCacheSettings("security").asInstanceOf[ConfigCacheSettings]
    val withFeatureSettings = configSetting.withFeatureSettings(CacheManagementFeature)
    new XlrCaffeineCacheManager(SECURITY_CACHE_MANAGER, withFeatureSettings)
  }

}

