/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.utils.Tree;
import com.xebialabs.xlrelease.domain.utils.Tree$;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u0001\u0003\u00015\u00111cU9m\r>dG-\u001a:SKB|7/\u001b;pefT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005Q!/\u001a9pg&$xN]=\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u001dQAB\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011\u0001CR8mI\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!!D*rYJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)1\u000f\u001c45U*\t\u0011%\u0001\u0005he&T(\u0010\\3e\u0013\t\u0019cDA\u0004M_\u001e<\u0017N\\4\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\n\u0011CZ8mI\u0016\u0014\b+\u001a:tSN$XM\\2f!\t9#&D\u0001)\u0015\tI#!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA\u0016)\u0005E1u\u000e\u001c3feB+'o]5ti\u0016t7-\u001a\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t9s&\u0003\u00021Q\t\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014A\u0004;fC6\u0014V\r]8tSR|'/\u001f\t\u0003+QJ!!\u000e\u0003\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\bCA\u001d?\u001b\u0005Q$BA\u001e=\u0003!\u0019XmY;sSRL(BA\u001f\t\u0003!!W\r\u001d7ps&$\u0018BA ;\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\t\u0011\u0005\u0003!Q1A\u0005\u0002\t\u000b\u0001\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u0011%tG/\u001a:oC2T!\u0001\u0013\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002K\u000b\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0011!a\u0005A!A!\u0002\u0013\u0019\u0015!\u00053fG>\u0014\u0018\r^8s'\u0016\u0014h/[2fA!Aa\n\u0001BC\u0002\u0013\rq*\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001Q!\t\t&,D\u0001S\u0015\t\u0019F+\u0001\u0003d_J,'BA+W\u0003\u0011QGMY2\u000b\u0005]C\u0016aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003e\u000b1a\u001c:h\u0013\tY&K\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\r\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003Q\u00035QGMY2UK6\u0004H.\u0019;fA!Aq\f\u0001BC\u0002\u0013\r\u0001-A\u0004eS\u0006dWm\u0019;\u0016\u0003\u0005\u0004\"AY;\u000f\u0005\r\u0014hB\u00013q\u001d\t)gN\u0004\u0002g[:\u0011q\r\u001c\b\u0003Q.l\u0011!\u001b\u0006\u0003U2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tyg!\u0001\u0002eE&\u00111!\u001d\u0006\u0003_\u001aI!a\u001d;\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u0004c&\u0011ao\u001e\u0002\b\t&\fG.Z2u\u0015\t\u0019H\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003b\u0003!!\u0017.\u00197fGR\u0004\u0003\"B>\u0001\t\u0003a\u0018A\u0002\u001fj]&$h\bF\u0007~}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011\u0002\t\u00033\u0001AQ!\n>A\u0002\u0019BQ!\f>A\u00029BQA\r>A\u0002MBQa\u000e>A\u0002aBQ!\u0011>A\u0002\rCQA\u0014>A\u0004ACQa\u0018>A\u0004\u0005Dq!!\u0004\u0001\t\u0003\ny!\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003#\t9\u0002E\u0002\u0010\u0003'I1!!\u0006\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0007\u0002\f\u0001\u0007\u00111D\u0001\tM>dG-\u001a:JIB!\u0011QDA\u0013\u001d\u0011\ty\"!\t\u0011\u0005!\u0004\u0012bAA\u0012!\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t\u0011Q\u0011\tY!!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\ru\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005]\u0012\u0011\u0007\u0002\u000b\u0013N\u0014V-\u00193P]2L\b\u0006BA\u0006\u0003w\u0001B!!\u0010\u0002L5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0006b]:|G/\u0019;j_:TA!!\u0012\u0002H\u00059Q.\u001a;sS\u000e\u001c(bAA%\u0015\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002N\u0005}\"!\u0002+j[\u0016$\u0007bBA)\u0001\u0011\u0005\u00131K\u0001\tO\u0016$H+\u001b;mKR!\u0011QKA.!\u0015y\u0011qKA\u000e\u0013\r\tI\u0006\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005e\u0011q\na\u0001\u00037AC!a\u0014\u0002.!\"\u0011qJA\u001e\u0011\u001d\t\u0019\u0007\u0001C!\u0003K\nqaZ3u!\u0006$\b\u000e\u0006\u0003\u0002h\u0005e\u0004CBA5\u0003g\nYB\u0004\u0003\u0002l\u0005=db\u00015\u0002n%\t\u0011#C\u0002\u0002rA\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002v\u0005]$aA*fc*\u0019\u0011\u0011\u000f\t\t\u0011\u0005e\u0011\u0011\ra\u0001\u00037AC!!\u0019\u0002.!\"\u0011\u0011MA\u001e\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007\u000baaZ3u+&$G\u0003BAC\u0003;\u0003B!a\"\u0002\u0018:!\u0011\u0011RAK\u001d\u0011\tY)a%\u000f\t\u00055\u0015\u0011\u0013\b\u0004K\u0006=\u0015BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002*\u0005%\u0019\u0011\u0011\u000f\u0015\n\t\u0005e\u00151\u0014\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0004\u0003cB\u0003\u0002CA\r\u0003\u007f\u0002\r!a\u0007)\t\u0005}\u0014Q\u0006\u0015\u0005\u0003\u007f\nY\u0004C\u0004\u0002&\u0002!\t%a*\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$b!!+\u0002<\u0006u\u0006#B\b\u0002X\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\u0007M>dG-\u001a:\u000b\u0007\u0005Uf!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003s\u000byK\u0001\u0004G_2$WM\u001d\u0005\t\u00033\t\u0019\u000b1\u0001\u0002\u001c!Q\u0011qXAR!\u0003\u0005\r!!1\u0002\u000b\u0011,\u0007\u000f\u001e5\u0011\u0007=\t\u0019-C\u0002\u0002FB\u00111!\u00138uQ\u0011\t\u0019+a\u000f\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\u0006\u0019B.[:u-&,w/\u00192mK\u001a{G\u000eZ3sgRA\u0011qZAi\u0003+\fy\u000e\u0005\u0004\u0002j\u0005M\u00141\u0016\u0005\t\u0003'\fI\r1\u0001\u0002\u001c\u0005A\u0001/\u0019:f]RLE\r\u0003\u0005\u0002X\u0006%\u0007\u0019AAm\u0003\u0011\u0001\u0018mZ3\u0011\u0007U\tY.C\u0002\u0002^\u0012\u0011A\u0001U1hK\"Q\u0011\u0011]Ae!\u0003\u0005\r!!\u0005\u0002/\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5QKJl\u0017n]:j_:\u001c\b\u0006BAe\u0003wAq!a:\u0001\t\u0003\tI/\u0001\rtKR\f5/\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z\u0013\u0012$B!a;\u0002rB\u0019q\"!<\n\u0007\u0005=\bC\u0001\u0003V]&$\b\u0002CA\r\u0003K\u0004\r!a\u0007)\t\u0005\u0015\u00181\b\u0005\b\u0003o\u0004A\u0011AA}\u0003iIg\u000e[3sSR,eMZ3di&4XmU3dkJLG/_%e)\u0011\tY/a?\t\u0011\u0005e\u0011Q\u001fa\u0001\u00037AC!!>\u0002<!9!\u0011\u0001\u0001\u0005B\t\r\u0011AB2sK\u0006$X\r\u0006\u0004\u0002,\n\u0015!q\u0001\u0005\t\u0003'\fy\u00101\u0001\u0002\u001c!A\u0011\u0011WA\u0000\u0001\u0004\tY\u000b\u000b\u0003\u0002\u0000\u0006m\u0002b\u0002B\u0007\u0001\u0011\u0005#qB\u0001\u0007I\u0016dW\r^3\u0015\r\u0005-(\u0011\u0003B\n\u0011!\tIBa\u0003A\u0002\u0005m\u0001B\u0003B\u000b\u0005\u0017\u0001\n\u00111\u0001\u0003\u0018\u0005iA-\u001a7fi\u0016\u0014V\r\\3bg\u0016\u0004\u0012b\u0004B\r\u0003\u0003\fY\"a;\n\u0007\tm\u0001CA\u0005Gk:\u001cG/[8oe!\"!1BA\u001e\u0011\u001d\u0011\t\u0003\u0001C!\u0005G\taA]3oC6,GCBAV\u0005K\u00119\u0003\u0003\u0005\u0002\u001a\t}\u0001\u0019AA\u000e\u0011!\u0011ICa\bA\u0002\u0005m\u0011a\u00028fo:\u000bW.\u001a\u0015\u0005\u0005?\tY\u0004C\u0004\u00030\u0001!\tE!\r\u0002\t5|g/\u001a\u000b\u0007\u0003W\u0013\u0019D!\u000e\t\u0011\u0005e!Q\u0006a\u0001\u00037A\u0001Ba\u000e\u0003.\u0001\u0007\u00111D\u0001\f]\u0016<\b+\u0019:f]RLE\r\u000b\u0003\u0003.\u0005m\u0002b\u0002B\u001f\u0001\u0011\u0005#qH\u0001\u000bM&tGMQ=QCRDGCBAV\u0005\u0003\u0012)\u0005\u0003\u0005\u0003D\tm\u0002\u0019AA\u000e\u0003%!\u0018\u000e\u001e7f!\u0006$\b\u000e\u0003\u0006\u0002@\nm\u0002\u0013!a\u0001\u0003\u0003DCAa\u000f\u0002<!9!1\n\u0001\u0005B\t5\u0013\u0001\u00064j]\u0012\u001cVO\u0019$pY\u0012,'OQ=USRdW\r\u0006\u0004\u0002*\n=#\u0011\u000b\u0005\t\u0003'\u0014I\u00051\u0001\u0002\u001c!A!1\u000bB%\u0001\u0004\tY\"\u0001\u0003oC6,\u0007\u0006\u0002B%\u0003wA\u0001B!\u0017\u0001\t\u0003\u0011!1L\u0001\u0019M&tGmU;c\r>dG-\u001a:ECR\f')\u001f+ji2,GC\u0002B/\u0005W\u0012i\u0007E\u0003\u0010\u0003/\u0012y\u0006\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)\u0007K\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0003j\t\r$!\u0003$pY\u0012,'OU8x\u0011!\tIBa\u0016A\u0002\u0005m\u0001\u0002\u0003B*\u0005/\u0002\r!a\u0007\t\u0011\tE\u0004\u0001\"\u0001\u0003\u0005g\n!\"\u001b8tKJ$hj\u001c3f)!\u0011)Ha$\u0003\u0012\nU\u0005C\u0002B<\u0005\u0013\u0013yF\u0004\u0003\u0003z\t\re\u0002\u0002B>\u0005\u007fr1!\u001aB?\u0013\r\t)LB\u0005\u0005\u0005\u0003\u000b\u0019,A\u0003vi&d7/\u0003\u0003\u0003\u0006\n\u001d\u0015\u0001\u0002+sK\u0016TAA!!\u00024&!!1\u0012BG\u0005\u0011qu\u000eZ3\u000b\t\t\u0015%q\u0011\u0005\t\u0005'\u0012y\u00071\u0001\u0002\u001c!A!1\u0013B8\u0001\u0004\tY\"A\u0004hSZ,g.\u00133\t\u0011\t]%q\u000ea\u0001\u0003+\n1\u0002]1sK:$\u0018\nZ(qi\"A!1\u0014\u0001\u0005\u0002\t\u0011i*\u0001\u0007gS:$gj\u001c3f\u0005fLE\r\u0006\u0004\u0003v\t}%\u0011\u0015\u0005\t\u00033\u0011I\n1\u0001\u0002\u001c!Q\u0011q\u0018BM!\u0003\u0005\r!!1\t\u0011\t\u0015\u0006\u0001\"\u0001\u0003\u0005O\u000bQBZ5oI:{G-\u001a\"z+&$GC\u0002B;\u0005S\u0013i\u000b\u0003\u0005\u0003,\n\r\u0006\u0019AAC\u0003\u0015\u0019\u0017.V5e\u0011)\tyLa)\u0011\u0002\u0003\u0007\u0011\u0011\u0019\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0003Ea\u0017n\u001d;WS\u0016<\u0018M\u00197f\u001d>$Wm\u001d\u000b\u0007\u0005k\u0013YL!0\u0011\r\u0005%$q\u0017B;\u0013\u0011\u0011I,a\u001e\u0003\t1K7\u000f\u001e\u0005\t\u00033\u0011y\u000b1\u0001\u0002\u001c!Q\u0011q\u0018BX!\u0003\u0005\r!!1\t\u0015\t\u0005\u0007!%A\u0005\u0002\t\u0011\u0019-\u0001\fgS:$gj\u001c3f\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)M\u000b\u0003\u0002B\n\u001d7F\u0001Be!\u0011\u0011YMa5\u000e\u0005\t5'\u0002\u0002Bh\u0005#\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0003#\u0003\u0003\u0003V\n5'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!\u0011\u001c\u0001\u0012\u0002\u0013\u0005!1\\\u0001\u001eY&\u001cHOV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u001c\u0016\u0005\u0003#\u00119\rC\u0005\u0003b\u0002\t\n\u0011\"\u0003\u0003D\u0006YB.[:u-&,w/\u00192mK:{G-Z:%I\u00164\u0017-\u001e7uIIB\u0011B!:\u0001#\u0003%\tEa1\u0002)\u0019Lg\u000e\u001a\"z!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011I\u000fAI\u0001\n\u0003\u0011!1Y\u0001\u0018M&tGMT8eK\nKX+\u001b3%I\u00164\u0017-\u001e7uIIB3\u0001\u0001Bw!\u0011\tyCa<\n\t\tE\u0018\u0011\u0007\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlFolderRepository
implements FolderRepository,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public Seq<Folder> paginate(Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public Seq<Folder> decorateWithEffectiveSecurity(Seq<Folder> folders) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).map((Function1 & Serializable & scala.Serializable)tree -> {
            void var2_2;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return var2_2;
        });
    }

    @Timed
    public Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        Seq<Folder> results = (Seq<Folder>)this.listViewableNodes(parentId, this.listViewableNodes$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2)), List$.MODULE$.canBuildFrom());
        return this.paginate(decorateWithPermissions ? this.decorateWithEffectiveSecurity(results) : results, page);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId)));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new FoldersStoreException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create folder ", " under ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getId(), parentId})), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tree.Node created = (Tree.Node)success.value();
        Folder folder2 = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        return folder2;
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable & scala.Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{titlePath})), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding folder by path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathFromRoot})));
        String[] pathElements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/"))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).isEmpty()) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption();
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find folder by empty path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{titlePath})), new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> option2 = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Option<FolderRow> topLevelData = option2;
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.uid()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), titlePath})), new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail()).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathElements)).tail())).foldLeft((Object)topNode, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tree.Node node = (Tree.Node)tuple2._1();
            String pathElement = (String)tuple2._2();
            Tree.Node node2 = (Tree.Node)node.children().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find folder [", "] in path [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathElement, titlePath})), new Object[0]);
            });
            return node2;
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable & scala.Serializable)x$6 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$6)));
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        return this.folderPersistence.findByUid(ciUid, depth);
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth) {
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala()), depth);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(FolderId$.MODULE$.absolute$extension(data.folderId()));
        }
        $this.folderPersistence.deleteByUid(data.uid());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$5) {
        String string = ((FolderRow)x$5.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
    }
}

