/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0010!\u0001-B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003T\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011u\u0003!Q1A\u0005\u0002yC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tG\u0002\u0011)\u0019!C\u0001I\"A\u0001\u000e\u0001B\u0001B\u0003%Q\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0006\u0004%\u0019A\u001e\u0005\n\u0003;\u0001!\u0011!Q\u0001\n]Dq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\ty\u000e\u0001C!\u0003CDq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0002z\u0002!\t%a?\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\t\u0001\u0011\u0005#1\u0003\u0005\b\u0005[\u0001A\u0011\tB\u0018\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000b\u0012\u0011cU9m)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\t\t#%A\u0002tc2T!a\t\u0013\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002&M\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003O!\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\n1aY8n\u0007\u0001\u0019r\u0001\u0001\u00173mij\u0004\t\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0004B]f\u0014VM\u001a\t\u0003gQj\u0011AI\u0005\u0003k\t\u0012a\u0002V1tWJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00028q5\t\u0001%\u0003\u0002:A\tI\")Y:f%\u0016dW-Y:f\u0013R,WNU3q_NLGo\u001c:z!\t94(\u0003\u0002=A\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H\u000f\u0005\u00028}%\u0011q\b\t\u0002\u001f\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKN\u001cV\u000f\u001d9peR\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u000f\n\u0013q\u0001T8hO&tw-\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055\u0003\u0013a\u00039feNL7\u000f^3oG\u0016L!a\u0014'\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u0014e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f+\u0005\u0019\u0006CA&U\u0013\t)FJA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002-\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u0002\nq\u0002^1tWB+'o]5ti\u0016t7-Z\u000b\u00023B\u00111JW\u0005\u000372\u0013q\u0002V1tWB+'o]5ti\u0016t7-Z\u0001\u0011i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0002\n\u0011cY8n[\u0016tGOU3q_NLGo\u001c:z+\u0005y\u0006CA\u001aa\u0013\t\t'EA\tD_6lWM\u001c;SKB|7/\u001b;pef\f!cY8n[\u0016tGOU3q_NLGo\u001c:zA\u0005\t\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\u0015\u0004\"a\u000e4\n\u0005\u001d\u0004#\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0001\nsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\u0013\u0001G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dKV\t1\u000e\u0005\u0002LY&\u0011Q\u000e\u0014\u0002\u0019\u0007>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0017!G2p]\u001aLw-\u001e:bi&|g\u000eU3sg&\u001cH/\u001a8dK\u0002\nqBZ1dKR\u0014V\r]8tSR|'/_\u000b\u0002cB\u00111G]\u0005\u0003g\n\u0012qBR1dKR\u0014V\r]8tSR|'/_\u0001\u0011M\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0002\nq\u0001Z5bY\u0016\u001cG/F\u0001x!\rA\u0018q\u0003\b\u0004s\u0006Eab\u0001>\u0002\u000e9\u001910!\u0003\u000f\u0007q\f9AD\u0002~\u0003\u000bq1A`A\u0002\u001b\u0005y(bAA\u0001U\u00051AH]8pizJ\u0011!K\u0005\u0003O!J!!\n\u0014\n\u0007\u0005-A%\u0001\u0002eE&\u0019\u0011%a\u0004\u000b\u0007\u0005-A%\u0003\u0003\u0002\u0014\u0005U\u0011AC*rY\n+\u0018\u000e\u001c3fe*\u0019\u0011%a\u0004\n\t\u0005e\u00111\u0004\u0002\b\t&\fG.Z2u\u0015\u0011\t\u0019\"!\u0006\u0002\u0011\u0011L\u0017\r\\3di\u0002\na\u0001P5oSRtDCEA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0012qFA\u0019\u0003g\u0001\"a\u000e\u0001\t\u000b!\u000b\u0002\u0019\u0001&\t\u000bE\u000b\u0002\u0019A*\t\u000b]\u000b\u0002\u0019A-\t\u000bu\u000b\u0002\u0019A0\t\u000b\r\f\u0002\u0019A3\t\u000b%\f\u0002\u0019A6\t\u000b=\f\u0002\u0019A9\t\u000bU\f\u00029A<\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012,B!!\u000f\u0002@Q!\u00111HA,!\u0011\ti$a\u0010\r\u0001\u00119\u0011\u0011\t\nC\u0002\u0005\r#!\u0001+\u0012\t\u0005\u0015\u00131\n\t\u0004[\u0005\u001d\u0013bAA%]\t9aj\u001c;iS:<\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005EC%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003+\nyE\u0001\u0003UCN\\\u0007bBA-%\u0001\u0007\u00111L\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005u\u0013Q\r\b\u0005\u0003?\n\t\u0007\u0005\u0002\u007f]%\u0019\u00111\r\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t9'!\u001b\u0003\rM#(/\u001b8h\u0015\r\t\u0019G\f\u0015\u0004%\u00055\u0004\u0003BA8\u0003{j!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u000bC:tw\u000e^1uS>t'\u0002BA<\u0003s\nq!\\3ue&\u001c7OC\u0002\u0002|!\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u007f\n\tHA\u0003US6,G-A\ngS:$G+Y:lg\u001a{'\u000fU8mY&tw\r\u0006\u0003\u0002\u0006\u0006\u0005\u0006CBAD\u0003#\u000b)*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011)H/\u001b7\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006LA!a%\u0002\n\n!A*[:u!\u0011\t9*!(\u000e\u0005\u0005e%bAANE\u0005)\u0011/^3ss&!\u0011qTAM\u00055!\u0016m]6CCNL7\rR1uC\"9\u00111U\nA\u0002\u0005\u0015\u0016a\u0002;bg.LEm\u001d\t\u0007\u0003\u000f\u000b\t*a\u0017)\u0007M\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\u0011\ty+!\u0006\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003g\u000biK\u0001\u0006JgJ+\u0017\rZ(oYfD3aEA7\u0003\u0019)\u00070[:ugR!\u00111XAa!\ri\u0013QX\u0005\u0004\u0003\u007fs#a\u0002\"p_2,\u0017M\u001c\u0005\b\u00033\"\u0002\u0019AA.Q\r!\u0012\u0011\u0016\u0015\u0004)\u00055\u0014AB;qI\u0006$X\r\u0006\u0003\u0002L\u0005-\u0007bBAg+\u0001\u0007\u00111J\u0001\u0005i\u0006\u001c8\u000eK\u0002\u0016\u0003[\nA#\u001e9eCR,G+Y:l!J|\u0007/\u001a:uS\u0016\u001cH\u0003BAk\u00037\u00042!LAl\u0013\r\tIN\f\u0002\u0005+:LG\u000fC\u0004\u0002NZ\u0001\r!a\u0013)\u0007Y\ti'\u0001\u0010va\u0012\fG/\u001a+bg.\fe\u000e\u001a*fY\u0016\f7/\u001a$mC\u001e\u001cF/\u0019;vgR1\u00111JAr\u0003KDq!!4\u0018\u0001\u0004\tY\u0005C\u0004\u0002h^\u0001\r!!;\u0002\u000fI,G.Z1tKB!\u0011QJAv\u0013\u0011\ti/a\u0014\u0003\u000fI+G.Z1tK\"\u001aq#!\u001c\u0002\u0015U\u0004H-\u0019;f)f\u0004X\r\u0006\u0003\u0002L\u0005U\bbBAg1\u0001\u0007\u00111\n\u0015\u00041\u00055\u0014A\u00023fY\u0016$X\r\u0006\u0003\u0002V\u0006u\bbBAg3\u0001\u0007\u00111\n\u0015\u00043\u00055\u0014AC2sK\u0006$X\rV1tWR!\u00111\nB\u0003\u0011\u001d\u00119A\u0007a\u0001\u0003\u0017\nqA\\3x)\u0006\u001c8.\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003\u0017\u0012i\u0001C\u0004\u0003\bm\u0001\r!a\u0013)\u0007m\ti'\u0001\u0005n_Z,G+Y:l))\tYE!\u0006\u0003\u001a\tu!q\u0005\u0005\b\u0005/a\u0002\u0019AA&\u0003)!\u0018m]6U_6{g/\u001a\u0005\b\u00057a\u0002\u0019AA&\u0003%iwN^3e)\u0006\u001c8\u000eC\u0004\u0003 q\u0001\rA!\t\u0002-U\u0004H-\u0019;fI>\u0013\u0018nZ5o\u0007>tG/Y5oKJ\u0004B!!\u0014\u0003$%!!QEA(\u00055!\u0016m]6D_:$\u0018-\u001b8fe\"9!\u0011\u0006\u000fA\u0002\t\u0005\u0012AF;qI\u0006$X\r\u001a+be\u001e,GoQ8oi\u0006Lg.\u001a:)\u0007q\ti'\u0001\fgS:$\u0017I\u001a4fGR,GMQ=CY\u0006\u001c7n\\;u)\u0011\t)K!\r\t\u000f\tMR\u00041\u0001\u00036\u0005A!\r\\1dW>,H\u000f\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$a\u0014\u0002\u0011\r\fG.\u001a8eCJLAAa\u0010\u0003:\tA!\t\\1dW>,H\u000fK\u0002\u001e\u0003[\n\u0001bZ3u)&$H.\u001a\u000b\u0005\u00037\u00129\u0005C\u0004\u0002Zy\u0001\r!a\u0017)\u0007y\tI\u000bK\u0002\u001f\u0003[B3\u0001\u0001B(!\u0011\tYK!\u0015\n\t\tM\u0013Q\u0016\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect dialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepository facetRepository() {
        return this.facetRepository;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$.MODULE$.RichCiId(taskId).normalized())).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task2 -> {
            task2.getAllTasks().forEach(task -> this.commentRepository().decorate(task));
            return task2;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksForPolling(List<String> taskIds) {
        Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String id = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Some some = (Some)option;
            TaskRow data = (TaskRow)some.value();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs(task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$1)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        this.facetRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$1) {
        String string = x$1.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, FacetRepository facetRepository, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepository = facetRepository;
        this.dialect = dialect;
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

