/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011qcU9m\u0003R$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\u0015\u0003R$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012!B:mMRR'\"A\u000f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\b\u000e\u0003\u000f1{wmZ5oO\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0003\u0003-\u0001XM]:jgR,gnY3\n\u0005\u001d\"#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDCA\u0016.!\ta\u0003!D\u0001\u0003\u0011\u0015\t\u0003\u00061\u0001#\u0011\u0015y\u0003\u0001\"\u00111\u0003!1\u0017N\u001c3Cs&#GCA\u00198!\t\u0011T'D\u00014\u0015\t!d!\u0001\u0004e_6\f\u0017N\\\u0005\u0003mM\u0012!\"\u0011;uC\u000eDW.\u001a8u\u0011\u0015Ad\u00061\u0001:\u00031\tG\u000f^1dQ6,g\u000e^%e!\tQ\u0014I\u0004\u0002<\u007fA\u0011A\bE\u0007\u0002{)\u0011a\bD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001\u0011\t)\u00059*\u0005C\u0001$N\u001b\u00059%B\u0001%J\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0015.\u000bq!\\3ue&\u001c7O\u0003\u0002M\u0015\u0005A1m\u001c3bQ\u0006dW-\u0003\u0002O\u000f\n)A+[7fI\")\u0001\u000b\u0001C!#\u000611M]3bi\u0016$B!\r*X9\")1k\u0014a\u0001)\u00069!/\u001a7fCN,\u0007C\u0001\u001aV\u0013\t16GA\u0004SK2,\u0017m]3\t\u000ba{\u0005\u0019A-\u0002\tQ\f7o\u001b\t\u0003eiK!aW\u001a\u0003\tQ\u000b7o\u001b\u0005\u0006;>\u0003\r!M\u0001\u000bCR$\u0018m\u00195nK:$\bFA(F\u0011\u0015\u0001\u0006\u0001\"\u0011a)\r\t\u0014M\u0019\u0005\u0006'~\u0003\r\u0001\u0016\u0005\u0006;~\u0003\r!\r\u0015\u0003?\u0016CQ!\u001a\u0001\u0005B\u0019\fa\u0001Z3mKR,GcA4kWB\u0011q\u0002[\u0005\u0003SB\u0011A!\u00168ji\")1\u000b\u001aa\u0001)\")Q\f\u001aa\u0001c!\u0012A-\u0012\u0005\u0006K\u0002!\tE\u001c\u000b\u0004O>\u0004\b\"\u0002-n\u0001\u0004I\u0006\"B/n\u0001\u0004\t\u0004FA7F\u0011\u0015\u0019\b\u0001\"\u0001u\u0003-\u0011\u0017\r^2i\u0013:\u001cXM\u001d;\u0015\u0007\u001d,h\u000fC\u0003Te\u0002\u0007A\u000bC\u0003xe\u0002\u0007\u00010A\u0006biR\f7\r[7f]R\u001c\bcA=\u007fc9\u0011!\u0010 \b\u0003ymL\u0011!E\u0005\u0003{B\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u00111aU3r\u0015\ti\b\u0003K\u0002\u0001\u0003\u000b\u0001B!a\u0002\u0002\u00145\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0006ue\u0006t7/Y2uS>t'bA\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0004\u0002\u0005\u0011\u0014\u0017\u0002BA\u000b\u0003\u0013\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching for attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})));
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, Task task, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding attachment to task [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId()})));
        Task releaseTask = release.getTask(task.getId());
        Set taskAttachments = (Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releaseTask.getAttachments()).asScala()).toSet().$plus((Object)attachment);
        releaseTask.setAttachments((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)taskAttachments.toList()).asJava());
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding attachment to release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        this.releasePersistence.insertAttachments(release.getId(), (Seq<SourceArtifact>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attachment[]{attachment})));
        return attachment;
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        block0: {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting attachment reference '", "' from release '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), release.getId()})));
            release.deleteAttachment(attachment.getId());
            this.releasePersistence.update(release);
            if (release.isTemplate()) break block0;
            this.releasePersistence.deleteAttachmentById(attachment.getId());
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
        } else {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting attachment reference ", " from task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), task.getId()})));
            this.releasePersistence.update(release);
        }
    }

    public void batchInsert(Release release, Seq<Attachment> attachments) {
        this.releasePersistence.insertAttachments(release.getId(), attachments);
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

