/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u00111dU9m%\u0016dW-Y:f)JLwmZ3s%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\t!B]3q_NLGo\u001c:z\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\tA!\u0003\u0002\u0018\t\tA\"+\u001a7fCN,GK]5hO\u0016\u0014(+\u001a9pg&$xN]=\t\u0011e\u0001!Q1A\u0005\u0002i\t\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005Y\u0002CA\u000b\u001d\u0013\tiBAA\tSK2,\u0017m]3SKB|7/\u001b;pefD\u0001b\b\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b\u0005\u0003\u0005\"\u0001\t\u0015\r\u0011\"\u0001#\u0003I!(/[4hKJ\u0004VM]:jgR,gnY3\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0002\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003Q\u0015\u0012!\u0003\u0016:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\"A!\u0006\u0001B\u0001B\u0003%1%A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0004]A\n\u0004CA\u0018\u0001\u001b\u0005\u0011\u0001\"B\r,\u0001\u0004Y\u0002\"B\u0011,\u0001\u0004\u0019\u0003FA\u00164!\t!t(D\u00016\u0015\t1t'\u0001\u0006b]:|G/\u0019;j_:T!\u0001O\u001d\u0002\u000f\u0019\f7\r^8ss*\u0011!hO\u0001\u0006E\u0016\fgn\u001d\u0006\u0003yu\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001+$!C!vi><\u0018N]3e\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u00111\u0017N\u001c3\u0015\u0005\u0011S\u0005CA#I\u001b\u00051%BA$\u0007\u0003\u0019!w.\\1j]&\u0011\u0011J\u0012\u0002\u000f%\u0016dW-Y:f)JLwmZ3s\u0011\u0015Y\u0015\t1\u0001M\u0003%!(/[4hKJLE\r\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fBi\u0011\u0001\u0015\u0006\u0003#2\ta\u0001\u0010:p_Rt\u0014BA*\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0003\u0002FA!Y!\tIv,D\u0001[\u0015\t14L\u0003\u0002];\u00069Q.\u001a;sS\u000e\u001c(B\u00010\u000b\u0003!\u0019w\u000eZ1iC2,\u0017B\u00011[\u0005\u0015!\u0016.\\3e\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0019\u0019'/Z1uKR\u0019A\t\u001a4\t\u000b\u0015\f\u0007\u0019\u0001'\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0003hC\u0002\u0007A)\u0001\bsK2,\u0017m]3Ue&<w-\u001a:)\u0005\u0005D\u0006\"\u00026\u0001\t\u0003Z\u0017AB;qI\u0006$X\r\u0006\u0002m_B\u0011q\"\\\u0005\u0003]B\u0011A!\u00168ji\")q-\u001ba\u0001\t\"\u0012\u0011\u000e\u0017\u0005\u0006e\u0002!\te]\u0001\u0007I\u0016dW\r^3\u0015\u00051$\b\"B&r\u0001\u0004a\u0005FA9Y\u0011\u00159\b\u0001\"\u0011y\u0003i1\u0017N\u001c3F]\u0006\u0014G.\u001a3SK2,\u0017m]3Ue&<w-\u001a:t)\rI\u00181\u0001\t\u0004u~dU\"A>\u000b\u0005ql\u0018\u0001B;uS2T\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014A\u0001T5ti\")QM\u001ea\u0001\u0019\"\u0012a\u000f\u0017\u0015\u0004\u0001\u0005%\u0001\u0003BA\u0006\u0003/i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\fiJ\fgn]1di&|gNC\u0002\u0004\u0003'Q1!!\u0006\u0007\u0003\t!'-\u0003\u0003\u0002\u001a\u00055!aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019cO\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0014\u0003C\u0011!BU3q_NLGo\u001c:z\u0001")
public class SqlReleaseTriggerRepository
implements ReleaseTriggerRepository {
    private final ReleaseRepository releaseRepository;
    private final TriggerPersistence triggerPersistence;

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    @Timed
    public ReleaseTrigger find(String triggerId) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)triggerId));
        Optional maybeTrigger = template.getReleaseTriggerById(CiId$.MODULE$.RichCiId(triggerId).normalized());
        return (ReleaseTrigger)maybeTrigger.orElseThrow(() -> new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId}));
    }

    @Timed
    public ReleaseTrigger create(String templateId, ReleaseTrigger releaseTrigger) {
        Release template = this.releaseRepository().findById(templateId);
        if (!template.getReleaseTriggers().contains(releaseTrigger)) {
            template.getReleaseTriggers().add(releaseTrigger);
            releaseTrigger.setTemplate(template);
        }
        this.triggerPersistence().insert(releaseTrigger);
        this.releaseRepository().update(template);
        return releaseTrigger;
    }

    @Timed
    public void update(ReleaseTrigger releaseTrigger) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)releaseTrigger.getId()));
        template.replaceTrigger(releaseTrigger);
        releaseTrigger.setTemplate(template);
        this.releaseRepository().update(template);
        this.triggerPersistence().update(releaseTrigger);
    }

    @Timed
    public void delete(String triggerId) {
        Release template = this.releaseRepository().findById(Ids.getParentId((String)triggerId));
        template.deleteReleaseTriggerById(CiId$.MODULE$.RichCiId(triggerId).normalized());
        this.releaseRepository().update(template);
        this.triggerPersistence().delete(triggerId);
    }

    @Timed
    public List<String> findEnabledReleaseTriggers(String templateId) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.triggerPersistence().getEnabledReleaseTriggerIds(templateId)).asJava();
    }

    @Autowired
    public SqlReleaseTriggerRepository(ReleaseRepository releaseRepository, TriggerPersistence triggerPersistence) {
        this.releaseRepository = releaseRepository;
        this.triggerPersistence = triggerPersistence;
    }
}

