/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.GateConditionRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import java.util.List;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\u0007\u000e\u0001aA\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u00039\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000bq\u0002A\u0011A\u001f\t\u000b\t\u0003A\u0011I\"\t\u000bi\u0003A\u0011I.\t\u000b=\u0004A\u0011\t9\t\u000bQ\u0004A\u0011I;\u00035M\u000bHnR1uK\u000e{g\u000eZ5uS>t'+\u001a9pg&$xN]=\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\n\u0014\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0015+\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002-\u0005\u00191m\\7\u0004\u0001M!\u0001!G\u0010$!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fMB\u0011\u0001%I\u0007\u0002\u001f%\u0011!e\u0004\u0002\u0018\u000f\u0006$XmQ8oI&$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001J\u0013\u000e\u00035I!AJ\u0007\u00033\t\u000b7/\u001a*fY\u0016\f7/Z%uK6\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-F\u0001*!\tQS&D\u0001,\u0015\taS\"A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001\u0018,\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002'I,G.Z1tKB+'o]5ti\u0016t7-\u001a\u0011\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKV\t!\u0007\u0005\u0002+g%\u0011Ag\u000b\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003Y!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t\u0001\b\u0005\u0002%s%\u0011!(\u0004\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tyz\u0004)\u0011\t\u0003I\u0001AQaJ\u0004A\u0002%BQ\u0001M\u0004A\u0002IBQAN\u0004A\u0002a\na\u0001Z3mKR,GC\u0001#H!\tQR)\u0003\u0002G7\t!QK\\5u\u0011\u0015A\u0005\u00021\u0001J\u000359\u0017\r^3D_:$\u0017\u000e^5p]B\u0011!*T\u0007\u0002\u0017*\u0011A*E\u0001\u0007I>l\u0017-\u001b8\n\u00059[%!D$bi\u0016\u001cuN\u001c3ji&|g\u000e\u000b\u0002\t!B\u0011\u0011\u000bW\u0007\u0002%*\u00111\u000bV\u0001\u000bC:tw\u000e^1uS>t'BA+W\u0003\u001diW\r\u001e:jGNT!aV\u000b\u0002\u0011\r|G-\u00195bY\u0016L!!\u0017*\u0003\u000bQKW.\u001a3\u0002\rU\u0004H-\u0019;f)\rIEL\u0018\u0005\u0006;&\u0001\r!S\u0001\bkB$\u0017\r^3e\u0011\u0015y\u0016\u00021\u0001a\u00031qWm\u001e,be&\f'\r\\3t!\r\tg\r[\u0007\u0002E*\u00111\rZ\u0001\u0005kRLGNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'\u0001\u0002'jgR\u0004\"!\u001b7\u000e\u0003)T!a[&\u0002\u0013Y\f'/[1cY\u0016\u001c\u0018BA7k\u0005!1\u0016M]5bE2,\u0007FA\u0005Q\u0003\u0019\u0019'/Z1uKR\u0019\u0011*\u001d:\t\u000b!S\u0001\u0019A%\t\u000b}S\u0001\u0019\u00011)\u0005)\u0001\u0016\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0005%3\b\"B<\f\u0001\u0004A\u0018aD4bi\u0016\u001cuN\u001c3ji&|g.\u00133\u0011\u0007e\f9BD\u0002{\u0003'q1a_A\t\u001d\ra\u0018q\u0002\b\u0004{\u00065ab\u0001@\u0002\f9\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0018\u0003\u0019a$o\\8u}%\ta#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!AD\b\n\u00051j\u0011bAA\u000bW\u0005!1)[%e\u0013\u0011\tI\"a\u0007\u0003\t\rK\u0017\n\u001a\u0006\u0004\u0003+Y\u0003FA\u0006QQ\r\u0001\u0011\u0011\u0005\t\u0005\u0003G\ty#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u00079\tYCC\u0002\u0002.E\t!\u0001\u001a2\n\t\u0005E\u0012Q\u0005\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlGateConditionRepository
implements GateConditionRepository,
BaseReleaseItemRepository {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public void delete(GateCondition gateCondition) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)gateCondition.getId()), gateCondition.getId());
        GateTask gateTask = (GateTask)release.getTask(Ids.taskIdFrom((String)CiId$.MODULE$.RichCiId(gateCondition.getId()).normalized()));
        gateTask.getConditions().remove(gateCondition);
        this.releasePersistence().update(release);
    }

    @Timed
    public GateCondition update(GateCondition updated, List<Variable> newVariables) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)updated.getId()), updated.getId());
        release.addVariables(newVariables);
        GateTask gateTask = (GateTask)release.getTask(Ids.taskIdFrom((String)CiId$.MODULE$.RichCiId(updated.getId()).normalized()));
        gateTask.updateCondition(updated);
        this.releasePersistence().update(release);
        return updated;
    }

    @Timed
    public GateCondition create(GateCondition gateCondition, List<Variable> newVariables) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)gateCondition.getId()), gateCondition.getId());
        release.addVariables(newVariables);
        GateTask gateTask = (GateTask)release.getTask(Ids.taskIdFrom((String)CiId$.MODULE$.RichCiId(gateCondition.getId()).normalized()));
        gateTask.addCondition(gateCondition);
        this.releasePersistence().update(release);
        return gateCondition;
    }

    @Timed
    public GateCondition findById(String gateConditionId) {
        Release release = this.getRelease(Ids.releaseIdFrom((String)gateConditionId), gateConditionId);
        GateTask gateTask = (GateTask)release.getTask(Ids.taskIdFrom((String)CiId$.MODULE$.RichCiId(gateConditionId).normalized()));
        return this.notNull(gateTask.getCondition(CiId$.MODULE$.RichCiId(gateConditionId).normalized()), gateConditionId);
    }

    public SqlGateConditionRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.repositoryAdapter = repositoryAdapter;
        BaseReleaseItemRepository.$init$(this);
    }
}

