/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0011#\u00015B\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003V\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011}\u0003!Q1A\u0005\u0002\u0001D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011)\u0019!C\u0001M\"A!\u000e\u0001B\u0001B\u0003%q\r\u0003\u0005l\u0001\t\u0015\r\u0011\"\u0001m\u0011!\u0001\bA!A!\u0002\u0013i\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011\u0001:\t\u0011Y\u0004!\u0011!Q\u0001\nMD\u0001b\u001e\u0001\u0003\u0006\u0004%\u0019\u0001\u001f\u0005\n\u0003C\u0001!\u0011!Q\u0001\neDq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005e\u0002\u0001\"\u0011\u0002\u0006\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!!?\u0001\t\u0003\nY\u0010C\u0004\u0003\f\u0001!\tE!\u0004\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!1\u0004\u0001\u0005\n\tu\u0001b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011\u001d\u00119\u0005\u0001C!\u0005\u0013BqA!\u0018\u0001\t\u0003\u0012y\u0006C\u0004\u0003h\u0001!\tE!\u001b\u0003#M\u000bH\u000eV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011q\u0005K\u0001\nq2\u0014X\r\\3bg\u0016T!!\u000b\u0016\u0002\u0013a,'-[1mC\n\u001c(\"A\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\u000f\u0001qC\u0007\u000f\u001f@\u0005B\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001c\u000e\u0003\u0011J!a\u000e\u0013\u0003\u001dQ\u000b7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0011HO\u0007\u0002E%\u00111H\t\u0002\u001a\u0005\u0006\u001cXMU3mK\u0006\u001cX-\u0013;f[J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002:{%\u0011aH\t\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8siB\u0011\u0011\bQ\u0005\u0003\u0003\n\u0012adQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-Z:TkB\u0004xN\u001d;\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015!B:mMRR'\"A$\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0013#\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f+\u0005a\u0005CA'Q\u001b\u0005q%BA(#\u0003-\u0001XM]:jgR,gnY3\n\u0005Es%A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\f1C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0002\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001V!\tie+\u0003\u0002X\u001d\n)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-\u001a\u0011\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012a\u0017\t\u0003\u001brK!!\u0018(\u0003\u001fQ\u000b7o\u001b)feNL7\u000f^3oG\u0016\f\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\u0002#\r|W.\\3oiJ+\u0007o\\:ji>\u0014\u00180F\u0001b!\t)$-\u0003\u0002dI\t\t2i\\7nK:$(+\u001a9pg&$xN]=\u0002%\r|W.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A4\u0011\u0005eB\u0017BA5#\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003a\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-Z\u000b\u0002[B\u0011QJ\\\u0005\u0003_:\u0013\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003e\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0011\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u000b\u0002gB\u0011Q\u0007^\u0005\u0003k\u0012\u0012\u0011DR1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0006Qb-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3sA\u00059A-[1mK\u000e$X#A=\u0011\u0007i\fYBD\u0002|\u0003+q1\u0001`A\t\u001d\ri\u0018Q\u0002\b\u0004}\u0006-abA@\u0002\n9!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u00061\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0005%R\u0013BA\u0014)\u0013\r\tyAJ\u0001\u0003I\nL1aIA\n\u0015\r\tyAJ\u0005\u0005\u0003/\tI\"\u0001\u0006Tc2\u0014U/\u001b7eKJT1aIA\n\u0013\u0011\ti\"a\b\u0003\u000f\u0011K\u0017\r\\3di*!\u0011qCA\r\u0003!!\u0017.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0002CA\u001d\u0001\u0011\u0015Q\u0015\u00031\u0001M\u0011\u0015\u0019\u0016\u00031\u0001V\u0011\u0015I\u0016\u00031\u0001\\\u0011\u0015y\u0016\u00031\u0001b\u0011\u0015)\u0017\u00031\u0001h\u0011\u0015Y\u0017\u00031\u0001n\u0011\u0015\t\u0018\u00031\u0001t\u0011\u00159\u0018\u0003q\u0001z\u0003!1\u0017N\u001c3Cs&#W\u0003BA\u001f\u0003\u0007\"B!a\u0010\u0002\\A!\u0011\u0011IA\"\u0019\u0001!q!!\u0012\u0013\u0005\u0004\t9EA\u0001U#\u0011\tI%a\u0014\u0011\u0007=\nY%C\u0002\u0002NA\u0012qAT8uQ&tw\r\u0005\u0003\u0002R\u0005]SBAA*\u0015\r\t)FJ\u0001\u0007I>l\u0017-\u001b8\n\t\u0005e\u00131\u000b\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0002^I\u0001\r!a\u0018\u0002\rQ\f7o[%e!\u0011\t\t'!\u001b\u000f\t\u0005\r\u0014Q\r\t\u0004\u0003\u0003\u0001\u0014bAA4a\u00051\u0001K]3eK\u001aLA!a\u001b\u0002n\t11\u000b\u001e:j]\u001eT1!a\u001a1Q\r\u0011\u0012\u0011\u000f\t\u0005\u0003g\n\t)\u0004\u0002\u0002v)!\u0011qOA=\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003w\ni(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005}$&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t\u0019)!\u001e\u0003\u000bQKW.\u001a3\u0016\t\u0005\u001d\u00151\u0012\u000b\u0007\u0003\u0013\u000bi)a$\u0011\t\u0005\u0005\u00131\u0012\u0003\b\u0003\u000b\u001a\"\u0019AA$\u0011\u001d\tif\u0005a\u0001\u0003?Bq!!%\u0014\u0001\u0004\t\u0019*\u0001\bsKN|GN^3PaRLwN\\:\u0011\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'%\u0003\u0015\tX/\u001a:z\u0013\u0011\ti*a&\u0003\u001dI+7o\u001c7wK>\u0003H/[8og\"\u001a1#!\u001d\u0002%\u0019Lg\u000e\u001a+bg.\u001c()Y:jG\u0012\u000bG/\u0019\u000b\u0005\u0003K\u000bY\f\u0005\u0004\u0002(\u0006E\u0016QW\u0007\u0003\u0003SSA!a+\u0002.\u0006!Q\u000f^5m\u0015\t\ty+\u0001\u0003kCZ\f\u0017\u0002BAZ\u0003S\u0013A\u0001T5tiB!\u0011QSA\\\u0013\u0011\tI,a&\u0003\u001bQ\u000b7o\u001b\"bg&\u001cG)\u0019;b\u0011\u001d\ti\f\u0006a\u0001\u0003\u007f\u000bq\u0001^1tW&#7\u000f\u0005\u0004\u0002(\u0006E\u0016q\f\u0015\u0004)\u0005\r\u0007\u0003BAc\u0003\u0017l!!a2\u000b\t\u0005%\u0017\u0011D\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002N\u0006\u001d'AC%t%\u0016\fGm\u00148ms\"\u001aA#!\u001d\u0002\r\u0015D\u0018n\u001d;t)\u0011\t).a7\u0011\u0007=\n9.C\u0002\u0002ZB\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002^U\u0001\r!a\u0018)\u0007U\t\u0019\rK\u0002\u0016\u0003c\na!\u001e9eCR,G\u0003BA(\u0003KDq!a:\u0017\u0001\u0004\ty%\u0001\u0003uCN\\\u0007f\u0001\f\u0002r\u0005!R\u000f\u001d3bi\u0016$\u0016m]6Qe>\u0004XM\u001d;jKN$B!a<\u0002vB\u0019q&!=\n\u0007\u0005M\bG\u0001\u0003V]&$\bbBAt/\u0001\u0007\u0011q\n\u0015\u0004/\u0005E\u0014AH;qI\u0006$X\rV1tW\u0006sGMU3mK\u0006\u001cXM\u00127bON#\u0018\r^;t)\u0019\ty%!@\u0002\u0000\"9\u0011q\u001d\rA\u0002\u0005=\u0003b\u0002B\u00011\u0001\u0007!1A\u0001\be\u0016dW-Y:f!\u0011\t\tF!\u0002\n\t\t\u001d\u00111\u000b\u0002\b%\u0016dW-Y:fQ\rA\u0012\u0011O\u0001\u000bkB$\u0017\r^3UsB,G\u0003BA(\u0005\u001fAq!a:\u001a\u0001\u0004\ty\u0005K\u0002\u001a\u0003c\na\u0001Z3mKR,G\u0003BAx\u0005/Aq!a:\u001b\u0001\u0004\ty\u0005K\u0002\u001b\u0003c\n!b\u0019:fCR,G+Y:l)\u0011\tyEa\b\t\u000f\t\u00052\u00041\u0001\u0002P\u00059a.Z<UCN\\\u0017AB2sK\u0006$X\r\u0006\u0003\u0002P\t\u001d\u0002b\u0002B\u00119\u0001\u0007\u0011q\n\u0015\u00049\u0005E\u0014\u0001C7pm\u0016$\u0016m]6\u0015\u0015\u0005=#q\u0006B\u001a\u0005o\u0011\t\u0005C\u0004\u00032u\u0001\r!a\u0014\u0002\u0015Q\f7o\u001b+p\u001b>4X\rC\u0004\u00036u\u0001\r!a\u0014\u0002\u00135|g/\u001a3UCN\\\u0007b\u0002B\u001d;\u0001\u0007!1H\u0001\u0017kB$\u0017\r^3e\u001fJLw-\u001b8D_:$\u0018-\u001b8feB!\u0011\u0011\u000bB\u001f\u0013\u0011\u0011y$a\u0015\u0003\u001bQ\u000b7o[\"p]R\f\u0017N\\3s\u0011\u001d\u0011\u0019%\ba\u0001\u0005w\ta#\u001e9eCR,G\rV1sO\u0016$8i\u001c8uC&tWM\u001d\u0015\u0004;\u0005E\u0014A\u00064j]\u0012\feMZ3di\u0016$')\u001f\"mC\u000e\\w.\u001e;\u0015\t\u0005}&1\n\u0005\b\u0005\u001br\u0002\u0019\u0001B(\u0003!\u0011G.Y2l_V$\b\u0003\u0002B)\u0005/j!Aa\u0015\u000b\t\tU\u00131K\u0001\tG\u0006dWM\u001c3be&!!\u0011\fB*\u0005!\u0011E.Y2l_V$\bf\u0001\u0010\u0002r\u0005Aq-\u001a;USRdW\r\u0006\u0003\u0002`\t\u0005\u0004bBA/?\u0001\u0007\u0011q\f\u0015\u0004?\u0005\r\u0007fA\u0010\u0002r\u0005Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0005W\u00129\b\u0005\u0003\u0003n\tMTB\u0001B8\u0015\u0011\u0011\t(a\u0015\u0002\rM$\u0018\r^;t\u0013\u0011\u0011)Ha\u001c\u0003\u0015Q\u000b7o[*uCR,8\u000fC\u0004\u0002^\u0001\u0002\r!a\u0018)\u0007\u0001\n\u0019\rK\u0002!\u0003cB3\u0001\u0001B@!\u0011\t)M!!\n\t\t\r\u0015q\u0019\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationPersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task2 -> {
            task2.getAllTasks().forEach(task -> this.commentRepository().decorate(task));
            return task2;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs(release);
        return task;
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs(task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$1)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$1) {
        String string = x$1.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationPersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

