/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\ree\u0001B\u00193\u0001uB\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u0002\u0011)\u0019!C\tW\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0005r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011C<\t\u0011m\u0004!\u0011!Q\u0001\naD\u0001\u0002 \u0001\u0003\u0006\u0004%\t\" \u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\nyD!\"!\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0004\u0011)\ty\u0001\u0001B\u0001B\u0003%\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011Q\u0004\u0001\u0003\u0006\u0004%\t!a\b\t\u0015\u0005\u001d\u0002A!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002*\u0001\u0011)\u0019!C\t\u0003WA!\"a\r\u0001\u0005\u0003\u0005\u000b\u0011BA\u0017\u0011)\t)\u0004\u0001B\u0001B\u0003%\u0011q\u0007\u0005\u000b\u0003{\u0001!Q1A\u0005\u0004\u0005}\u0002BCA8\u0001\t\u0005\t\u0015!\u0003\u0002B!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003#\u0004A\u0011IAj\u0011\u001d\tY\u000f\u0001C!\u0003[Dq!a;\u0001\t\u0003\n\u0019\u0010C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t\r\u0003\u0001\"\u0011\u0003F!9!Q\n\u0001\u0005\u0002\t=\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\b\u0005\u000f\u0003A\u0011\u0001BE\u0011\u001d\u00119\n\u0001C!\u00053CqA!,\u0001\t\u0003\u0012y\u000bC\u0004\u00036\u0002!IAa.\t\u000f\t}\u0006\u0001\"\u0011\u0003B\"9!\u0011\u001a\u0001\u0005B\t-\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005?\u0004A\u0011\tBq\u0011\u001d\u0011Y\u000f\u0001C!\u0005[DqAa>\u0001\t\u0003\u0012I\u0010C\u0004\u0004\b\u0001!\te!\u0003\t\u000f\rE\u0001\u0001\"\u0011\u0004\u0014!911\u0004\u0001\u0005B\ru\u0001bBB\u000e\u0001\u0011\u000531\u0005\u0005\b\u0007_\u0001A\u0011IB\u0019\u0011\u001d\u0019I\u0004\u0001C!\u0007wAqaa\u0013\u0001\t\u0013\u0019i\u0005C\u0004\u0004n\u0001!Iaa\u001c\t\u000f\rU\u0004\u0001\"\u0011\u0004x\t!2+\u001d7SK2,\u0017m]3SKB|7/\u001b;pefT!a\r\u001b\u0002\u0007M\fHN\u0003\u00026m\u0005Q!/\u001a9pg&$xN]=\u000b\u0005]B\u0014!\u0003=me\u0016dW-Y:f\u0015\tI$(A\u0005yK\nL\u0017\r\\1cg*\t1(A\u0002d_6\u001c\u0001a\u0005\u0005\u0001}\u0011C%KW/a!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011QIR\u0007\u0002i%\u0011q\t\u000e\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bcA%K\u00196\t!'\u0003\u0002Le\t)\u0012J\u001c;fe\u000e,\u0007\u000f^3e%\u0016\u0004xn]5u_JL\bCA'Q\u001b\u0005q%BA(7\u0003\u0019!w.\\1j]&\u0011\u0011K\u0014\u0002\b%\u0016dW-Y:f!\t\u0019\u0006,D\u0001U\u0015\t)f+A\u0003tY\u001a$$NC\u0001X\u0003!9'/\u001b>{Y\u0016$\u0017BA-U\u0005\u001daunZ4j]\u001e\u0004\"!S.\n\u0005q\u0013$A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005%s\u0016BA03\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002JC&\u0011!M\r\u0002\u001b'Fd'+\u001a7fCN,'+\u001a9pg&$xN]=IK2\u0004XM]\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002fQ6\taM\u0003\u0002he\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tIgM\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u00031\u0004\"!Z7\n\u000594'a\u0004+bg.\u0004VM]:jgR,gnY3\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0013!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u000b\u0002eB\u0011Qm]\u0005\u0003i\u001a\u0014Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0003I\u0019w.\\7f]R\u0004VM]:jgR,gnY3\u0016\u0003a\u0004\"!Z=\n\u0005i4'AE\"p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\f1cY8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dK\u0002\na\u0002^3b[J+\u0007o\\:ji>\u0014\u00180F\u0001\u007f!\t)u0C\u0002\u0002\u0002Q\u0012a\u0002V3b[J+\u0007o\\:ji>\u0014\u00180A\buK\u0006l'+\u001a9pg&$xN]=!\u0003m\u0011X\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ssV\u0011\u0011\u0011\u0002\t\u0004\u000b\u0006-\u0011bAA\u0007i\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fAD]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\b%\u0001\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016,\"!!\u0006\u0011\u0007\u0015\f9\"C\u0002\u0002\u001a\u0019\u0014\u0001dQ8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f\u0003e\u0019wN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/\u0006\u0002\u0002\"A\u0019\u0011*a\t\n\u0007\u0005\u0015\"G\u0001\u000bTc2\u0014V\r]8tSR|'/_!eCB$XM]\u0001\u0013e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b%\u0001\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,WCAA\u0017!\r)\u0017qF\u0005\u0004\u0003c1'A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\f1\u0003\u001e:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002\n\u0011DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195feB\u0019Q)!\u000f\n\u0007\u0005mBGA\rGC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018AC:rY\u0012K\u0017\r\\3diV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nIG\u0004\u0003\u0002F\u0005\rd\u0002BA$\u0003?rA!!\u0013\u0002\\9!\u00111JA-\u001d\u0011\ti%a\u0016\u000f\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015=\u0003\u0019a$o\\8u}%\t1(\u0003\u0002:u%\u0011q\u0007O\u0005\u0004\u0003;2\u0014A\u00013c\u0013\r\u0019\u0014\u0011\r\u0006\u0004\u0003;2\u0014\u0002BA3\u0003O\n!bU9m\u0005VLG\u000eZ3s\u0015\r\u0019\u0014\u0011M\u0005\u0005\u0003W\niGA\u0004ES\u0006dWm\u0019;\u000b\t\u0005\u0015\u0014qM\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0017\u0003k\nY(! \u0002\u0000\u0005\u0005\u00151QAC\u0003\u000f\u000bI)a#\u0002\u000eR!\u0011qOA=!\tI\u0005\u0001C\u0004\u0002>U\u0001\u001d!!\u0011\t\u000b\r,\u0002\u0019\u00013\t\u000b),\u0002\u0019\u00017\t\u000bA,\u0002\u0019\u0001:\t\u000bY,\u0002\u0019\u0001=\t\u000bq,\u0002\u0019\u0001@\t\u000f\u0005\u0015Q\u00031\u0001\u0002\n!9\u0011\u0011C\u000bA\u0002\u0005U\u0001bBA\u000f+\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003S)\u0002\u0019AA\u0017\u0011\u001d\t)$\u0006a\u0001\u0003o\ta!\u001a=jgR\u001cH\u0003BAJ\u00033\u00032aPAK\u0013\r\t9\n\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\tYJ\u0006a\u0001\u0003;\u000b!!\u001b3\u0011\t\u0005}\u0015q\u0015\b\u0005\u0003C\u000b\u0019\u000bE\u0002\u0002P\u0001K1!!*A\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011VAV\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0015!)\u0007Y\ty\u000b\u0005\u0003\u00022\u0006]VBAAZ\u0015\u0011\t),a\u001a\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003s\u000b\u0019L\u0001\u0006JgJ+\u0017\rZ(oYfD3AFA_!\u0011\ty,!4\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f!\"\u00198o_R\fG/[8o\u0015\u0011\t9-!3\u0002\u000f5,GO]5dg*\u0019\u00111\u001a\u001e\u0002\u0011\r|G-\u00195bY\u0016LA!a4\u0002B\n)A+[7fI\u000611M]3bi\u0016$R\u0001TAk\u00033Da!a6\u0018\u0001\u0004a\u0015a\u0002:fY\u0016\f7/\u001a\u0005\b\u00037<\u0002\u0019AAo\u0003U\u0011X\r\\3bg\u0016\u001c%/Z1uS>t7k\\;sG\u0016\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gt\u0015AB3wK:$8/\u0003\u0003\u0002h\u0006\u0005(!\u0006*fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\u0015\u0004/\u0005u\u0016\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u00071\u000by\u000fC\u0004\u0002\u001cb\u0001\r!!()\u0007a\ti\fF\u0003M\u0003k\f9\u0010C\u0004\u0002\u001cf\u0001\r!!(\t\u000f\u0005e\u0018\u00041\u0001\u0002|\u0006q!/Z:pYZ,w\n\u001d;j_:\u001c\b\u0003BA\u007f\u0005\u0007i!!a@\u000b\u0007\t\u0005A'A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0003\u0006\u0005}(A\u0004*fg>dg/Z(qi&|gn\u001d\u0015\u00043\u0005u\u0016a\u00044j]\u0012LEm\u001d\"z'R\fG/^:\u0015\t\t5!q\u0004\t\u0007\u0005\u001f\u0011I\"!(\u000f\t\tE!Q\u0003\b\u0005\u0003\u001f\u0012\u0019\"C\u0001B\u0013\r\u00119\u0002Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011YB!\b\u0003\u0007M+\u0017OC\u0002\u0003\u0018\u0001CqA!\t\u001b\u0001\u0004\u0011\u0019#\u0001\u0005ti\u0006$Xo]3t!\u0015y$Q\u0005B\u0015\u0013\r\u00119\u0003\u0011\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=b*\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0005g\u0011iCA\u0007SK2,\u0017m]3Ti\u0006$Xo\u001d\u0015\u00045\u0005u\u0006f\u0001\u000e\u0003:A!!1\bB \u001b\t\u0011iDC\u0002\u0002D\u0002KAA!\u0011\u0003>\t9a/\u0019:be\u001e\u001c\u0018a\u00054j]\u0012\u0014\u0015pQ1mK:$\u0017M\u001d+pW\u0016tGc\u0001'\u0003H!9!\u0011J\u000eA\u0002\u0005u\u0015!D2bY\u0016tG-\u0019:U_.,g\u000eK\u0002\u001c\u0003{\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u0011iA!\u0015\u0003f!9!1\u000b\u000fA\u0002\tU\u0013\u0001\u00023bi\u0016\u0004BAa\u0016\u0003b5\u0011!\u0011\f\u0006\u0005\u00057\u0012i&\u0001\u0003vi&d'B\u0001B0\u0003\u0011Q\u0017M^1\n\t\t\r$\u0011\f\u0002\u0005\t\u0006$X\rC\u0004\u0003hq\u0001\rA!\u001b\u0002\u0011A\fw-Z*ju\u0016\u00042a\u0010B6\u0013\r\u0011i\u0007\u0011\u0002\u0004\u0013:$\bf\u0001\u000f\u00020\"\u001aA$!0\u0002\u001dM,G\u000f\u0015:f\u0003J\u001c\u0007.\u001b<fIR1!q\u000fB?\u0005\u0003\u00032a\u0010B=\u0013\r\u0011Y\b\u0011\u0002\u0005+:LG\u000fC\u0004\u0003\u0000u\u0001\r!!(\u0002\u0013I,G.Z1tK&#\u0007b\u0002BB;\u0001\u0007\u00111S\u0001\faJ,\u0017I]2iSZ,G\rK\u0002\u001e\u0003{\u000b\u0011DZ5oIB\u0013X-\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:fgR1!1\u0012BG\u0005#\u0003RAa\u0004\u0003\u001a1CqAa$\u001f\u0001\u0004\u0011I'\u0001\u0003qC\u001e,\u0007b\u0002B4=\u0001\u0007!\u0011\u000e\u0015\u0004=\u0005=\u0006f\u0001\u0010\u0002>\u000611/Z1sG\"$BAa'\u0003\"B)!q\u000bBO\u0019&!!q\u0014B-\u0005\u0011a\u0015n\u001d;\t\u000f\t\rv\u00041\u0001\u0003&\u0006a1/Z1sG\"\u0004\u0016M]1ngB\u0019QIa*\n\u0007\t%FGA\u000bSK2,\u0017m]3TK\u0006\u00148\r\u001b\"z!\u0006\u0014\u0018-\\:)\u0007}\ti,\u0001\u0004eK2,G/\u001a\u000b\u0005\u0005o\u0012\t\fC\u0004\u0002\u001c\u0002\u0002\r!!()\u0007\u0001\ni,A\feK2,G/\u001a*fY\u0016\f7/\u001a*fM\u0016\u0014XM\\2fgR1!q\u000fB]\u0005wCq!a'\"\u0001\u0004\ti\nC\u0004\u0003>\u0006\u0002\rA!\u001b\u0002\u0015I,G.Z1tKVKG-A\u0007eK2,G/Z,ji\",\u0016\u000e\u001a\u000b\u0007\u0005o\u0012\u0019M!2\t\u000f\u0005m%\u00051\u0001\u0002\u001e\"9!Q\u0018\u0012A\u0002\t%\u0004f\u0001\u0012\u0002>\u0006!Qn\u001c<f)\u0019\u00119H!4\u0003R\"9!qZ\u0012A\u0002\u0005u\u0015AC8sS\u001eLg.\u00197JI\"9!1[\u0012A\u0002\u0005u\u0015!\u00028fo&#\u0007fA\u0012\u0002>\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0005\u0005S\u0011Y\u000eC\u0004\u0002\u001c\u0012\u0002\r!!()\u0007\u0011\ni,A\u0006hKR\u001cF/\u0019;vg\u0016\u001cH\u0003\u0002Br\u0005K\u0004bAa\u0004\u0003\u001a\t%\u0002b\u0002BtK\u0001\u0007!QB\u0001\u0004S\u0012\u001c\bfA\u0013\u0002>\u0006iq-\u001a;SSN\\7kY8sKN$BAa<\u0003rB1!q\u0002B\r\u0005SBqAa:'\u0001\u0004\u0011i\u0001K\u0002'\u0003_C3AJA_\u00035\u0019X\r\u001e*jg.\u001c6m\u001c:fgRA!q\u000fB~\u0005{\u001c\t\u0001C\u0004\u0003\u0000\u001d\u0002\r!!(\t\u000f\t}x\u00051\u0001\u0003j\u0005)1oY8sK\"911A\u0014A\u0002\t%\u0014A\u0003;pi\u0006d7kY8sK\"\u001aq%!0\u0002\u0015%\u001cH+Z7qY\u0006$X\r\u0006\u0003\u0002\u0014\u000e-\u0001b\u0002B@Q\u0001\u0007\u0011Q\u0014\u0015\u0004Q\u0005=\u0006f\u0001\u0015\u0002>\u0006Aq-\u001a;USRdW\r\u0006\u0003\u0002\u001e\u000eU\u0001bBANS\u0001\u0007\u0011Q\u0014\u0015\u0004S\u0005=\u0006fA\u0015\u0002>\u00061Q\u000f\u001d3bi\u0016$2\u0001TB\u0010\u0011\u0019\t9N\u000ba\u0001\u0019\"\u001a!&!0\u0015\u000b1\u001b)c!\u000b\t\r\r\u001d2\u00061\u0001M\u0003!y'/[4j]\u0006d\u0007BBB\u0016W\u0001\u0007A*A\u0004va\u0012\fG/\u001a3)\u0007-\ni,A\u0004sKBd\u0017mY3\u0015\u000b1\u001b\u0019d!\u000e\t\r\r\u001dB\u00061\u0001M\u0011\u0019\u0019Y\u0003\fa\u0001\u0019\"\u001aA&!0\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004>\r\r\u0003C\u0002B,\u0007\u007f\ti*\u0003\u0003\u0004B\te#aA*fi\"91QI\u0017A\u0002\t%\u0014a\u00037j[&$h*^7cKJD3!LAXQ\ri\u0013QX\u0001\u000bO\u0016$(+\u001a7fCN,G#\u0002'\u0004P\r-\u0004b\u0002B@]\u0001\u00071\u0011\u000b\t\u0005\u0007'\u001a)G\u0004\u0003\u0004V\r\u0005d\u0002BB,\u0007?rAa!\u0017\u0004^9!\u0011\u0011JB.\u0013\t)d'\u0003\u00024i%\u0011qMM\u0005\u0004\u0007G2\u0017\u0001B\"j\u0013\u0012LAaa\u001a\u0004j\t!1)[%e\u0015\r\u0019\u0019G\u001a\u0005\b\u0003st\u0003\u0019AA~\u0003\t\u001a\u0007.Z2l\u0013Ntu\u000e\u001e*fM\u0016\u0014XM\\2fI\nKH)\u001a9f]\u0012,gnY5fgR!!qOB9\u0011\u001d\u0019\u0019h\fa\u0001\u0007#\nq\u0003\u001d7b]&#X-\\%e\u001fJLEo]\"iS2$'/\u001a8\u0002\u001f\u0019Lg\u000eZ*D\u001b\u0012\u000bG/\u0019\"z\u0013\u0012$Ba!\u001f\u0004\fB)qha\u001f\u0004\u0000%\u00191Q\u0010!\u0003\r=\u0003H/[8o!\u0011\u0019\tia\"\u000e\u0005\r\r%\u0002BBC\u0005;\nA\u0001\\1oO&!1\u0011RBB\u0005\u001dIe\u000e^3hKJDq!a'1\u0001\u0004\ti\nK\u00021\u0003_C3\u0001MA_Q\r\u000111\u0013\t\u0005\u0003c\u001b)*\u0003\u0003\u0004\u0018\u0006M&aD%t)J\fgn]1di&|g.\u00197")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceTriggers(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTriggers$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$(this, persistenceInterceptor);
    }

    @Override
    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$(this, ci);
    }

    @Override
    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$(this, ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    @Override
    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> this.triggerPersistence().insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$2(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs(release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence().deleteByTemplateId(id);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceTriggers(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$7 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$7).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ boolean $anonfun$create$3(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$2(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$3($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$6(SqlReleaseRepository $this, ReleaseTrigger trigger) {
        $this.triggerPersistence().insert(trigger);
    }

    public static final /* synthetic */ boolean $anonfun$update$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReleaseTrigger orig = (ReleaseTrigger)tuple2._1();
        ReleaseTrigger up = (ReleaseTrigger)tuple2._2();
        boolean bl = orig.isEnabled() != up.isEnabled();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$9(SqlReleaseRepository $this, ReleaseTrigger releaseTrigger) {
        $this.triggerPersistence().update(releaseTrigger);
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
        Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getReleaseTriggers()).asScala();
        Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated$1.getReleaseTriggers()).asScala();
        Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
        triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
            SqlReleaseRepository.$anonfun$update$6($this, trigger);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((TraversableLike)triggerDiff.updatedPairs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$7(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (ReleaseTrigger)x$6._2(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)releaseTrigger -> {
            SqlReleaseRepository.$anonfun$update$9($this, releaseTrigger);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$(this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

