/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001B\u0013'\u0001EB\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005!\"Aq\u000b\u0001BC\u0002\u0013\u0005\u0001\f\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003Z\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\r\u0004!Q1A\u0005\u0002\u0011D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!9\bA!A!\u0002\u0013\t\b\u0002\u0003=\u0001\u0005\u000b\u0007I\u0011A=\t\u0011u\u0004!\u0011!Q\u0001\niD\u0001B \u0001\u0003\u0006\u0004%\u0019a \u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t9\u0005\u0001C!\u0003'Cq!a,\u0001\t\u0003\n\t\fC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005=\b\u0001\"\u0011\u0002r\"9\u0011\u0011 \u0001\u0005B\u0005m\bb\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005G\u0001A\u0011\tB\u0013\u0011\u001d\u0011)\u0004\u0001C!\u0005oAqA!\u0010\u0001\t\u0003\u0012y\u0004C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t5\u0003\u0001\"\u0011\u0003P!9!Q\u000b\u0001\u0005B\t]\u0003b\u0002B9\u0001\u0011\u0005#1\u000f\u0005\b\u0005\u000f\u0003A\u0011\tBE\u0011\u001d\u0011\t\n\u0001C!\u0005'CqA!+\u0001\t\u0003\u0012Y\u000bC\u0004\u0003D\u0002!\tEa+\t\u000f\t%\u0007\u0001\"\u0011\u0003L\n\t2+\u001d7UCN\\'+\u001a9pg&$xN]=\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u000be\u0016\u0004xn]5u_JL(BA\u0016-\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002.]\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002_\u0005\u00191m\\7\u0004\u0001M9\u0001A\r\u001d=\u0001\u000e3\u0005CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$AB!osJ+g\r\u0005\u0002:u5\t\u0001&\u0003\u0002<Q\tqA+Y:l%\u0016\u0004xn]5u_JL\bCA\u001f?\u001b\u00051\u0013BA '\u0005e\u0011\u0015m]3SK2,\u0017m]3Ji\u0016l'+\u001a9pg&$xN]=\u0011\u0005u\n\u0015B\u0001\"'\u0005Y!Um]3sS\u0006d\u0017N_1uS>t7+\u001e9q_J$\bCA\u001fE\u0013\t)eE\u0001\u0010D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2fgN+\b\u000f]8siB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0006g24GG\u001b\u0006\u0002\u0017\u0006AqM]5{u2,G-\u0003\u0002N\u0011\n9Aj\\4hS:<\u0017A\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u001a\n1\u0002]3sg&\u001cH/\u001a8dK&\u0011QK\u0015\u0002\u0013%\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW-A\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u000beKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0016\u0003e\u0003\"!\u0015.\n\u0005m\u0013&!\u0006#fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u0001\u0017I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2fA\u0005yA/Y:l!\u0016\u00148/[:uK:\u001cW-F\u0001`!\t\t\u0006-\u0003\u0002b%\nyA+Y:l!\u0016\u00148/[:uK:\u001cW-\u0001\tuCN\\\u0007+\u001a:tSN$XM\\2fA\u0005\t2m\\7nK:$(+\u001a9pg&$xN]=\u0016\u0003\u0015\u0004\"!\u000f4\n\u0005\u001dD#!E\"p[6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ss\u0006\u00112m\\7nK:$(+\u001a9pg&$xN]=!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002WB\u0011Q\b\\\u0005\u0003[\u001a\u0012AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\n\u0001dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;S\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011ao\u001d\u0002\"\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKB+'o]5ti\u0016t7-Z\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\rgC\u000e,GOU3q_NLGo\u001c:z\t&\u001c\b/\u0019;dQ\u0016\u0014X#\u0001>\u0011\u0005eZ\u0018B\u0001?)\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u00025\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tIC\u0004\u0003\u0002\u0006\u0005\rb\u0002BA\u0004\u0003?qA!!\u0003\u0002\u001c9!\u00111BA\r\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u00051\u0003\u0019a$o\\8u}%\tq&\u0003\u0002.]%\u00111\u0006L\u0005\u0004\u0003;Q\u0013A\u00013c\u0013\r9\u0013\u0011\u0005\u0006\u0004\u0003;Q\u0013\u0002BA\u0013\u0003O\t!bU9m\u0005VLG\u000eZ3s\u0015\r9\u0013\u0011E\u0005\u0005\u0003W\tiCA\u0004ES\u0006dWm\u0019;\u000b\t\u0005\u0015\u0012qE\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"\"#!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002FA\u0011Q\b\u0001\u0005\u0006\u001dF\u0001\r\u0001\u0015\u0005\u0006/F\u0001\r!\u0017\u0005\u0006;F\u0001\ra\u0018\u0005\u0006GF\u0001\r!\u001a\u0005\u0006SF\u0001\ra\u001b\u0005\u0006_F\u0001\r!\u001d\u0005\u0006qF\u0001\rA\u001f\u0005\u0007}F\u0001\u001d!!\u0001\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012,B!a\u0013\u0002RQ!\u0011QJA5!\u0011\ty%!\u0015\r\u0001\u00119\u00111\u000b\nC\u0002\u0005U#!\u0001+\u0012\t\u0005]\u0013Q\f\t\u0004g\u0005e\u0013bAA.i\t9aj\u001c;iS:<\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r$&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003O\n\tG\u0001\u0003UCN\\\u0007bBA6%\u0001\u0007\u0011QN\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005=\u0014q\u000f\b\u0005\u0003c\n\u0019\bE\u0002\u0002\u0010QJ1!!\u001e5\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011PA>\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000f\u001b)\u0007I\ty\b\u0005\u0003\u0002\u0002\u0006=UBAAB\u0015\u0011\t))a\"\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\n\u0006-\u0015aB7fiJL7m\u001d\u0006\u0004\u0003\u001bs\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005E\u00151\u0011\u0002\u0006)&lW\rZ\u000b\u0005\u0003+\u000bI\n\u0006\u0004\u0002\u0018\u0006m\u0015Q\u0014\t\u0005\u0003\u001f\nI\nB\u0004\u0002TM\u0011\r!!\u0016\t\u000f\u0005-4\u00031\u0001\u0002n!9\u0011qT\nA\u0002\u0005\u0005\u0016A\u0004:fg>dg/Z(qi&|gn\u001d\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0015\u0002\u000bE,XM]=\n\t\u0005-\u0016Q\u0015\u0002\u000f%\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8tQ\r\u0019\u0012qP\u0001\u0013M&tG\rV1tWN\u0014\u0015m]5d\t\u0006$\u0018\r\u0006\u0003\u00024\u0006%\u0007CBA[\u0003\u007f\u000b\u0019-\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0011)H/\u001b7\u000b\u0005\u0005u\u0016\u0001\u00026bm\u0006LA!!1\u00028\n!A*[:u!\u0011\t\u0019+!2\n\t\u0005\u001d\u0017Q\u0015\u0002\u000e)\u0006\u001c8NQ1tS\u000e$\u0015\r^1\t\u000f\u0005-G\u00031\u0001\u0002N\u00069A/Y:l\u0013\u0012\u001c\bCBA[\u0003\u007f\u000bi\u0007K\u0002\u0015\u0003#\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0005\u0003/\f9#A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BAn\u0003+\u0014!\"S:SK\u0006$wJ\u001c7zQ\r!\u0012qP\u0001\u0007KbL7\u000f^:\u0015\t\u0005\r\u0018\u0011\u001e\t\u0004g\u0005\u0015\u0018bAAti\t9!i\\8mK\u0006t\u0007bBA6+\u0001\u0007\u0011Q\u000e\u0015\u0004+\u0005E\u0007fA\u000b\u0002\u0000\u00051Q\u000f\u001d3bi\u0016$B!!\u0018\u0002t\"9\u0011Q\u001f\fA\u0002\u0005u\u0013\u0001\u0002;bg.D3AFA@\u0003-)\b\u000fZ1uKR\u000b7o[:\u0015\t\u0005u(1\u0001\t\u0004g\u0005}\u0018b\u0001B\u0001i\t!QK\\5u\u0011\u001d\u0011)a\u0006a\u0001\u0005\u000f\tQ\u0001^1tWN\u0004Ra\rB\u0005\u0003;J1Aa\u00035\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0004/\t=\u0001\u0003\u0002B\t\u0005+i!Aa\u0005\u000b\u0007\u0005\u0015E'\u0003\u0003\u0003\u0018\tM!a\u0002<be\u0006\u0014xm\u001d\u0015\u0004/\u0005}\u0014\u0001F;qI\u0006$X\rV1tWB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002~\n}\u0001bBA{1\u0001\u0007\u0011Q\f\u0015\u00041\u0005}\u0014AH;qI\u0006$X\rV1tW\u0006sGMU3mK\u0006\u001cXM\u00127bON#\u0018\r^;t)\u0019\tiFa\n\u0003*!9\u0011Q_\rA\u0002\u0005u\u0003b\u0002B\u00163\u0001\u0007!QF\u0001\be\u0016dW-Y:f!\u0011\tyFa\f\n\t\tE\u0012\u0011\r\u0002\b%\u0016dW-Y:fQ\rI\u0012qP\u0001\u000bkB$\u0017\r^3UsB,G\u0003BA/\u0005sAq!!>\u001b\u0001\u0004\ti\u0006K\u0002\u001b\u0003\u007f\na\u0001Z3mKR,G\u0003BA\u007f\u0005\u0003Bq!!>\u001c\u0001\u0004\ti\u0006K\u0002\u001c\u0003\u007f\n!b\u0019:fCR,G+Y:l)\u0011\tiF!\u0013\t\u000f\t-C\u00041\u0001\u0002^\u00059a.Z<UCN\\\u0017AB2sK\u0006$X\r\u0006\u0003\u0002^\tE\u0003b\u0002B&;\u0001\u0007\u0011Q\f\u0015\u0004;\u0005}\u0014\u0001C7pm\u0016$\u0016m]6\u0015\u0015\u0005u#\u0011\fB/\u0005C\u0012Y\u0007C\u0004\u0003\\y\u0001\r!!\u0018\u0002\u0015Q\f7o\u001b+p\u001b>4X\rC\u0004\u0003`y\u0001\r!!\u0018\u0002\u00135|g/\u001a3UCN\\\u0007b\u0002B2=\u0001\u0007!QM\u0001\u0017kB$\u0017\r^3e\u001fJLw-\u001b8D_:$\u0018-\u001b8feB!\u0011q\fB4\u0013\u0011\u0011I'!\u0019\u0003\u001bQ\u000b7o[\"p]R\f\u0017N\\3s\u0011\u001d\u0011iG\ba\u0001\u0005K\na#\u001e9eCR,G\rV1sO\u0016$8i\u001c8uC&tWM\u001d\u0015\u0004=\u0005}\u0014A\u00064j]\u0012\feMZ3di\u0016$')\u001f\"mC\u000e\\w.\u001e;\u0015\t\u00055'Q\u000f\u0005\b\u0005oz\u0002\u0019\u0001B=\u0003!\u0011G.Y2l_V$\b\u0003\u0002B>\u0005\u0003k!A! \u000b\t\t}\u0014\u0011M\u0001\tG\u0006dWM\u001c3be&!!1\u0011B?\u0005!\u0011E.Y2l_V$\bfA\u0010\u0002\u0000\u0005Aq-\u001a;USRdW\r\u0006\u0003\u0002n\t-\u0005bBA6A\u0001\u0007\u0011Q\u000e\u0015\u0004A\u0005E\u0007f\u0001\u0011\u0002\u0000\u0005Qq-\u001a;BY2$\u0016mZ:\u0015\t\tU%1\u0014\t\u0007\u0003k\u00139*!\u001c\n\t\te\u0015q\u0017\u0002\u0004'\u0016$\bb\u0002BOC\u0001\u0007!qT\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u00024\u0005CK1Aa)5\u0005\rIe\u000e\u001e\u0015\u0004C\u0005E\u0007fA\u0011\u0002\u0000\u0005\u0011b-\u001b8e\u001fZ,'\u000fZ;f)\u0006\u001c8.\u00133t)\t\u0011i\u000b\u0005\u0004\u00030\ne\u0016Q\u000e\b\u0005\u0005c\u0013)L\u0004\u0003\u0002\u0010\tM\u0016\"A\u001b\n\u0007\t]F'A\u0004qC\u000e\\\u0017mZ3\n\t\tm&Q\u0018\u0002\u0004'\u0016\f(b\u0001B\\i!\u001a!%!5)\u0007\t\ny(\u0001\ngS:$G)^3T_>tG+Y:l\u0013\u0012\u001c\bfA\u0012\u0002R\"\u001a1%a \u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003\u0002Bg\u00053\u0004BAa4\u0003V6\u0011!\u0011\u001b\u0006\u0005\u0005'\f\t'\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0005/\u0014\tN\u0001\u0006UCN\\7\u000b^1ukNDq!a\u001b%\u0001\u0004\ti\u0007K\u0002%\u0003#D3\u0001JA@Q\r\u0001!\u0011\u001d\t\u0005\u0003'\u0014\u0019/\u0003\u0003\u0003f\u0006U'aD%t)J\fgn]1di&|g.\u00197")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((Seq<Task>)Predef$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$2)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$3, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        Seq tasks = (Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable & scala.Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$2) {
        String string = x$2.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

