/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.package;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%v!B\u000e\u001d\u0011\u0003Ic!B\u0016\u001d\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004\"B\u001b\u0002\t\u00031d\u0001B\u0016\u001d\u0001\u001dC\u0011\u0002\u0015\u0003\u0003\u0002\u0003\u0006Y!\u00152\t\u000bM\"A\u0011A2\t\u000b\u0019$A\u0011A4\t\u000b!$A\u0011A5\t\u000bu$A\u0011\u0001@\t\u000f\u0005mA\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0006\u0003\u0005\u0002\u0005-\u0002bBA\u0019\t\u0011\u0005\u00111\u0007\u0005\b\u0003\u001b\"A\u0011AA(\u0011\u001d\t\u0019\u0006\u0002C\u0001\u0003+Bq!a\u0017\u0005\t\u0003\ti\u0006C\u0004\u0002j\u0011!\t!a\u001b\t\u000f\u0005MD\u0001\"\u0001\u0002v!1\u0011Q\u0011\u0003\u0005\u0002\u001dDq!a\"\u0005\t\u0013\tI\tC\u0004\u0002\u0012\u0012!I!a%\t\u000f\u0005mE\u0001\"\u0003\u0002\u0014\"9\u0011Q\u0014\u0003\u0005\n\u0005M\u0005bBAP\t\u0011%\u00111\u0013\u0005\b\u0003C#A\u0011BAJ\u0011\u001d\t\u0019\u000b\u0002C\u0005\u0003'Cq!!*\u0005\t\u0003\n9+A\bUCN\\7oU9m\u0005VLG\u000eZ3s\u0015\tib$A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\n!B]3q_NLGo\u001c:z\u0015\t\u0019C%A\u0005yYJ,G.Z1tK*\u0011QEJ\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aJ\u0001\u0004G>l7\u0001\u0001\t\u0003U\u0005i\u0011\u0001\b\u0002\u0010)\u0006\u001c8n]*rY\n+\u0018\u000e\u001c3feN\u0011\u0011!\f\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0013!\u00048pe6\fG.\u001b>f)\u0006<7\u000f\u0006\u00028\u000bB\u0019\u0001h\u0010\"\u000f\u0005ej\u0004C\u0001\u001e0\u001b\u0005Y$B\u0001\u001f)\u0003\u0019a$o\\8u}%\u0011ahL\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%aA*fi*\u0011ah\f\t\u0003q\rK!\u0001R!\u0003\rM#(/\u001b8h\u0011\u001515\u00011\u00018\u0003\u0011!\u0018mZ:\u0014\u0005\u0011A\u0005cA%N\u001f6\t!J\u0003\u0002 \u0017*\u0011AJI\u0001\u0003I\nL!A\u0014&\u0003\u0015M\u000bHNQ;jY\u0012,'\u000f\u0005\u0002+\t\u00059A-[1mK\u000e$\bC\u0001*`\u001d\t\u0019VL\u0004\u0002U9:\u0011Qk\u0017\b\u0003-js!aV-\u000f\u0005iB\u0016\"A\u0014\n\u0005\u00152\u0013BA\u0012%\u0013\ta%%\u0003\u0002 \u0017&\u0011aLS\u0001\u000b'Fd')^5mI\u0016\u0014\u0018B\u00011b\u0005\u001d!\u0015.\u00197fGRT!A\u0018&\n\u0005AkE#\u00013\u0015\u0005=+\u0007\"\u0002)\u0007\u0001\b\t\u0016\u0001D:fY\u0016\u001cG\u000fV1tW&#G#A(\u00021]LG\u000f[(oK>3'+\u001a7fCN,7\u000b^1ukN,7\u000f\u0006\u0002PU\")1\u000e\u0003a\u0001Y\u0006A1\u000f^1ukN,7\u000fE\u0002neVt!A\u001c9\u000f\u0005iz\u0017\"\u0001\u0019\n\u0005E|\u0013a\u00029bG.\fw-Z\u0005\u0003gR\u00141aU3r\u0015\t\tx\u0006\u0005\u0002ww6\tqO\u0003\u0002ys\u000611\u000f^1ukNT!A\u001f\u0012\u0002\r\u0011|W.Y5o\u0013\taxOA\u0007SK2,\u0017m]3Ti\u0006$Xo]\u0001\u0010o&$\b\u000eV1tWRK\b/\u001a(piR\u0011qj \u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u0003!!\u0018m]6UsB,\u0007\u0003BA\u0003\u0003/i!!a\u0002\u000b\t\u0005%\u00111B\u0001\be\u00164G.Z2u\u0015\u0011\ti!a\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0012\u0005M\u0011A\u00029mk\u001eLgNC\u0002\u0002\u0016\u0011\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u00033\t9A\u0001\u0003UsB,\u0017!F<ji\"|e.Z(g)\u0006\u001c8n\u0015;biV\u001cXm\u001d\u000b\u0004\u001f\u0006}\u0001BB6\u000b\u0001\u0004\t\t\u0003\u0005\u0003ne\u0006\r\u0002c\u0001<\u0002&%\u0019\u0011qE<\u0003\u0015Q\u000b7o[*uCR,8/\u0001\u0006xSRDg)\u001b7uKJ$2aTA\u0017\u0011\u0019\tyc\u0003a\u0001\u0005\u00061a-\u001b7uKJ\f\u0011b^5uQ\u0012\u000bG/Z:\u0015\u000b=\u000b)$!\u0013\t\u000f\u0005]B\u00021\u0001\u0002:\u0005!aM]8n!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA!\u001e;jY*\u0011\u00111I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005u\"\u0001\u0002#bi\u0016Dq!a\u0013\r\u0001\u0004\tI$\u0001\u0002u_\u0006iq/\u001b;i\u0003:LxJ\u001a+bON$2aTA)\u0011\u00151U\u00021\u00018\u000359\u0018\u000e\u001e5G_2$WM]%egR\u0019q*a\u0016\t\r\u0005ec\u00021\u00018\u0003%1w\u000e\u001c3fe&#7/\u0001\txSRD\u0017i]:jO:,G\rV8NKR\u0019q*a\u0018\t\u000f\u0005\u0005t\u00021\u0001\u0002d\u0005Q\u0001O]5oG&\u0004\u0018\r\\:\u0011\t5\f)GQ\u0005\u0004\u0003O\"(\u0001C%uKJ\f'\r\\3\u00023]LG\u000f[!tg&<g.\u001a3U_6+wJ]'z)\u0016\fWn\u001d\u000b\u0006\u001f\u00065\u0014q\u000e\u0005\b\u0003C\u0002\u0002\u0019AA2\u0011\u001d\t\t\b\u0005a\u0001\u0003G\nqA]8mK&#7/A\u000bxSRD\u0017i]:jO:,G\rV8B]f\u0014w\u000eZ=\u0015\u000f=\u000b9(!\u001f\u0002|!9\u0011\u0011M\tA\u0002\u0005\r\u0004bBA9#\u0001\u0007\u00111\r\u0005\b\u0003{\n\u0002\u0019AA@\u0003\u001dI7/\u00113nS:\u00042ALAA\u0013\r\t\u0019i\f\u0002\b\u0005>|G.Z1o\u00035y'\u000fZ3s\u0005f$\u0016m]6JI\u00069!-\u001b8eS:<Gc\u0001\"\u0002\f\"9\u0011QR\nA\u0002\u0005=\u0015A\u0002<bYV,7\u000f\u0005\u0003n\u0003Kj\u0013!\u00036pS:$V-Y7t)\t\t)\nE\u0002/\u0003/K1!!'0\u0005\u0011)f.\u001b;\u0002!)|\u0017N\u001c+fC6\u001cHk\u001c+bg.\u001c\u0018!\u00046pS:$V-Y7S_2,7/\u0001\nk_&tG+Z1n!JLgnY5qC2\u001c\u0018a\u00056pS:$V-Y7QKJl\u0017n]:j_:\u001c\u0018a\u00036pS:4u\u000e\u001c3feN\f1B\\3x\u0013:\u001cH/\u00198dKV\tq\n")
public class TasksSqlBuilder
extends SqlBuilder<TasksSqlBuilder> {
    public static Set<String> normalizeTags(Set<String> set) {
        return TasksSqlBuilder$.MODULE$.normalizeTags(set);
    }

    public TasksSqlBuilder selectTaskId() {
        return (TasksSqlBuilder)super.select(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("SELECT\n         |  DISTINCT tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).append("\n         |FROM\n         |  ").append(Schema.TASKS$.MODULE$.TABLE()).append(" tasks\n         |  JOIN ").append(Schema.RELEASES$.MODULE$.TABLE()).append(" releases ON tasks.").append(Schema.TASKS$.MODULE$.RELEASE_UID()).append(" = releases.").append(Schema.RELEASES$.MODULE$.CI_UID()).append("\n         ").toString())).stripMargin());
    }

    public TasksSqlBuilder withOneOfReleaseStatuses(Seq<ReleaseStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(15).append("releases.").append(Schema.RELEASES$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withTaskTypeNot(Type taskType) {
        this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(11).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_TYPE()).append(" != ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{taskType.toString()}))));
        return this;
    }

    public TasksSqlBuilder withOneOfTaskStatuses(Seq<TaskStatus> statuses) {
        Object object = statuses.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(12).append("tasks.").append(Schema.TASKS$.MODULE$.STATUS()).append(" IN (").append(this.binding((Iterable<Object>)statuses)).append(")").toString(), (Iterable)statuses.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Seq$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withFilter(String filter) {
        Object object = filter != null ? this.likeOr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TITLE()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.OWNER()).toString(), new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TEAM()).toString(), new StringBuilder(9).append("releases.").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).toString()})), filter) : BoxedUnit.UNIT;
        return this;
    }

    public TasksSqlBuilder withDates(Date from, Date to) {
        Object object;
        if (from != null && to != null) {
            object = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(43).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(") AND tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{from, from, to}))));
        } else {
            Object object2 = from != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(28).append("(? <= tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" OR ? <= tasks.").append(Schema.TASKS$.MODULE$.END_DATE()).append(")").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{from, from})))) : BoxedUnit.UNIT;
            object = to != null ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(10).append("tasks.").append(Schema.TASKS$.MODULE$.START_DATE()).append(" < ?").toString(), (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{to})))) : BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAnyOfTags(Set<String> tags) {
        BoxedUnit boxedUnit;
        Set<String> normalizedTags = TasksSqlBuilder$.MODULE$.normalizeTags(tags);
        if (normalizedTags.nonEmpty()) {
            String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("\n           |tasks.").append(Schema.TASKS$.MODULE$.CI_UID()).append(" IN (\n           |  SELECT DISTINCT task_tags.").append(Schema.TASK_TAGS$.MODULE$.CI_UID()).append("\n           |  FROM ").append(Schema.TASK_TAGS$.MODULE$.TABLE()).append(" task_tags\n           |  WHERE task_tags.").append(Schema.TASK_TAGS$.MODULE$.VALUE()).append(" IN (").append(this.binding((Iterable<Object>)normalizedTags)).append(")\n           |)\n           |").toString())).stripMargin();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(sql, normalizedTags));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withFolderIds(Set<String> folderIds) {
        BoxedUnit boxedUnit;
        Set normalizedFolderIds = (Set)folderIds.map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Set$.MODULE$.canBuildFrom());
        if (normalizedFolderIds.nonEmpty()) {
            this.joinFolders();
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(14).append("folders.").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(" IN (").append(this.binding((Iterable<Object>)normalizedFolderIds)).append(")").toString(), (Iterable)normalizedFolderIds));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMe(Iterable<String> principals) {
        BoxedUnit boxedUnit;
        if (principals.nonEmpty()) {
            boxedUnit = this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(), Iterable$.MODULE$.canBuildFrom())));
        } else {
            this.nothingToBeFound_$eq(true);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder withAssignedToMeOrMyTeams(Iterable<String> principals, Iterable<String> roleIds) {
        this.joinTeamsToTasks();
        Seq orConditions = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (principals.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(19).append("LOWER(tasks.").append(Schema.TASKS$.MODULE$.OWNER()).append(") IN (").append(this.binding(principals)).append(")").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(), Iterable$.MODULE$.canBuildFrom()))})), Seq$.MODULE$.canBuildFrom());
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(105).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToMeOrTeamsPrincipals WHERE LOWER(assignedToMeOrTeamsPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.principalName()).append(") IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(), Iterable$.MODULE$.canBuildFrom()))})), Seq$.MODULE$.canBuildFrom());
        }
        if (roleIds.nonEmpty()) {
            orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(95).append("teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" IN (SELECT ").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append(" FROM ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToMeOrTeamsRoles WHERE LOWER(assignedToMeOrTeamsRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.memberRoleId()).append(") IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(), Iterable$.MODULE$.canBuildFrom()))})), Seq$.MODULE$.canBuildFrom());
        }
        ArrayBuffer arrayBuffer = orConditions.nonEmpty() ? this.conditions().$plus$eq((Object)new package.Sql(new StringBuilder(2).append("(").append(((TraversableOnce)orConditions.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("(").append(c.sql()).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" OR ")).append(")").toString(), (Iterable)orConditions.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parameters(), Seq$.MODULE$.canBuildFrom()))) : this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        return this;
    }

    public TasksSqlBuilder withAssignedToAnybody(Iterable<String> principals, Iterable<String> roleIds, boolean isAdmin) {
        BoxedUnit boxedUnit;
        if (!isAdmin) {
            Seq orConditions = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (roleIds.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(49).append("(LOWER(assignedToTeamRoles.MEMBER_ROLE_ID) IN (").append(this.binding(roleIds)).append("))").toString(), (Iterable)roleIds.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toLowerCase(), Iterable$.MODULE$.canBuildFrom()))})), Seq$.MODULE$.canBuildFrom());
            }
            if (principals.nonEmpty()) {
                orConditions = (Seq)orConditions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Sql[]{new package.Sql(new StringBuilder(54).append("(LOWER(assignedToTeamPrincipals.PRINCIPAL_NAME) IN (").append(this.binding(principals)).append("))").toString(), (Iterable)principals.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toLowerCase(), Iterable$.MODULE$.canBuildFrom()))})), Seq$.MODULE$.canBuildFrom());
            }
            boxedUnit = orConditions.isEmpty() ? this.conditions().$plus$eq((Object)new package.Sql("(1 = 0)", (Iterable)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))) : this.conditions().$plus$eq((Object)new package.Sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(425).append("releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" IN (\n             |  SELECT assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" FROM ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" assignedToTeams\n             |  JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" assignedToTeamPermissions ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" assignedToTeamPrincipals ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).append("\n             |  LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" assignedToTeamRoles ON assignedToTeams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = assignedToTeamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).append("\n             |  WHERE assignedToTeamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.permissionName()).append(" = '").append(XLReleasePermissions.VIEW_RELEASE.getPermissionName()).append("' AND (").append(((TraversableOnce)orConditions.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.sql(), Seq$.MODULE$.canBuildFrom())).mkString(" OR ")).append("))").toString())).stripMargin(), (Iterable)orConditions.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.parameters(), Seq$.MODULE$.canBuildFrom())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this;
    }

    public TasksSqlBuilder orderByTaskId() {
        this.orderBy(new StringBuilder(6).append("tasks.").append(Schema.TASKS$.MODULE$.TASK_ID()).toString());
        return this;
    }

    private String binding(Iterable<Object> values) {
        return ((TraversableOnce)values.toSeq().map((Function1 & Serializable & scala.Serializable)x$13 -> "?", Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private void joinTeams() {
        this.addJoin(new StringBuilder(33).append("JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).toString());
    }

    private void joinTeamsToTasks() {
        this.addJoin(new StringBuilder(58).append("LEFT JOIN ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).append(" teams ON releases.").append(Schema.RELEASES$.MODULE$.SECURITY_UID()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.ciId()).append(" AND tasks.").append(Schema.TASKS$.MODULE$.TEAM()).append(" = teams.").append(SecuritySchema.ROLES$.MODULE$.name()).toString());
    }

    private void joinTeamRoles() {
        this.addJoin(new StringBuilder(43).append("LEFT JOIN ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).append(" teamRoles ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamRoles.").append(SecuritySchema.ROLE_ROLES$.MODULE$.roleId()).toString());
    }

    private void joinTeamPrincipals() {
        this.addJoin(new StringBuilder(53).append("LEFT JOIN ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).append(" teamPrincipals ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPrincipals.").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.roleId()).toString());
    }

    private void joinTeamPermissions() {
        this.addJoin(new StringBuilder(50).append("JOIN ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).append(" teamPermissions ON teams.").append(SecuritySchema.ROLES$.MODULE$.id()).append(" = teamPermissions.").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.roleId()).toString());
    }

    private void joinFolders() {
        this.addJoin(new StringBuilder(37).append("JOIN ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" folders ON releases.").append(Schema.RELEASES$.MODULE$.FOLDER_CI_UID()).append(" = folders.").append(Schema.FOLDERS$.MODULE$.CI_UID()).toString());
    }

    public TasksSqlBuilder newInstance() {
        return new TasksSqlBuilder(super.dialect());
    }

    public TasksSqlBuilder(SqlBuilder.Dialect dialect) {
        super(dialect);
    }
}

