/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.PhaseRestart;
import com.xebialabs.xlrelease.service.PhaseRestart$;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u00119\u0003!\u0011!Q\u0001\n=C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\"AQ\f\u0001B\u0001B\u0003-a\fC\u0003e\u0001\u0011\u0005Q\rC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u0013\u00055\u0003!%A\u0005\u0002\u0005=\u0003\"CA2\u0001E\u0005I\u0011AA3\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\"\u0001\t\u0013\tI\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAm\u0001\u0011%\u00111\u001c\u0002\u0010'Fd\u0007\u000b[1tKJ+7\u000f^1si*\u0011q\u0003G\u0001\bg\u0016\u0014h/[2f\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\ta#\u0003\u0002*-\ta\u0001\u000b[1tKJ+7\u000f^1si\u0006I1o\u00195fIVdWM\u001d\t\u0003YIj\u0011!\f\u0006\u0003U9R!a\f\u0019\u0002\u0011AdW/\u001c2j]\u001eT!!\r\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRL!aM\u0017\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018A\u0003;bg.\u0014\u0015mY6vaB\u0011qEN\u0005\u0003oY\u0011!\u0002V1tW\n\u000b7m[;q\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005ijT\"A\u001e\u000b\u0005qB\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005yZ$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QI\u0011\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"a\n%\n\u0005%3\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3qK:$WM\\2z'\u0016\u0014h/[2f!\t9C*\u0003\u0002N-\t\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\tU\u0005\u0003#\n\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002U/6\tQK\u0003\u0002W1\u00051\u0011m\u0019;peNL!\u0001W+\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003\u0003nK!\u0001\u0018\"\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u0001\tKZ,g\u000e\u001e\"vgB\u0011qLY\u0007\u0002A*\u0011\u0011\rG\u0001\u0007KZ,g\u000e^:\n\u0005\r\u0004'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"\"BZ5kW2lgn\u001c9r)\t9\u0007\u000e\u0005\u0002(\u0001!)Ql\u0003a\u0002=\")!f\u0003a\u0001W!)Ag\u0003a\u0001k!)\u0001h\u0003a\u0001s!)qh\u0003a\u0001\u0001\")ai\u0003a\u0001\u000f\")!j\u0003a\u0001\u0017\")aj\u0003a\u0001\u001f\")!k\u0003a\u0001'\")\u0011l\u0003a\u00015\"\u00121b\u001d\t\u0003i~l\u0011!\u001e\u0006\u0003m^\f!\"\u00198o_R\fG/[8o\u0015\tA\u00180A\u0004gC\u000e$xN]=\u000b\u0005i\\\u0018!\u00022fC:\u001c(B\u0001?~\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001@\u0002\u0007=\u0014x-C\u0002\u0002\u0002U\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u001bI,7\u000f^1siBC\u0017m]3t)9\t9!a\u0005\u0002.\u0005E\u0012QGA \u0003\u0013\u0002B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bA\u0012A\u00023p[\u0006Lg.\u0003\u0003\u0002\u0012\u0005-!a\u0002*fY\u0016\f7/\u001a\u0005\b\u0003+a\u0001\u0019AA\f\u0003%\u0011X\r\\3bg\u0016LE\r\u0005\u0003\u0002\u001a\u0005\u001db\u0002BA\u000e\u0003G\u00012!!\b#\u001b\t\tyBC\u0002\u0002\"y\ta\u0001\u0010:p_Rt\u0014bAA\u0013E\u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eT1!!\n#\u0011\u001d\ty\u0003\u0004a\u0001\u0003/\tq\u0001\u001d5bg\u0016LE\rC\u0004\u000241\u0001\r!a\u0006\u0002\rQ\f7o[%e\u0011%\t9\u0004\u0004I\u0001\u0002\u0004\tI$\u0001\u0007qQ\u0006\u001cXMV3sg&|g\u000eE\u0002B\u0003wI1!!\u0010C\u00051\u0001\u0006.Y:f-\u0016\u00148/[8o\u0011%\t\t\u0005\u0004I\u0001\u0002\u0004\t\u0019%A\u0007sKN,X.\u001a*fY\u0016\f7/\u001a\t\u0004C\u0005\u0015\u0013bAA$E\t9!i\\8mK\u0006t\u0007bBA&\u0019\u0001\u0007\u0011qA\u0001\be\u0016dW-Y:f\u0003]\u0011Xm\u001d;beR\u0004\u0006.Y:fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002R)\"\u0011\u0011HA*W\t\t)\u0006\u0005\u0003\u0002X\u0005}SBAA-\u0015\u0011\tY&!\u0018\u0002\u0013Ut7\r[3dW\u0016$'B\u0001<#\u0013\u0011\t\t'!\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fsKN$\u0018M\u001d;QQ\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\r\u0016\u0005\u0003\u0007\n\u0019&A\u0007sKN$xN]3QQ\u0006\u001cXm\u001d\u000b\u0005\u0003[\n\u0019\t\u0005\u0004\u0002p\u0005e\u0014QP\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!Q\u000f^5m\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA>\u0003c\u0012A\u0001T5tiB!\u0011\u0011BA@\u0013\u0011\t\t)a\u0003\u0003\u000bAC\u0017m]3\t\u000f\u0005\u0015u\u00021\u0001\u0002n\u0005y\u0001\u000f[1tKN$vNU3ti>\u0014X-\u0001\u0007sKN$xN]3QQ\u0006\u001cX\r\u0006\u0003\u0002~\u0005-\u0005bBAG!\u0001\u0007\u0011QP\u0001\u0006a\"\f7/Z\u0001\re\u0016\u001cHo\u001c:f)\u0006\u001c8n\u001d\u000b\u0007\u0003'\u000bI*!*\u0011\u0007\u0005\n)*C\u0002\u0002\u0018\n\u0012A!\u00168ji\"9\u00111T\tA\u0002\u0005u\u0015!D8sS\u001eLg.\u00197UCN\\7\u000f\u0005\u0004\u0002p\u0005e\u0014q\u0014\t\u0005\u0003\u0013\t\t+\u0003\u0003\u0002$\u0006-!\u0001\u0002+bg.Dq!a*\u0012\u0001\u0004\ti*\u0001\u0005oK^$\u0016m]6t\u0003q)\b\u000fZ1uK\u001e\u000bG/Z:SK\u001a,'/\u001a8dS:<\u0007\u000b[1tKN$b!a%\u0002.\u0006\u0005\u0007bBAC%\u0001\u0007\u0011q\u0016\t\u0007\u0003c\u000bY,! \u000f\t\u0005M\u0016q\u0017\b\u0005\u0003;\t),C\u0001$\u0013\r\tILI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti,a0\u0003\u0007M+\u0017OC\u0002\u0002:\nBq!a1\u0013\u0001\u0004\ty+\u0001\bsKN$xN]3e!\"\f7/Z:\u0002\u001fM\\\u0017\u000e\u001d+bg.\u001c()\u001a4pe\u0016$\u0002\"!3\u0002P\u0006E\u0017Q\u001b\t\u0005\u0003\u0013\tY-\u0003\u0003\u0002N\u0006-!aB\"iC:<Wm\u001d\u0005\b\u0003g\u0019\u0002\u0019AA\f\u0011\u001d\t\u0019n\u0005a\u0001\u0003{\nQb\u001c:jO&t\u0017\r\u001c)iCN,\u0007bBAl'\u0001\u0007\u0011QP\u0001\u000ee\u0016\u001cHo\u001c:fIBC\u0017m]3\u0002\u001dA,'o]5tiJ+G.Z1tKRQ\u00111SAo\u0003C\f\u0019/a:\t\u000f\u0005}G\u00031\u0001\u0002\b\u0005AqN]5hS:\fG\u000eC\u0004\u0002LQ\u0001\r!a\u0002\t\u000f\u0005\u0015H\u00031\u0001\u0002J\u000691\r[1oO\u0016\u001c\bbBAb)\u0001\u0007\u0011Q\u000e\u0015\u0004\u0001\u0005-\b\u0003BAw\u0003gl!!a<\u000b\u0007\u0005E80\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!>\u0002p\nI1i\\7q_:,g\u000e\u001e")
public class SqlPhaseRestart
implements PhaseRestart {
    private final Scheduler scheduler;
    private final TaskBackup taskBackup;
    private final PermissionChecker permissions;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final DependencyService dependencyService;
    private final TaskRepository taskRepository;
    private final ReleaseActorService releaseActorService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;

    @Timed
    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, Release release) {
        return PhaseRestart.restartPhases$((PhaseRestart)this, (String)releaseId, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (Release)release);
    }

    public void checkCanRestartPhases(Release release, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        PhaseRestart.checkCanRestartPhases$((PhaseRestart)this, (Release)release, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (boolean)resumeRelease);
    }

    public Release restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease, Release release) {
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canBeBackup()))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskBackup.backupTask(task, release);
            return BoxedUnit.UNIT;
        });
        Release original = (Release)CiCloneHelper.cloneCi((ConfigurationItem)release);
        this.checkCanRestartPhases(release, phaseId, taskId, phaseVersion, resumeRelease);
        Seq phasesToRestore = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId, phaseVersion)).asScala();
        if (phasesToRestore.isEmpty()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, resumeRelease, new StringBuilder(37).append("There are no ").append(phaseVersion).append(" phases to restart from ").append(phaseId).toString());
        }
        PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.head(), this.permissions);
        List<Phase> restoredPhases = this.restorePhases((List)JavaConverters$.MODULE$.seqAsJavaListConverter(phasesToRestore).asJava());
        this.updateGatesReferencingPhases((Seq<Phase>)phasesToRestore, (Seq<Phase>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()));
        Changes changes = release.restorePhases(restoredPhases);
        changes.addAll(release.getCurrentPhase().close());
        changes.addAll(this.skipTasksBefore(taskId, (Phase)phasesToRestore.head(), restoredPhases.get(0)));
        this.persistRelease(original, release, changes, restoredPhases);
        return release;
    }

    public PhaseVersion restartPhases$default$4() {
        return PhaseVersion.ALL;
    }

    public boolean restartPhases$default$5() {
        return false;
    }

    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(phasesToRestore).asScala()).map((Function1 & Serializable & scala.Serializable)originalPhase -> {
            void var2_2;
            Phase restoredPhase = this.restorePhase((Phase)originalPhase);
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
            return var2_2;
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Phase restorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.ciIdService.getUniqueId(Type.valueOf(Phase.class), Ids.releaseIdFrom((String)phase.getId()));
        Phase copiedPhase = (Phase)CiCloneHelper.cloneCi((ConfigurationItem)phase);
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedPhase, (String)restoredPhaseId);
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        copiedPhase.setOriginId(phase.getId());
        return var3_3;
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> newTasks) {
        ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalTasks).asScala()).indices().foreach((Function1 & Serializable & scala.Serializable)i -> SqlPhaseRestart.$anonfun$restoreTasks$1(this, newTasks, originalTasks, BoxesRunTime.unboxToInt((Object)i)));
    }

    private void updateGatesReferencingPhases(Seq<Phase> phasesToRestore, Seq<Phase> restoredPhases) {
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored(phasesToRestore, restoredPhases);
        this.scheduler.execute(() -> ((IterableLike)phasesToRestore.flatMap((Function1 & Serializable & scala.Serializable)phase -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.dependencyService.findActiveIncomingGateIds(phase.getId())).asScala(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            this.releaseActorService.updateGateReferencingPhases(x$3, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)originToRestored).asJava());
            return BoxedUnit.UNIT;
        }));
    }

    private Changes skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        Changes changes;
        block0: {
            int taskIndexToRestartFrom = ((GenSeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(originalPhase.getTasks()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)CiHelper.TO_ID.apply(x$4), Buffer$.MODULE$.canBuildFrom())).indexOf((Object)taskId);
            changes = new Changes();
            if (taskIndexToRestartFrom <= 0) break block0;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Task task = (Task)restoredPhase.getTasks().get(i);
                changes.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
            });
        }
        return changes;
    }

    private void persistRelease(Release original, Release release, Changes changes, List<Phase> restoredPhases) {
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.releaseRepository.update(original, release);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlPhaseRestart.$anonfun$persistRelease$1(x$5)))).foreach((Function1 & Serializable & scala.Serializable)task -> {
            this.taskRepository.updateTaskProperties((Task)task);
            return BoxedUnit.UNIT;
        });
        this.facetRepositoryDispatcher.liveRepository().createFromTasks((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(restoredPhases).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.getAllTasks()).asScala(), Buffer$.MODULE$.canBuildFrom()), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    public static final /* synthetic */ Task $anonfun$restoreTasks$1(SqlPhaseRestart $this, List newTasks$1, List originalTasks$1, int i) {
        Task restoredTask = $this.taskBackup.restoreTask((Task)newTasks$1.get(i), ((BaseConfigurationItem)originalTasks$1.get(i)).getId(), true);
        restoredTask.getAllTasks().forEach(subTask -> subTask.setStatus(TaskStatus.PLANNED));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gateTask.getConditions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.setChecked(false);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return newTasks$1.set(i, restoredTask);
    }

    public static final /* synthetic */ boolean $anonfun$persistRelease$1(ConfigurationItem x$5) {
        return x$5 instanceof Task;
    }

    @Autowired
    public SqlPhaseRestart(Scheduler scheduler, TaskBackup taskBackup, PermissionChecker permissions, ReleaseRepository releaseRepository, CiIdService ciIdService, DependencyService dependencyService, TaskRepository taskRepository, ReleaseActorService releaseActorService, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus) {
        this.scheduler = scheduler;
        this.taskBackup = taskBackup;
        this.permissions = permissions;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.dependencyService = dependencyService;
        this.taskRepository = taskRepository;
        this.releaseActorService = releaseActorService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        PhaseRestart.$init$((PhaseRestart)this);
    }
}

