CREATE USER {{xlarchive}} IDENTIFIED BY xlarchive;
GRANT CONNECT,RESOURCE TO {{xlarchive}};
GRANT CREATE SESSION TO {{xlarchive}};

CREATE USER {{xlrelease}} IDENTIFIED BY xlrelease;
GRANT CONNECT, RESOURCE TO {{xlrelease}};
GRANT CREATE VIEW TO {{xlrelease}};

-- Liquibase needs to access the DBA_RECYCLEBIN table so we can automatically handle the case where constraints are deleted and restored. Since Oracle doesn't properly restore the original table names referenced in the constraint, we use the information from the DBA_RECYCLEBIN to automatically correct this issue.
GRANT SELECT ON SYS.DBA_RECYCLEBIN TO {{xlrelease}};
GRANT SELECT ON SYS.DBA_RECYCLEBIN TO {{xlarchive}};
