/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.xlrelease.domain.Release;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.assertj.core.api.Assertions;
import org.jboss.resteasy.core.Headers;

public class ExportTestUtil {
    public static List<FileContent> flattenZipContent(byte[] bytes) throws IOException {
        ArrayList files = Lists.newArrayList();
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                ByteArrayOutputStream fileContent = new ByteArrayOutputStream();
                ByteStreams.copy((InputStream)zipInputStream, (OutputStream)fileContent);
                files.add(new FileContent(entry.getName(), fileContent.toByteArray()));
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        return files;
    }

    public static Release getRelease(byte[] bytes, ConfigurationItemReaderWriter ciReaderWriter) throws IOException {
        List<FileContent> fileContents = ExportTestUtil.flattenZipContent(bytes);
        Assertions.assertThat(fileContents).extracting("filename").contains(new Object[]{"release-template.json"});
        for (FileContent fileContent : fileContents) {
            if (!fileContent.filename.equals("release-template.json")) continue;
            return ExportTestUtil.readRelease(ciReaderWriter, fileContent.content);
        }
        throw new IllegalStateException("Zip should contain a file named : release-template.json");
    }

    public static String getManifest(byte[] bytes) throws IOException {
        List<FileContent> fileContents = ExportTestUtil.flattenZipContent(bytes);
        Assertions.assertThat(fileContents).extracting("filename").contains(new Object[]{"manifest.json"});
        for (FileContent fileContent : fileContents) {
            if (!fileContent.filename.equals("manifest.json")) continue;
            return new String(fileContent.content, StandardCharsets.UTF_8);
        }
        throw new IllegalStateException("Zip should contain a file named : manifest.json");
    }

    private static Release readRelease(ConfigurationItemReaderWriter ciReaderWriter, byte[] bytes) throws IOException {
        return (Release)ciReaderWriter.readFrom(ConfigurationItem.class, Release.class, new Annotation[0], MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new Headers(), (InputStream)new ByteArrayInputStream(bytes));
    }

    public static class FileContent {
        String filename;
        byte[] content;

        private FileContent(String filename, byte[] content) {
            this.filename = filename;
            this.content = content;
        }
    }
}

