package com.xebialabs.xlrelease.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.core.Headers;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.xlrelease.domain.Release;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.io.ByteStreams.copy;
import static com.xebialabs.xlrelease.export.TemplateExporter.MANIFEST_JSON_FILE;
import static com.xebialabs.xlrelease.export.TemplateExporter.RELEASE_TEMPLATE_JSON_FILE;
import static java.nio.charset.StandardCharsets.UTF_8;
import static org.assertj.core.api.Assertions.assertThat;

public class ExportTestUtil {
    public static List<FileContent> flattenZipContent(byte[] bytes) throws IOException {
        List<FileContent> files = newArrayList();

        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(bytes))) {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                ByteArrayOutputStream fileContent = new ByteArrayOutputStream();
                copy(zipInputStream, fileContent);

                files.add(new FileContent(entry.getName(), fileContent.toByteArray()));
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }

        return files;
    }

    public static Release getRelease(byte[] bytes, ConfigurationItemReaderWriter ciReaderWriter) throws IOException {
        List<FileContent> fileContents = flattenZipContent(bytes);
        assertThat(fileContents).extracting("filename").contains(RELEASE_TEMPLATE_JSON_FILE);
        for (FileContent fileContent : fileContents) {
            if (fileContent.filename.equals(RELEASE_TEMPLATE_JSON_FILE)) {
                return readRelease(ciReaderWriter, fileContent.content);
            }
        }

        throw new IllegalStateException("Zip should contain a file named : " + RELEASE_TEMPLATE_JSON_FILE);
    }

    public static String getManifest(byte[] bytes) throws IOException {
        List<FileContent> fileContents = flattenZipContent(bytes);
        assertThat(fileContents).extracting("filename").contains(MANIFEST_JSON_FILE);
        for (FileContent fileContent : fileContents) {
            if (fileContent.filename.equals(MANIFEST_JSON_FILE)) {
                return new String(fileContent.content, UTF_8);
            }
        }

        throw new IllegalStateException("Zip should contain a file named : " + MANIFEST_JSON_FILE);
    }

    private static Release readRelease(ConfigurationItemReaderWriter ciReaderWriter, byte[] bytes) throws IOException {
        return (Release) ciReaderWriter.readFrom(ConfigurationItem.class, Release.class, new Annotation[]{}, MediaType.APPLICATION_JSON_TYPE, new Headers<String>(), new ByteArrayInputStream(bytes));
    }

    public static class FileContent {
        String filename;
        byte[] content;

        private FileContent(String filename, byte[] content) {
            this.filename = filename;
            this.content = content;
        }
    }
}
