package com.xebialabs.xlrelease.dsl.test

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.builder
import com.xebialabs.xlrelease.builder.VariableBuilder.{newPasswordStringVariable, newStringVariable}
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.domain.status.{ReleaseStatus, TaskStatus}
import com.xebialabs.xlrelease.domain.{Release, Task}
import com.xebialabs.xlrelease.dsl.test.DslIds._
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.VariableService
import org.scalatest.BeforeAndAfterEach

trait GroovyDslFixture extends BeforeAndAfterEach {
  self: GroovyScriptIntegrationScalaTest =>

  private lazy val variableService: VariableService = springBean[VariableService]

  override protected def beforeEach(): Unit = {
    super.beforeEach()
    fixture()
  }

  private def newFolder(id: String, title: String): Folder = newCi("xlrelease.Folder", id, title)

  private def newGroovyScriptTask(id: String, title: String): Task = {
    val task = newCi[Task]("xlrelease.GroovyScriptTask", id, title)
    task.setStatus(TaskStatus.PLANNED)
    task
  }

  private def newCi[T <: ConfigurationItem](ciType: String, id: String, title: String): T = {
    val ci: T = Type.valueOf(ciType).getDescriptor.newInstance(id)
    ci.setProperty("title", title)
    ci
  }

  /**
    * Fixture method provided by fixture trait creates at least a release with a groovy script task that has the id ID_TASK1.
    */
  //noinspection ScalaStyle
  def fixture(): Release = {
    val folder = newFolder(ID_FOLDER, "Container folder")
    val folder2 = newFolder(ID_FOLDER2, "Sub folder")

    folderService.create(Ids.getParentId(folder.getId), folder)
    folderService.create(Ids.getParentId(folder2.getId), folder2)

    val variable = newPasswordStringVariable("global.globalPasswordVariable", "passwordValue")
      .withId(ID_GLOBAL_VARIABLE)
      .withRequiresValue(false)
      .withShowOnReleaseStart(false)
      .build()
    val globalPassword = newPasswordStringVariable("global.adminPassword", "admin")
      .withId(ID_GLOBAL_VARIABLE2)
      .withRequiresValue(false)
      .withShowOnReleaseStart(false)
      .build()

    variableService.addGlobalVariable(variable)
    variableService.addGlobalVariable(globalPassword)
    markForDeletion(variable)
    markForDeletion(globalPassword)

    val release = builder.ReleaseBuilder.newRelease()
      .withId(ID_RELEASE1)
      .withTitle("my release")
      .withPhases(builder.PhaseBuilder.newPhase()
        .withId(ID_PHASE1)
        .withTitle("my phase")
        .withTasks(newGroovyScriptTask(ID_TASK1, "my task"))
        .build()
      )
      .withVariables(
        newStringVariable("createdReleaseId", null)
          .withId(ID_VARIABLE1)
          .build(),
        newStringVariable("customVar", "customVarValue")
          .withId(ID_VARIABLE2)
          .build(),
        newPasswordStringVariable("localPasswordVariable", "passwordValue")
          .withId(ID_VARIABLE3)
          .build()
      )
      .withOwner("Itchy")
      .withScriptUsername("admin")
      .withScriptUserPassword("admin")
      .build()

    val release2 = builder.ReleaseBuilder.newRelease()
      .withId(ID_RELEASE2)
      .withStatus(ReleaseStatus.PLANNED)
      .withTitle("my release 2")
      .withPhases(builder.PhaseBuilder.newPhase()
        .withId(ID_PHASE2)
        .withTitle("my phase 2")
        .withTasks(newGroovyScriptTask(ID_TASK22, "my task 2"))
        .build())
      .withOwner("Itchy")
      .withScriptUsername("admin")
      .withScriptUserPassword("admin")
      .build()

    val template1 = builder.ReleaseBuilder.newTemplate()
      .withId(ID_TEMPLATE1)
      .withTitle("Template 1")
      .build()

    storeRelease(release, release2, template1)

    markForDeletion(folder)

    release
  }

}
