package com.xebialabs.xlrelease.utils;

import java.util.Set;

import com.xebialabs.deployit.engine.spi.event.CisCreatedEvent;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;

import static com.google.common.collect.Sets.newHashSet;
import static java.lang.String.format;

public class TaskCommentsAwaiter extends BaseConditionAwaiter {

    private String taskId;
    private int expectedNumComments;
    private Set<Comment> comments = newHashSet();

    public TaskCommentsAwaiter(XLReleaseEventBus eventBus, String taskId, int expectedNumComments) {
        this(eventBus, taskId, expectedNumComments, DEFAULT_TIMEOUT);
    }

    public TaskCommentsAwaiter(XLReleaseEventBus eventBus, String taskId, int expectedNumComments, long timeout) {
        super(eventBus, timeout);
        this.expectedNumComments = expectedNumComments;
        this.taskId = taskId;
    }

    @Override
    protected String getErrorMessage() {
        return format("task %s did not have %s comments within timeout", taskId, expectedNumComments);
    }

    @SynchronizedSubscribe
    public void onCommentCreatedEvent(CisCreatedEvent event) {
        event.getCis().stream()
                .filter(ci -> ci instanceof Comment)
                .map(ci -> (Comment) ci)
                .filter(comment -> comment.getId().contains(taskId))
                .forEach(comment -> {
                    comments.add(comment);
                    if (comments.size() >= expectedNumComments) {
                        latch.countDown();
                    }
                });
    }

    @SynchronizedSubscribe
    public void onCommentCreatedXlrEvent(CommentCreatedEvent commentCreatedEvent) {
        Comment comment = commentCreatedEvent.comment();
        if (commentCreatedEvent.task().getId().equals(taskId)) {
            comments.add(comment);
        }
        if (comments.size() >= expectedNumComments) {
            latch.countDown();
        }
    }
}
