package com.xebialabs.xlrelease.test.async

import com.xebialabs.xlrelease.XLReleaseIntegrationTest
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.utils.{CleanupAwaiter, ConditionBuilder}

import scala.collection.mutable

trait AsyncSupport {
  self: XLReleaseIntegrationTest =>

  def eventBus: XLReleaseEventBus

  var registeredListeners: mutable.ListBuffer[CleanupAwaiter] = new mutable.ListBuffer[CleanupAwaiter]

  def async[T](block: => T): ConditionBuilder[T] = ConditionBuilder.execute[T](eventBus, () => block)

  def listen(): CleanupAwaiter = registerCloseable(async(()).listen())
}