package com.xebialabs.xlrelease.dsl.test

import com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.domain.{Release, ScriptTask}
import com.xebialabs.xlrelease.dsl.test.DslIds._

import scala.jdk.CollectionConverters._

trait GroovyDslIntegrationTest extends GroovyScriptIntegrationScalaTest with GroovyDslFixture {

  /**
    * Execute the passed DSL string and return release created by the DSL
    *
    * @param dsl DSL script that creates new release
    * @return release created by the DSL script
    */
  def executeDsl(dsl: String, shouldFail: Boolean = false): Release = {
    val release: Release = executeScript(
      s"""
         |import com.xebialabs.deployit.plugin.api.reflect.Type
         |import com.xebialabs.xlrelease.domain.Release
         |import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
         |import com.xebialabs.xlrelease.dsl.service.DslError
         |
         |ConfigurationItem server(String type, String title) {
         |  List<ConfigurationItem> cis = configurationApi.searchByTypeAndTitle(type, title)
         |  if (cis.isEmpty()) {
         |    throw new DslError("No CI found of type '%s' and title '%s'", type, title)
         |  }
         |  if (cis.size() > 1) {
         |    throw new DslError("More than one CI found of type '%s' and title '%s'", type, title)
         |  }
         |  cis.get(0)
         |}
         |
         |Release createdRelease = { $dsl }()
         |def createdReleaseVar = release.getVariablesByKeys().get('createdReleaseId')
         |createdReleaseVar.setValue(createdRelease.getId())
         |_releaseApi.updateVariable(createdReleaseVar)
        """.stripMargin)
    markForDeletion(release)
    verifyExecution(release, shouldFail)
  }

  /**
    * Verify the created release
    *
    * @return
    */
  protected def verifyExecution(executedRelease: Release, shouldFail: Boolean): Release = {
    val executedTask: ScriptTask = getTask(ID_TASK1)
    var createdRelease: Release = null
    if (shouldFail) {
      assertThat(executedTask).hasStatus(TaskStatus.FAILED)
    } else {
      if (executedTask.getStatus == TaskStatus.FAILED) {
        val allComments = executedTask.getComments.asScala.map(_.getText).mkString("\n")
        fail(s"Script task failed. Task comments: $allComments")
      }
      assertThat(executedTask).hasStatus(TaskStatus.COMPLETED)
      // check that some release was actually created? - more difficult
      val createdReleaseId = executedRelease.getVariablesByKeys.get("createdReleaseId").getValueAsString

      releaseRepository.exists(createdReleaseId).shouldBe(true)
      createdRelease = getRelease(createdReleaseId)
      markForDeletion(createdRelease)
      createdRelease.getAllGates.asScala.flatMap(_.getDependencies.asScala).foreach(markForDeletion)
      // teams.decorateWithEffectiveTeams(createdRelease)
    }
    createdRelease
  }
}
