package com.xebialabs.xlrelease.utils

import scala.concurrent.duration._
import scala.language.postfixOps

case class Repeat[A](get: () => A) {
  def until(cond: A => Boolean): Repeat.Until[A] = Repeat.Until(get, cond)
}

object Repeat {
  def repeat[A](get: => A): Repeat[A] = new Repeat[A](() => get)

  case class Until[A](get: () => A, cond: A => Boolean) {
    def run(attempts: Int, interval: FiniteDuration): Option[A] =
      Repeat.until(get, cond, attempts, interval)

    def run(): Option[A] = run(20, 1 second)
  }

  def until[A](get: () => A, until: A => Boolean, attempts: Int = 20, interval: FiniteDuration = 1 second): Option[A] = {
    (1 to attempts)
      .to(LazyList)
      .map(_ => get())
      .dropWhile {
        case a if until(a) =>
          false
        case _ =>
          Thread.sleep(interval.toMillis)
          true
      }.headOption
  }

}
