package com.xebialabs.xlrelease.utils

import scala.concurrent.duration._
import scala.language.postfixOps

case class Repeat[A](attempts: Int, interval: FiniteDuration, get: () => A) {
  def until(cond: A => Boolean): Option[A] = Repeat.Until(this, cond).run()
}

object Repeat {
  def repeat[A](get: => A): Repeat[A] = repeat(20, 1 second)(get)

  def repeat[A](attempts: Int)(get: => A): Repeat[A] = repeat(attempts, 1 second)(get)

  def repeat[A](attempts: Int, interval: FiniteDuration)(get: => A): Repeat[A] = new Repeat[A](attempts, interval, () => get)

  private case class Until[A](repeat: Repeat[A], cond: A => Boolean) {
    def run(): Option[A] = until(repeat, cond)

    private def until(repeat: Repeat[A], until: A => Boolean): Option[A] = {
      (1 to repeat.attempts)
        .to(LazyList)
        .map(_ => repeat.get())
        .dropWhile {
          case a if until(a) =>
            false
          case _ =>
            Thread.sleep(repeat.interval.toMillis)
            true
        }.headOption
    }
  }

}
