package com.xebialabs.xlrelease.script

import com.xebialabs.platform.script.jython.JythonException
import com.xebialabs.xlplatform.endpoints.actors.ScriptDone
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{Map => JMap}

/**
 * This service is used for testing of script execution.
 */
@Service
class ScriptTestService @Autowired()(endpointExecutor: EndpointJythonScriptTestExecutor) {

  /**
   * Executes a given endpoint Jython script and returns the result.
   * @param scriptLocation Jython script location in classpath.
   * @param query query parameters used when invoking the HTTP endpoint.
   * @param jsonEntity JSON entity submitted to the HTTP endpoint, or <code>null</code> if empty.
   * @param user user logged in when invoking HTTP endpoint.
   * @return the script execution result as it would be if a real endpoint would be executed.
   */
  @throws[JythonException]("JythonException if script execution failed")
  def executeEndpointScript(scriptLocation: String, query: JMap[String, AnyRef], jsonEntity: String, user: String): ScriptDone = {
    endpointExecutor.executeEndpointScript(scriptLocation, query, jsonEntity, user)
  }

}
