/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.ConfigurationItemsReaderWriter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.xlrelease.XLReleaseIntegrationTest;
import com.xebialabs.xlrelease.api.v1.NonEncryptingPasswordItemReaderWriter;
import com.xebialabs.xlrelease.rules.LoginRule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.junit.Before;
import org.junit.Rule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.restdocs.JUnitRestDocumentation;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.payload.RequestFieldsSnippet;
import org.springframework.restdocs.payload.ResponseFieldsSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.request.RequestDocumentation;
import org.springframework.restdocs.request.RequestParametersSnippet;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public abstract class BaseApiDocumentationTest
extends XLReleaseIntegrationTest {
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private ObjectMapper jacksonObjectMapper;
    @Autowired
    private ConfigurationItemReaderWriter configurationItemReaderWriter;
    @Autowired
    private NonEncryptingPasswordItemReaderWriter nonEncryptingPasswordItemReaderWriter;
    @Autowired
    private ConfigurationItemsReaderWriter configurationItemsReaderWriter;
    @Rule
    public JUnitRestDocumentation restDocumentation = new JUnitRestDocumentation("build/generated-snippets");
    @Rule
    public LoginRule loginRule = LoginRule.loginWithRoleAdmin((String)"admin");
    protected MockMvc mockMvc;
    protected RestDocumentationResultHandler documentationHandler;

    @Before
    public void setUp() {
        this.documentationHandler = MockMvcRestDocumentation.document((String)"{class-name}/{method-name}", (OperationRequestPreprocessor)Preprocessors.preprocessRequest((OperationPreprocessor[])new OperationPreprocessor[]{Preprocessors.prettyPrint()}), (OperationResponsePreprocessor)Preprocessors.preprocessResponse((OperationPreprocessor[])new OperationPreprocessor[]{Preprocessors.prettyPrint()}), (Snippet[])new Snippet[0]);
        this.mockMvc = ((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).apply((MockMvcConfigurer)MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)this.restDocumentation).uris().withScheme("http").withHost("localhost").withPort(5516))).alwaysDo((ResultHandler)this.documentationHandler)).build();
        RequestLocal.initMap();
    }

    protected RequestParametersSnippet paginatedRequestParametersSnippet() {
        return RequestDocumentation.requestParameters((ParameterDescriptor[])new ParameterDescriptor[]{((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"page").description((Object)"The page to fetch, zero-based; default value is 0")).optional(), ((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"resultsPerPage").description((Object)"Number of results per page, default value is 100")).optional(), ((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"depth").description((Object)"The depth of object tree, zero-based; default value is 1. Items fetched with depth 0 contain only basic properties like 'id' and 'type'. Items fetched with depth 1 contain simple properties (). Collections and references to other items are fetched only for basic properties.")).optional()});
    }

    protected RequestFieldsSnippet ciRequestFieldsSnippet(Type ciType) {
        return PayloadDocumentation.requestFields(this.ciFields(ciType)).and(this.ignoredFields());
    }

    protected ResponseFieldsSnippet ciResponseFieldsSnippet(Type ciType) {
        return this.ciResponseFieldsSnippet(ciType, "");
    }

    protected ResponseFieldsSnippet ciResponseFieldsSnippet(Type ciType, String prefix) {
        return PayloadDocumentation.responseFields((FieldDescriptor[])new FieldDescriptor[0]).andWithPrefix(prefix, this.ciFields(ciType)).andWithPrefix(prefix, this.ignoredFields());
    }

    protected RequestFieldsSnippet variableRequestSnippet() {
        return PayloadDocumentation.relaxedRequestFields((FieldDescriptor[])new FieldDescriptor[]{(FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"key").description((Object)"The unique name of the variable in the way it is used in template or release, without curly braces"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"value").description((Object)"Value of the release variable or default value of the template variable"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"requiresValue").description((Object)"Shows if an empty value is a valid value for this variable"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"showOnReleaseStart").description((Object)"Shows if this variable will be shown on create release page")});
    }

    protected String toJson(ConfigurationItem ci) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.configurationItemReaderWriter.writeTo(ci, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJsonWithPlainTextPassword(ConfigurationItem ci) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.nonEncryptingPasswordItemReaderWriter.writeTo(ci, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJson(List<ConfigurationItem> cis) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.configurationItemsReaderWriter.writeTo(cis, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJson(Object ci) throws Exception {
        return this.jacksonObjectMapper.writeValueAsString(ci);
    }

    private List<FieldDescriptor> ciFields(Type type) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        List typeFieldDescriptors = type.getDescriptor().getPropertyDescriptors().stream().map(pd -> {
            FieldDescriptor fieldDescriptor = ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)pd.getName()).description((Object)pd.getDescription())).type((Object)this.determineJsonType((PropertyDescriptor)pd));
            if (!pd.isRequired()) {
                fieldDescriptor = fieldDescriptor.optional();
            }
            if (pd.isHidden() || "internal".equals(pd.getCategory())) {
                fieldDescriptor = ((FieldDescriptor)fieldDescriptor.ignored()).optional();
            }
            return fieldDescriptor;
        }).collect(Collectors.toList());
        fieldDescriptors.addAll(this.basicCiFields(type));
        fieldDescriptors.addAll(typeFieldDescriptors);
        return fieldDescriptors;
    }

    private List<FieldDescriptor> basicCiFields(Type type) {
        return Arrays.asList((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"id").description((Object)"This field contains ID of object. It is required but not used on update operations. When creating objects just send 'null'."), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"type").description((Object)String.format("This field represents type of '%s'.", type)));
    }

    private List<FieldDescriptor> ignoredFields() {
        return Arrays.asList(((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$token").description((Object)"The CI optimistic locking hash-tag, please remove it from the API!")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$createdAt").description((Object)"The date when this CI was created")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$createdBy").description((Object)"The user that created this CI")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$lastModifiedAt").description((Object)"The date when this CI was last modified")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$lastModifiedBy").description((Object)"The last user that modified this CI")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$metadata").description((Object)"The internal metadata for this CI")).ignored()).optional());
    }

    private JsonFieldType determineJsonType(PropertyDescriptor pd) {
        switch (pd.getKind()) {
            case BOOLEAN: {
                return JsonFieldType.BOOLEAN;
            }
            case CI: {
                return JsonFieldType.VARIES;
            }
            case INTEGER: {
                return JsonFieldType.NUMBER;
            }
            case ENUM: {
                return JsonFieldType.STRING;
            }
            case LIST_OF_CI: {
                return JsonFieldType.ARRAY;
            }
            case LIST_OF_STRING: {
                return JsonFieldType.ARRAY;
            }
            case SET_OF_CI: {
                return JsonFieldType.ARRAY;
            }
            case SET_OF_STRING: {
                return JsonFieldType.ARRAY;
            }
            case MAP_STRING_STRING: {
                return JsonFieldType.OBJECT;
            }
        }
        return JsonFieldType.STRING;
    }
}

