/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Profile(value={"sql"})
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001\u0002\r\u001a\u0001\u0001B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"Aq\u000f\u0001B\u0001B\u0003%Q\fC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011q\n\u0001\u0005\u0012\u0005E\u0003bBA\u0016\u0001\u0011\u0005\u0013Q\u000b\u0005\b\u0003O\u0002A\u0011IA5\u0011\u001d\t)\b\u0001C!\u0003;Aq!a\u001e\u0001\t\u0013\tI\bC\u0004\u0002|\u0001!\t!!\b\b\u000f\u0005=\u0016\u0004#\u0001\u00022\u001a1\u0001$\u0007E\u0001\u0003gCaA_\u000b\u0005\u0002\u0005m\u0006bBA4+\u0011\u0005\u0011Q\u0018\u0002\u0011'Fd7\u000b^8sC\u001e,g)Y2bI\u0016T!AG\u000e\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000f\u001e\u0003%AXMY5bY\u0006\u00147OC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0011%K\u0017\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t1qJ\u00196fGR\u0004\"AK\u0016\u000e\u0003eI!\u0001L\r\u0003\u001bM#xN]1hK\u001a\u000b7-\u00193f!\tQc&\u0003\u000203\t\u0011B+Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000351w\u000e\u001c3feN+'O^5dKB\u0011!'N\u0007\u0002g)\u0011A'G\u0001\bg\u0016\u0014h/[2f\u0013\t14GA\u0007G_2$WM]*feZL7-Z\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z!\tId(D\u0001;\u0015\tYD(A\u0002tc2T!!P\r\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002@u\t\t2+\u001d7UK\u0006l'+\u001a9pg&$xN]=\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002C\u00076\tA(\u0003\u0002Ey\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f!\t\u0011t)\u0003\u0002Ig\t!\"+\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\fQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002L\u001d6\tAJ\u0003\u0002Nu\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tyEJA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001\"S\u0013\t\u0019FHA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u000692-\u00197f]\u0012\f'/\u00128uef\u0014V\r]8tSR|'/\u001f\t\u0003\u0005ZK!a\u0016\u001f\u0003/\r\u000bG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\t\u0011$,\u0003\u0002\\g\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\rU\u0012\u00147\rV3na2\fG/\u001a\t\u0003=\u001el\u0011a\u0018\u0006\u0003A\u0006\fAaY8sK*\u0011!mY\u0001\u0005U\u0012\u00147M\u0003\u0002eK\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001g\u0003\ry'oZ\u0005\u0003Q~\u0013AB\u00133cGR+W\u000e\u001d7bi\u0016DC!\u00036ukB\u00111N]\u0007\u0002Y*\u0011QN\\\u0001\u000bC:tw\u000e^1uS>t'BA8q\u0003\u001d1\u0017m\u0019;pefT!!]2\u0002\u000b\t,\u0017M\\:\n\u0005Md'!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00051\u0018!\u0007=meJ+\u0007o\\:ji>\u0014\u0018P\u00133cGR+W\u000e\u001d7bi\u0016\fQC]3q_J$\u0018N\\4KI\n\u001cG+Z7qY\u0006$X\r\u000b\u0003\u000bURL\u0018%A<\u0002\rqJg.\u001b;?)IaXP`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!a\u0004\u0011\u0005)\u0002\u0001\"\u0002\u0019\f\u0001\u0004\t\u0004\"B\u001c\f\u0001\u0004A\u0004\"\u0002!\f\u0001\u0004\t\u0005\"B#\f\u0001\u00041\u0005\"B%\f\u0001\u0004Q\u0005\"\u0002)\f\u0001\u0004\t\u0006\"\u0002+\f\u0001\u0004)\u0006\"\u0002-\f\u0001\u0004I\u0006\"\u0002/\f\u0001\u0004i\u0006&BA\u0006UR,\b\"B<\f\u0001\u0004i\u0006&BA\bURL\bfA\u0006\u0002\u0016A\u00191.a\u0006\n\u0007\u0005eANA\u0005BkR|w/\u001b:fI\u000691\r\\3b]V\u0004HCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"BAA\u0013\u0003\u0015\u00198-\u00197b\u0013\u0011\tI#a\t\u0003\tUs\u0017\u000e^\u0001\u0007I\u0016dW\r^3\u0015\t\u0005=\u0012Q\u0007\t\u0005\u0003C\t\t$\u0003\u0003\u00024\u0005\r\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003oi\u0001\u0019AA\u001d\u0003\tIG\r\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u0002B!a\u0010\u0002$5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007z\u0012A\u0002\u001fs_>$h(\u0003\u0003\u0002H\u0005\r\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002L\u00055#AB*ue&twM\u0003\u0003\u0002H\u0005\r\u0012!\u00043fY\u0016$XMU3mK\u0006\u001cX\r\u0006\u0003\u0002 \u0005M\u0003bBA\u001c\u001d\u0001\u0007\u0011\u0011\b\u000b\u0005\u0003_\t9\u0006C\u0004\u0002Z=\u0001\r!a\u0017\u0002\tQ,\u0017-\u001c\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M\r\u0002\r\u0011|W.Y5o\u0013\u0011\t)'a\u0018\u0003\tQ+\u0017-\\\u0001\u0012I\u0016dW\r^3Ge>l\u0017I]2iSZ,G\u0003BA6\u0003c\u0002B!!\t\u0002n%!\u0011qNA\u0012\u0005\rIe\u000e\u001e\u0005\b\u0003g\u0002\u0002\u0019AA\u001d\u0003%\u0011X\r\\3bg\u0016LE-A\u000bwKJLg-\u001f*fa>\u001c\u0018\u000e^8ss\u000ecW-\u00198\u0002)9,XNU3mK\u0006\u001cXm\u001d*f[\u0006Lg.\u001b8h+\t\tY'\u0001\bdY\u0016\fg\u000e\u00177WKJ\u001c\u0018n\u001c8)\u0007M\ty\b\u0005\u0003\u0002\u0002\u0006%UBAAB\u0015\ri\u0017Q\u0011\u0006\u0003\u0003\u000f\u000bQA[1wCbLA!a#\u0002\u0004\nQ\u0001K]3EKN$(o\\=)\u0007\u0001\ty\t\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)jY\u0001\u000bgR,'/Z8usB,\u0017\u0002BAM\u0003'\u0013\u0011bQ8na>tWM\u001c;)\r\u0001\ti\n^AV!\u0011\ty*a*\u000e\u0005\u0005\u0005&bA7\u0002$*\u0019\u0011QU2\u0002\u000f\r|g\u000e^3yi&!\u0011\u0011VAQ\u0005\u001d\u0001&o\u001c4jY\u0016d#!!,\"\u0003m\n\u0001cU9m'R|'/Y4f\r\u0006\u001c\u0017\rZ3\u0011\u0005)*2cA\u000b\u00026B!\u0011\u0011EA\\\u0013\u0011\tI,a\t\u0003\r\u0005s\u0017PU3g)\t\t\t\f\u0006\u0003\u0002@\u0006\rG\u0003BA6\u0003\u0003DQ\u0001X\fA\u0002uCq!a\u001d\u0018\u0001\u0004\tI\u0004")
public class SqlStorageFacade
implements StorageFacade,
TestAuthentication {
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    @Override
    public void cleanup() {
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.DEPENDENCIES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(SecuritySchema.ROLES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.CONFIGURATION_REFS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.COMMENTS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.TASKS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute("DELETE FROM XLR_ACTIVITY_LOGS");
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.RELEASES_EXT$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute("DELETE FROM XLR_RISK_ASSESSMENTS");
        this.jdbcTemplate.execute("DELETE FROM XLR_RISKS");
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(Schema.ARTIFACTS$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        this.jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(MetadataSchema.METADATA$.MODULE$.TABLE()).toString());
        this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
    }

    @Override
    public boolean delete(String id) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Object object;
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
                object = BoxedUnit.UNIT;
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id);
                object = BoxedUnit.UNIT;
            } else if (Ids.isPlanItemId((String)id)) {
                object = BoxedUnit.UNIT;
            } else if (Ids.isFolderId((String)id)) {
                if ($this.folderService.exists(id)) {
                    $this.folderService.delete(id);
                }
                object = BoxedUnit.UNIT;
            } else if (Ids.isCustomConfigurationId((String)id)) {
                object = BoxesRunTime.boxToBoolean((boolean)$this.configurationRepository.delete(id));
            } else if (Ids.isCalendarId((String)id)) {
                $this.calendarEntryRepository.delete(id);
                object = BoxedUnit.UNIT;
            } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                object = BoxesRunTime.boxToBoolean((boolean)$this.configurationRepository.delete(id));
            } else {
                if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                }
                object = BoxedUnit.UNIT;
            }
            return true;
        });
        if (try_ instanceof Success) {
            bl = true;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
            bl = false;
        } else {
            throw new MatchError((Object)try_);
        }
        return bl;
    }

    public void deleteRelease(String id) {
        block3: {
            block2: {
                if (!this.releaseRepository.exists(id)) break block2;
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                break block3;
            }
            if (!this.archivingService.exists(id)) break block3;
            this.deleteFromArchive(id);
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        int numReleases = this.numReleasesRemaining();
        if (numReleases > 0) {
            List releasesFound = this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(", ").append(Schema.RELEASES$.MODULE$.CI_UID()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$1) -> new StringBuilder(2).append(rs.getString(1)).append("(").append(rs.getString(2)).append(")").toString());
            String leftovers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(releasesFound).asScala()).mkString(",");
            throw new RuntimeException(new StringBuilder(41).append("Found ").append(numReleases).append(" releases after test has finished: ").append(leftovers).toString());
        }
    }

    private int numReleasesRemaining() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlVersion() {
        this.jdbcTemplate.execute("DELETE FROM XL_VERSION");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        TestAuthentication.$init$((TestAuthentication)this);
    }
}

