/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class Eventually {
    private static final int TIMEOUT_MS = 45000;
    private ReleaseRepository releaseRepository;
    private ArchivedReleases archivedReleases;
    private CommentRepository commentRepository;
    private final long timeoutMs;
    private static final Logger log = LoggerFactory.getLogger(Eventually.class);

    public Eventually(ReleaseRepository releaseRepository, ArchivedReleases archivedReleases, CommentRepository commentRepository) {
        this.releaseRepository = releaseRepository;
        this.archivedReleases = archivedReleases;
        this.commentRepository = commentRepository;
        this.timeoutMs = 45000L;
    }

    public <T extends Task> EventuallyTask<T> task(String taskId) {
        return new EventuallyTask(taskId);
    }

    public EventuallyComments comments(String taskId) {
        return new EventuallyComments(taskId);
    }

    public EventuallyRelease release(String releaseId) {
        return new EventuallyRelease(releaseId);
    }

    public EventuallyArchived archived(String releaseId) {
        return new EventuallyArchived(releaseId);
    }

    public <R> R eventually(Supplier<R> supplier, Predicate<R> predicate) {
        try {
            return (R)CompletableFuture.supplyAsync(() -> {
                long start = System.currentTimeMillis();
                Exception lastException = null;
                while (true) {
                    try {
                        while (true) {
                            Object handle;
                            if (predicate.test(handle = supplier.get())) {
                                return handle;
                            }
                            long duration = System.currentTimeMillis() - start;
                            if (duration > this.timeoutMs) {
                                throw new AssertionError("Could not complete within " + this.timeoutMs + " millis", lastException);
                            }
                            Thread.sleep(250L);
                        }
                    }
                    catch (Exception store) {
                        lastException = store;
                        continue;
                    }
                    break;
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class EventuallyArchived {
        private String releaseId;

        public EventuallyArchived(String releaseId) {
            this.releaseId = releaseId;
        }

        public boolean isPreArchived() {
            return Eventually.this.eventually(() -> Eventually.this.archivedReleases.existsPreArchived(this.releaseId), preArchived -> preArchived);
        }

        public boolean isArchived() {
            return Eventually.this.eventually(() -> Eventually.this.archivedReleases.exists(this.releaseId), archived -> archived);
        }
    }

    public class EventuallyRelease {
        private String releaseId;

        public EventuallyRelease(String releaseId) {
            this.releaseId = releaseId;
        }

        public Release hasStatus(ReleaseStatus status) {
            return Eventually.this.eventually(() -> Eventually.this.releaseRepository.findById(this.releaseId), release -> release.getStatus() == status);
        }

        public Release hasOneOfStatus(List<ReleaseStatus> statuses) {
            return Eventually.this.eventually(() -> Eventually.this.releaseRepository.findById(this.releaseId), release -> statuses.contains(release.getStatus()));
        }

        public Release hasExtensionsLoaded() {
            return Eventually.this.eventually(() -> Eventually.this.releaseRepository.findById(this.releaseId), release -> !release.getExtensions().isEmpty());
        }
    }

    public class EventuallyComments {
        private String taskId;

        public EventuallyComments(String taskId) {
            this.taskId = taskId;
        }

        public List<Comment> hasComments(int numberOfComments) {
            return Eventually.this.eventually(() -> JavaConverters.seqAsJavaList((Seq)Eventually.this.commentRepository.findByTask(this.taskId)), comments -> comments.size() == numberOfComments);
        }
    }

    public class EventuallyTask<T extends Task> {
        private String taskId;

        public EventuallyTask(String taskId) {
            this.taskId = taskId;
        }

        public T hasStatus(TaskStatus status) {
            return (T)Eventually.this.eventually(() -> Eventually.this.releaseRepository.findById(Ids.releaseIdFrom((String)this.taskId)).getTask(this.taskId), task -> task.getStatus() == status);
        }

        public T hasOneOfStatus(List<TaskStatus> statuses) {
            return (T)Eventually.this.eventually(() -> Eventually.this.releaseRepository.findById(Ids.releaseIdFrom((String)this.taskId)).getTask(this.taskId), task -> statuses.contains(task.getStatus()));
        }
    }
}

