/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.platform.script.jython.JythonException;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptServiceHelper;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SynchronousScriptService {
    private DefaultScriptService jythonScriptService;
    private ScriptLifeCycle scriptLifeCycle;
    private AuthenticationService authenticationService;
    private TaskRepository taskRepository;

    @Autowired
    public SynchronousScriptService(JythonScriptService jythonScriptService, ScriptLifeCycle scriptLifeCycle, AuthenticationService authenticationService, TaskRepository taskRepository) {
        this.jythonScriptService = jythonScriptService;
        this.scriptLifeCycle = scriptLifeCycle;
        this.authenticationService = authenticationService;
        this.taskRepository = taskRepository;
    }

    public String executeScriptTask(ScriptTask task) throws JythonException {
        XlrScriptContext scriptContext = this.jythonScriptService.prepareScriptTaskContext((Task)task, (Writer)this.jythonScriptService.getExecutionLog());
        Map previousReleaseVariables = task.getRelease().getVariablesByKeys();
        this.cloneVariableValues(previousReleaseVariables);
        Map previousGlobalVariables = Optional.ofNullable(task.getRelease().getGlobalVariables()).map(GlobalVariables::getVariablesByKeys).orElse(new HashMap());
        this.cloneVariableValues(previousGlobalVariables);
        Map previousFolderVariables = Optional.ofNullable(task.getRelease().getFolderVariables()).map(FolderVariables::getVariablesByKeys).orElse(new HashMap());
        this.cloneVariableValues(previousFolderVariables);
        String output = this.executeScriptSynchronously(task.getScript(), scriptContext, (Task)task, true);
        DefaultScriptService.ScriptTaskResults scriptTaskResults = new DefaultScriptService.ScriptTaskResults(ScriptServiceHelper.extractReleaseVariables((ScriptContext)scriptContext), ScriptServiceHelper.extractGlobalVariables((ScriptContext)scriptContext), ScriptServiceHelper.extractFolderVariables((ScriptContext)scriptContext), previousReleaseVariables, previousGlobalVariables, previousFolderVariables);
        this.jythonScriptService.saveScriptResults(task.getId(), scriptTaskResults);
        return output;
    }

    private void cloneVariableValues(Map<String, Variable> variablesMap) {
        variablesMap.entrySet().forEach(entry -> {
            CiHelper.eraseTokens((ConfigurationItem)((ConfigurationItem)entry.getValue()));
            entry.setValue(CiCloneHelper.cloneCi((ConfigurationItem)((ConfigurationItem)entry.getValue())));
        });
    }

    public String executeCustomScriptTask(CustomScriptTask task) throws JythonException {
        try {
            String script = task.getPythonScript().getScript();
            return this.executeCustomScriptTask(task, script);
        }
        catch (IOException e) {
            throw new JythonException(String.format("Error while loading script on task '%s'", task.getId()), (Exception)e);
        }
    }

    @VisibleForTesting
    String executeCustomScriptTask(CustomScriptTask task, String scriptContent) throws JythonException {
        XlrScriptContext scriptContext = this.jythonScriptService.prepareCustomScriptTaskContext(task, (Writer)this.jythonScriptService.getExecutionLog());
        String output = this.executeScriptSynchronously(scriptContent, scriptContext, (Task)task, false);
        task = (CustomScriptTask)this.taskRepository.findById(task.getId(), new ResolveOptionsBuilder().withEverything().build());
        this.jythonScriptService.processCustomScriptTaskResults(task, ScriptServiceHelper.extractTransitionalAndOutputPropertyValues((CustomScriptTask)task, (ScriptContext)scriptContext));
        this.jythonScriptService.saveCustomScriptResults(task.getId(), new DefaultScriptService.CustomScriptTaskResults(ScriptServiceHelper.extractTransitionalAndOutputPropertyValues((CustomScriptTask)task, (ScriptContext)scriptContext), task.getExecutionId(), task.getStatusLine(), task.getNextScriptPath(), task.getInterval()));
        return output;
    }

    @VisibleForTesting
    XlrScriptContext prepareCustomScriptTaskContext(CustomScriptTask task) {
        return this.jythonScriptService.prepareCustomScriptTaskContext(task, (Writer)this.jythonScriptService.getExecutionLog());
    }

    public boolean executePrecondition(Task task) throws JythonException {
        this.scriptLifeCycle.register(task.getExecutionId());
        StringWriter stringWriter = new StringWriter();
        this.jythonScriptService.getExecutionLog().registerWriter((Writer)stringWriter);
        String script = task.getPrecondition();
        try {
            this.authenticationService.loginScriptUser(task);
            XlrScriptContext scriptContext = this.jythonScriptService.prepareScriptTaskContext(task, (Writer)this.jythonScriptService.getExecutionLog());
            Object statementResult = this.jythonScriptService.executeScript(script, scriptContext, task, true);
            Object resultVariable = scriptContext.getAttribute("result");
            if (statementResult == null && resultVariable == null) {
                throw new JythonException("Precondition did not return anything", null);
            }
            boolean bl = this.isTrue(statementResult) || this.isTrue(resultVariable);
            return bl;
        }
        catch (Exception exception) {
            this.closeQuietly(this.jythonScriptService.getExecutionLog());
            throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), exception);
        }
        finally {
            this.authenticationService.logoutScriptUser();
            this.closeQuietly(this.jythonScriptService.getExecutionLog());
            this.scriptLifeCycle.unregister(task.getExecutionId());
        }
    }

    private String executeScriptSynchronously(String script, XlrScriptContext scriptContext, Task task, boolean checkPolicyPermissions) throws JythonException {
        this.scriptLifeCycle.register(task.getExecutionId());
        StringWriter stringWriter = new StringWriter();
        this.jythonScriptService.getExecutionLog().registerWriter((Writer)stringWriter);
        try {
            this.authenticationService.loginScriptUser(task);
            this.jythonScriptService.executeScript(script, scriptContext, task, checkPolicyPermissions);
        }
        catch (ScriptException exception) {
            if (!this.jythonScriptService.isSystemExit0(exception)) {
                this.closeQuietly(this.jythonScriptService.getExecutionLog());
                throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), (Exception)exception);
            }
        }
        catch (Exception exception) {
            this.closeQuietly(this.jythonScriptService.getExecutionLog());
            throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), exception);
        }
        finally {
            this.authenticationService.logoutScriptUser();
            this.closeQuietly(this.jythonScriptService.getExecutionLog());
            this.scriptLifeCycle.unregister(task.getExecutionId());
        }
        return stringWriter.toString();
    }

    private void closeQuietly(ThreadLocalWriterDecorator log) {
        try {
            log.getWriter().close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private boolean isTrue(Object preconditionResult) {
        return preconditionResult instanceof Boolean && (Boolean)preconditionResult != false;
    }
}

