/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.repository.sql.db.MetadataSchema;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.SqlStorageFacade$;
import com.xebialabs.xlrelease.StorageFacade;
import com.xebialabs.xlrelease.TestAuthentication;
import com.xebialabs.xlrelease.TestCleanupException;
import com.xebialabs.xlrelease.actors.utils.ScalaSpringSupport;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.LiquibaseSupport;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.SqlTeamRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.upgrade.liquibase.BeforeUpgrade;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import liquibase.Liquibase;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Profile(value={"integrationTest"})
@ScalaSignature(bytes="\u0006\u0001\rma\u0001\u0002\u001b6\u0001qB\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tg\u0002\u0011\t\u0011)A\u0005i\"AA\u0010\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0004\u0005\u000b\u0003C\u0001!\u0011!Q\u0001\n\u0005\r\u0002BCA\u0015\u0001\t\u0005\t\u0015!\u0003\u0002,!Q\u0011\u0011\u0007\u0001\u0003\u0002\u0003\u0006I!a\r\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B!\"a\u001c\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!a(\u0001\t\u0003\n\t\u000b\u0003\u0004O\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u000f\u0004A\u0011IAe\u0011\u001d\tI\u000e\u0001C!\u0003sCq!a7\u0001\t\u0013\ti\u000eC\u0004\u0002`\u0002!I!!8\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001e\u0001\u0005\n\u0005\r\bBCAw\u0001!\u0015\r\u0011\"\u0001\u0002p\"I\u0011q \u0001C\u0002\u0013%!\u0011\u0001\u0005\t\u0005\u0013\u0001\u0001\u0015!\u0003\u0003\u0004!9!1\u0002\u0001\u0005\u0002\t5\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005k\u0001A\u0011IA]\u0011\u001d\u00119\u0004\u0001C!\u0005sAqAa\u0010\u0001\t#\u0011\t\u0005C\u0004\u00038\u0001!\tE!\u0012\t\u000f\t]\u0003\u0001\"\u0011\u0003Z!9!Q\r\u0001\u0005B\u0005e\u0006b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\b\u0005W\u0002A\u0011\u0002B7\u0011\u001d\u0011I\n\u0001C\u0005\u0005SBqAa'\u0001\t\u0013\u0011I\u0007C\u0004\u0003\u001e\u0002!IAa(\t\u000f\t\r\u0006\u0001\"\u0003\u0003&\"9!q\u0015\u0001\u0005\n\t\u0015\u0006b\u0002BU\u0001\u0011%!Q\u0015\u0005\b\u0005W\u0003A\u0011\u0002B5\u0011\u001d\u0011i\u000b\u0001C\u0001\u0003sC1Ba/\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003>\"Y!Q\u0019\u0001A\u0002\u0003\u0007I\u0011\u0001Bd\u0011-\u0011i\r\u0001a\u0001\u0002\u0003\u0006KAa0\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!q\u001c\u0001\u0005\u0002\t\u0005xaBB\u0003k!\u00051q\u0001\u0004\u0007iUB\ta!\u0003\t\u000f\u0005U\u0014\u0007\"\u0001\u0004\u0012!9!qK\u0019\u0005\u0002\rM!\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f\u0015\t1t'A\u0005yYJ,G.Z1tK*\u0011\u0001(O\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AO\u0001\u0004G>l7\u0001A\n\t\u0001u*\u0015*\u0015+[EB\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005Y\u0006twMC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AB(cU\u0016\u001cG\u000f\u0005\u0002G\u000f6\tQ'\u0003\u0002Ik\ti1\u000b^8sC\u001e,g)Y2bI\u0016\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u00131L\u0017/^5cCN,'B\u0001(6\u0003\u001d)\bo\u001a:bI\u0016L!\u0001U&\u0003\u001b\t+gm\u001c:f+B<'/\u00193f!\t1%+\u0003\u0002Tk\t\u0011B+Z:u\u0003V$\b.\u001a8uS\u000e\fG/[8o!\t)\u0006,D\u0001W\u0015\t9V'\u0001\u0002eE&\u0011\u0011L\u0016\u0002\u0011\u0019&\fX/\u001b2bg\u0016\u001cV\u000f\u001d9peR\u0004\"a\u00171\u000e\u0003qS!!\u00180\u0002\u000bU$\u0018\u000e\\:\u000b\u0005}+\u0014AB1di>\u00148/\u0003\u0002b9\n\u00112kY1mCN\u0003(/\u001b8h'V\u0004\bo\u001c:u!\t\u0019'.D\u0001e\u0015\t)g-A\u0004d_:$X\r\u001f;\u000b\u0005\u001dD\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003%\f1a\u001c:h\u0013\tYGMA\fBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018i^1sK\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\"A\\9\u000e\u0003=T!\u0001]\u001b\u0002\u000fM,'O^5dK&\u0011!o\u001c\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0004gFd'BA=6\u0003)\u0011X\r]8tSR|'/_\u0005\u0003wZ\u0014\u0011cU9m)\u0016\fWNU3q_NLGo\u001c:z\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003}~l\u0011\u0001_\u0005\u0004\u0003\u0003A(!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016\u00042A\\A\u0004\u0013\r\tIa\u001c\u0002\u0015%\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014Y\f1\u0002]3sg&\u001cH/\u001a8dK&!\u0011qCA\t\u0005U!U\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\fqcY8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0007y\fi\"C\u0002\u0002 a\u0014qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002/\r\fG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\bc\u0001@\u0002&%\u0019\u0011q\u0005=\u0003/\r\u000bG.\u001a8eCJ,e\u000e\u001e:z%\u0016\u0004xn]5u_JL\u0018\u0001E1sG\"Lg/\u001b8h'\u0016\u0014h/[2f!\rq\u0017QF\u0005\u0004\u0003_y'\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0003E!(/[4hKJ\u0014V\r]8tSR|'/\u001f\t\u0004}\u0006U\u0012bAA\u001cq\n\tBK]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016\u0004B!a\u0004\u0002>%!\u0011qHA\t\u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,\u0007\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005G>\u0014XMC\u0002\u0002N\u0019\fAA\u001b3cG&!\u0011\u0011KA$\u00051QEMY2UK6\u0004H.\u0019;fQ\u001dY\u0011QKA5\u0003W\u0002B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0006b]:|G/\u0019;j_:TA!a\u0018\u0002b\u00059a-Y2u_JL(bAA2M\u0006)!-Z1og&!\u0011qMA-\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-\t\u0002\u0002n\u0005I\u0002\u0010\u001c:SKB|7/\u001b;pefTEMY2UK6\u0004H.\u0019;f\u0003U\u0011X\r]8si&twM\u00133cGR+W\u000e\u001d7bi\u0016Ds\u0001DA+\u0003S\n\u0019(\t\u0002\u0002p\u00051A(\u001b8jiz\"\"$!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003'\u0003\"A\u0012\u0001\t\u000b1l\u0001\u0019A7\t\u000bMl\u0001\u0019\u0001;\t\u000bql\u0001\u0019A?\t\u000f\u0005\rQ\u00021\u0001\u0002\u0006!9\u00111B\u0007A\u0002\u00055\u0001bBA\r\u001b\u0001\u0007\u00111\u0004\u0005\b\u0003Ci\u0001\u0019AA\u0012\u0011\u001d\tI#\u0004a\u0001\u0003WAq!!\r\u000e\u0001\u0004\t\u0019\u0004C\u0004\u0002:5\u0001\r!a\u000f\t\u000f\u0005\u0005S\u00021\u0001\u0002D!B\u0011qRA+\u0003S\nY\u0007C\u0004\u0002p5\u0001\r!a\u0011)\u0011\u0005M\u0015QKA5\u0003gB3!DAM!\u0011\t9&a'\n\t\u0005u\u0015\u0011\f\u0002\n\u0003V$xn^5sK\u0012\f\u0001\u0003\u001f7SK2,\u0017m]3WKJ\u001c\u0018n\u001c8\u0015\u0005\u0005\r\u0006\u0003BAS\u0003kk!!a*\u000b\u00079\u000bIK\u0003\u0003\u0002,\u00065\u0016aA1qS*!\u0011qVAY\u0003\u0019\u0019XM\u001d<fe*\u0019\u00111W\u001c\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a.\u0002(\n9a+\u001a:tS>tGCAA^!\u0011\ti,a1\u000e\u0005\u0005}&BAAa\u0003\u0015\u00198-\u00197b\u0013\u0011\t)-a0\u0003\tUs\u0017\u000e^\u0001\u0019e\u0016\u0004xn]5u_JLh+\u001a:tS>t7+\u001a:wS\u000e,WCAAf!\u0011\ti-!6\u000e\u0005\u0005='b\u0001(\u0002R*\u0019\u00111[\u001c\u0002\u0015ad\u0007\u000f\\1uM>\u0014X.\u0003\u0003\u0002X\u0006='\u0001\u0007*fa>\u001c\u0018\u000e^8ssZ+'o]5p]N+'O^5dK\u0006IAm\\+qOJ\fG-Z\u0001\u0017o&\u0004XmT;u\u0003J\u001c\u0007.\u001b<f\t\u0006$\u0018MY1tKV\u0011\u00111X\u0001\u0010o&\u0004XmT;u\t\u0006$\u0018MY1tK\u0006\u0011\u0012n\u001d#c\u00072,\u0017M\\;q\u000b:\f'\r\\3e+\t\t)\u000f\u0005\u0003\u0002>\u0006\u001d\u0018\u0002BAu\u0003\u007f\u0013qAQ8pY\u0016\fg.\u0001\u0010jg&sG/Z4sCRLwN\u001c+fgR\u0004&o\u001c4jY\u0016\f5\r^5wK\u0006QA-\u0019;b'>,(oY3\u0016\u0005\u0005E\b\u0003BAz\u0003wl!!!>\u000b\u0007]\f9P\u0003\u0002\u0002z\u0006)!.\u0019<bq&!\u0011Q`A{\u0005)!\u0015\r^1T_V\u00148-Z\u0001\u0003\u001d2+\"Aa\u0001\u0011\u0007y\u0012)!C\u0002\u0003\b}\u0012aa\u0015;sS:<\u0017a\u0001(MA\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\u0011yAa\u0005\u0015\t\u0005\u0015(\u0011\u0003\u0005\b\u0003\u0003J\u00029AA\"\u0011\u001d\u0011)\"\u0007a\u0001\u0005/\t\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\te!q\u0005\b\u0005\u00057\u0011\u0019\u0003\u0005\u0003\u0003\u001e\u0005}VB\u0001B\u0010\u0015\r\u0011\tcO\u0001\u0007yI|w\u000e\u001e \n\t\t\u0015\u0012qX\u0001\u0007!J,G-\u001a4\n\t\t\u001d!\u0011\u0006\u0006\u0005\u0005K\ty,\u0001\neK2,G/\u001a+bE2,7i\u001c8uK:$H\u0003\u0002B\u0018\u0005g!B!a/\u00032!9\u0011\u0011\t\u000eA\u0004\u0005\r\u0003b\u0002B\u000b5\u0001\u0007!qC\u0001\bG2,\u0017M\\;q\u0003\u0019!W\r\\3uKR!\u0011Q\u001dB\u001e\u0011\u001d\u0011i\u0004\ba\u0001\u0005/\t!!\u001b3\u0002\u001b\u0011,G.\u001a;f%\u0016dW-Y:f)\u0011\tYLa\u0011\t\u000f\tuR\u00041\u0001\u0003\u0018Q!\u0011Q\u001dB$\u0011\u001d\u0011IE\ba\u0001\u0005\u0017\nA\u0001^3b[B!!Q\nB*\u001b\t\u0011yEC\u0002\u0003RU\na\u0001Z8nC&t\u0017\u0002\u0002B+\u0005\u001f\u0012A\u0001V3b[\u0006\tB-\u001a7fi\u00164%o\\7Be\u000eD\u0017N^3\u0015\t\tm#\u0011\r\t\u0005\u0003{\u0013i&\u0003\u0003\u0003`\u0005}&aA%oi\"9!1M\u0010A\u0002\t]\u0011!\u0003:fY\u0016\f7/Z%e\u0003U1XM]5gsJ+\u0007o\\:ji>\u0014\u0018p\u00117fC:\fAbY8v]R4u\u000e\u001c3feN$\"Aa\u0017\u00025Q,7\u000f\u001e#jI:{Go\u00117fC:\fe\r^3s\u0013R\u001cX\r\u001c4\u0015\u0011\t=$Q\u000fB=\u0005+\u00032A\u0012B9\u0013\r\u0011\u0019(\u000e\u0002\u0015)\u0016\u001cHo\u00117fC:,\b/\u0012=dKB$\u0018n\u001c8\t\u000f\t]$\u00051\u0001\u0003\u0018\u0005AA/Z:u\u001d\u0006lW\rC\u0004\u0003|\t\u0002\rA! \u0002\r\u0005\u001cG/\u001b<f!\u0019\u0011yH!#\u0003\u0010:!!\u0011\u0011BC\u001d\u0011\u0011iBa!\n\u0005\u0005\u0005\u0017\u0002\u0002BD\u0003\u007f\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\f\n5%aA*fc*!!qQA`!!\tiL!%\u0003\u0018\t]\u0011\u0002\u0002BJ\u0003\u007f\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002BLE\u0001\u0007!QP\u0001\tCJ\u001c\u0007.\u001b<fI\u0006i1m\\;oiJ+G.Z1tKN\fQbY8v]R$&/[4hKJ\u001c\u0018aG4fiJ+W.Y5oS:<GK]5hO\u0016\u00148\u000fR3uC&d7\u000f\u0006\u0002\u0003\"B1!q\u0010BE\u0005/\t\u0011dZ3u%\u0016l\u0017-\u001b8j]\u001e4u\u000e\u001c3fe\u0012+G/Y5mgR\u0011!QP\u0001\u001cO\u0016$(+Z7bS:Lgn\u001a*fY\u0016\f7/Z:EKR\f\u0017\u000e\\:\u0002G\u001d,GOU3nC&t\u0017N\\4Be\u000eD\u0017N^3e%\u0016dW-Y:fg\u0012+G/Y5mg\u0006)2m\\;oi\u0006\u00138\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\u0018!C2mK\u0006t\u0007\f\u001c#cQ\rQ#\u0011\u0017\t\u0005\u0005g\u00139,\u0004\u0002\u00036*!\u00111LA|\u0013\u0011\u0011IL!.\u0003\u0015A\u0013X\rR3tiJ|\u00170\u0001\nbaBd\u0017nY1uS>t7i\u001c8uKb$XC\u0001B`!\r\u0019'\u0011Y\u0005\u0004\u0005\u0007$'AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fa#\u00199qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi~#S-\u001d\u000b\u0005\u0003w\u0013I\rC\u0005\u0003L2\n\t\u00111\u0001\u0003@\u0006\u0019\u0001\u0010J\u0019\u0002'\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010\u001e\u0011)\u00075\u0012\t\u000e\u0005\u0003\u0003T\n]WB\u0001Bk\u0015\u0011\t\u0019'a0\n\t\te'Q\u001b\u0002\r\u0005\u0016\fg\u000e\u0015:pa\u0016\u0014H/_\u0001\u0016O\u0016$\u0018\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u)\t\u0011y,A\u000btKR\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0015\t\u0005m&1\u001d\u0005\n\u0005\u0017|\u0013\u0011!a\u0001\u0005\u007fCs\u0001\u0001Bt\u0003S\u0012\t\u0010\u0005\u0003\u0003j\n5XB\u0001Bv\u0015\r\tY\u0006Z\u0005\u0005\u0005_\u0014YOA\u0004Qe>4\u0017\u000e\\3-\u0005\tM\u0018E\u0001B{\u0003=Ig\u000e^3he\u0006$\u0018n\u001c8UKN$\bf\u0001\u0001\u0003zB!!1`B\u0001\u001b\t\u0011iPC\u0002\u0003\u0000\u001a\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019\u0019A!@\u0003\u0013\r{W\u000e]8oK:$\u0018\u0001E*rYN#xN]1hK\u001a\u000b7-\u00193f!\t1\u0015gE\u00022\u0007\u0017\u0001B!!0\u0004\u000e%!1qBA`\u0005\u0019\te.\u001f*fMR\u00111q\u0001\u000b\u0005\u0007+\u0019I\u0002\u0006\u0003\u0003\\\r]\u0001bBA!g\u0001\u0007\u00111\t\u0005\b\u0005G\u001a\u0004\u0019\u0001B\f\u0001")
public class SqlStorageFacade
implements StorageFacade,
BeforeUpgrade,
TestAuthentication,
LiquibaseSupport,
ScalaSpringSupport,
ApplicationContextAware {
    private DataSource dataSource;
    private final FolderService folderService;
    private final SqlTeamRepository teamRepository;
    private final ReleaseRepository releaseRepository;
    private final DependencyPersistence dependencyPersistence;
    private final ConfigurationRepository configurationRepository;
    private final CalendarEntryRepository calendarEntryRepository;
    private final ArchivingService archivingService;
    private final TriggerRepository triggerRepository;
    private final TaskPersistence taskPersistence;
    @Qualifier(value="xlrRepositoryJdbcTemplate")
    private final JdbcTemplate jdbcTemplate;
    @Qualifier(value="reportingJdbcTemplate")
    private final JdbcTemplate reportingJdbcTemplate;
    private final String NL;
    private ApplicationContext applicationContext;
    private volatile boolean bitmap$0;

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
        return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
    }

    public <T> T withAuthentication(Authentication auth, Function0<T> t) {
        return (T)TestAuthentication.withAuthentication$((TestAuthentication)this, (Authentication)auth, t);
    }

    @Override
    public Logger logger() {
        return StorageFacade.super.logger();
    }

    public Version xlReleaseVersion() {
        return Version.valueOf((String)"xl-release", (String)"0.0.0");
    }

    public void upgrade() {
        this.doUpgrade();
    }

    public RepositoryVersionService repositoryVersionService() {
        return null;
    }

    public void doUpgrade() {
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    private void wipeOutArchiveDatabase() {
        DataSource reportingDataSource = (DataSource)this.springBean("reportingDataSource", ClassTag$.MODULE$.apply(DataSource.class));
        LiquibaseSupport reporting = new LiquibaseSupport(null, reportingDataSource){
            private final DataSource reportingDataSource$1;

            public <T> T doWithLiquibase(String changelogFile, Function1<Liquibase, T> callback) {
                return (T)LiquibaseSupport.doWithLiquibase$((LiquibaseSupport)this, (String)changelogFile, callback);
            }

            public DataSource dataSource() {
                return this.reportingDataSource$1;
            }
            {
                this.reportingDataSource$1 = reportingDataSource$1;
                LiquibaseSupport.$init$((LiquibaseSupport)this);
            }
        };
        reporting.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
            SqlStorageFacade.$anonfun$wipeOutArchiveDatabase$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void wipeOutDatabase() {
        block0: {
            if (!this.isDbCleanupEnabled() || !this.isIntegrationTestProfileActive()) break block0;
            this.doWithLiquibase("liquibase.xlr.drop.xml", (Function1 & Serializable & scala.Serializable)liquibase -> {
                SqlStorageFacade.$anonfun$wipeOutDatabase$1(this, liquibase);
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean isDbCleanupEnabled() {
        return !System.getProperties().contains("nodbcleanup");
    }

    private boolean isIntegrationTestProfileActive() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.applicationContext().getEnvironment().getActiveProfiles())).contains((Object)"integrationTest");
    }

    private DataSource dataSource$lzycompute() {
        SqlStorageFacade sqlStorageFacade = this;
        synchronized (sqlStorageFacade) {
            if (!this.bitmap$0) {
                this.dataSource = (DataSource)this.springBean("xlrRepositoryDataSource", ClassTag$.MODULE$.Nothing());
                this.bitmap$0 = true;
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        return !this.bitmap$0 ? this.dataSource$lzycompute() : this.dataSource;
    }

    private String NL() {
        return this.NL;
    }

    public boolean tableExists(String tableName, JdbcTemplate jdbcTemplate) {
        boolean bl;
        try {
            jdbcTemplate.queryForObject(new StringBuilder(21).append("SELECT count(*) FROM ").append(tableName).toString(), Long.TYPE);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void deleteTableContent(String tableName, JdbcTemplate jdbcTemplate) {
        block0: {
            if (!this.tableExists(tableName, jdbcTemplate)) break block0;
            this.logger().info(new StringBuilder(9).append("DELETING ").append(tableName).toString());
            jdbcTemplate.execute(new StringBuilder(12).append("DELETE FROM ").append(tableName).toString());
        }
    }

    @Override
    public void cleanup() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent(Schema.DEPENDENCIES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PERMISSIONS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_PRINCIPALS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLE_ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(SecuritySchema.ROLES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASE_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.COMMENTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TASKS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_ACTIVITY_LOGS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES_EXT$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISK_ASSESSMENTS", sqlJdbcTemplate);
        this.deleteTableContent("XLR_RISKS", sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGER_CONFIGURATION_REFS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.TRIGGERS$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.RELEASES$.MODULE$.TABLE(), sqlJdbcTemplate);
        this.deleteTableContent(Schema.ARTIFACTS$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.PATHS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(31).append("DELETE FROM ").append(Schema.PATHS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.PATHS$.MODULE$.ANCESTOR_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).append(" OR ").append(Schema.PATHS$.MODULE$.DESCENDANT_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        if (this.tableExists(Schema.FOLDERS$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(15).append("UPDATE ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" SET ").append(Schema.FOLDERS$.MODULE$.SECURITY_UID()).append(" = ").append(FolderRow.Root$.MODULE$.uid()).toString());
            this.jdbcTemplate.execute(new StringBuilder(23).append("DELETE FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).append(" WHERE ").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(" <> ").append(FolderRow.Root$.MODULE$.uid()).toString());
        }
        this.deleteTableContent(MetadataSchema.METADATA$.MODULE$.TABLE(), sqlJdbcTemplate);
        if (this.tableExists(Schema.USER_PROFILE$.MODULE$.TABLE(), sqlJdbcTemplate)) {
            this.jdbcTemplate.execute(new StringBuilder(30).append("DELETE FROM ").append(Schema.USER_PROFILE$.MODULE$.TABLE()).append(" WHERE ").append(Schema.USER_PROFILE$.MODULE$.USERNAME()).append(" <> 'admin'").toString());
        }
        JdbcTemplate sqlJdbcTemplate2 = this.reportingJdbcTemplate;
        this.deleteTableContent(Schema.Archive$.ITSM_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.DEPLOYMENT_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(Schema.Archive$.CODE_COMPLIANCE_TASK_REPORTING_RECORD$.MODULE$.TABLE(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_TASKS_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_PHASES_TABLE_NAME(), sqlJdbcTemplate2);
        this.deleteTableContent(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME(), sqlJdbcTemplate2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean delete(String id) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.logger().trace(new StringBuilder(12).append("Deleting id ").append(id).toString());
            if (Ids.isReleaseId((String)id)) {
                this.deleteRelease(id);
            } else if (Ids.isDependencyId((String)id)) {
                $this.dependencyPersistence.deleteDependency(id, (Integer)$this.taskPersistence.taskUidById(Ids.getParentId((String)id)).get());
            } else if (!Ids.isPlanItemId((String)id)) {
                if (Ids.isFolderId((String)id)) {
                    if ($this.folderService.exists(id)) {
                        $this.folderService.delete(id);
                    }
                } else if (Ids.isCustomConfigurationId((String)id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isCalendarId((String)id)) {
                    $this.calendarEntryRepository.delete(id);
                } else if (Ids.isConfigurationId((String)id) && $this.configurationRepository.exists(id)) {
                    $this.configurationRepository.delete(id);
                } else if (Ids.isTeamId((String)id)) {
                    $this.teamRepository.delete(id);
                } else if (Ids.isVariableId((String)id)) {
                    this.logger().warn(new StringBuilder(63).append("Variable '").append(id).append("' will be deleted once the parent release is deleted.").toString());
                } else if (!id.endsWith("PythonScript") && !id.endsWith("/valueProvider")) {
                    if (Ids.isTriggerId((String)id)) {
                        $this.triggerRepository.delete(id);
                    } else if (Ids.isInRelease((String)id)) {
                        this.logger().warn(new StringBuilder(69).append("Id '").append(id).append("' will be deleted once the parent release or template is deleted.").toString());
                    } else {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Delete of CI with id `%s` is not supported")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})));
                    }
                }
            }
            return true;
        });
        if (try_ instanceof Success) {
            this.logger().warn(new StringBuilder(8).append("Deleted ").append(id).toString());
            return true;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                this.logger().error(new StringBuilder(51).append("Unable to delete CI with Id: `").append(id).append("` as it was not found").toString());
                return true;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringBuilder(31).append("Unable to delete CI with Id: `").append(id).append("`").toString(), e);
        return false;
    }

    public void deleteRelease(String id) {
        block5: {
            this.logger().info("Deleting release {}", new Object[]{id});
            boolean found = false;
            if (this.releaseRepository.exists(id)) {
                this.logger().info("Release {} found in repository", new Object[]{id});
                try {
                    this.teamRepository.deleteTeamsFromPlatform(id);
                }
                catch (NotFoundException e) {
                    this.logger().warn(new StringBuilder(26).append("Could not delete teams of ").append(id).toString(), (Throwable)e);
                }
                this.releaseRepository.delete(id);
                found = true;
            }
            if (this.archivingService.exists(id)) {
                this.logger().info("Release {} found in archive", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (this.archivingService.existsPreArchived(id)) {
                this.logger().info("Release {} found as pre-archived", new Object[]{id});
                this.deleteFromArchive(id);
                found = true;
            }
            if (found) break block5;
            this.logger().error("Release {} not found neither in repository nor in archive (including pre-archived releases)", new Object[]{id});
        }
    }

    @Override
    public boolean delete(Team team) {
        boolean bl;
        this.logger().trace(new StringBuilder(14).append("Deleting team ").append(team.getId()).toString());
        if (!Ids.isInRelease((String)team.getId()) || this.releaseRepository.exists(Ids.releaseIdFrom((String)team.getId()))) {
            this.teamRepository.delete(team.getId());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int deleteFromArchive(String releaseId) {
        return SqlStorageFacade$.MODULE$.deleteFromArchive(releaseId, this.reportingJdbcTemplate);
    }

    @Override
    public void verifyRepositoryClean() {
        String testName;
        String string = testName = MDC.get((String)"testName") != null ? new StringBuilder(2).append(MDC.get((String)"testName")).append(": ").toString() : "";
        if (this.countReleases() > 0 || this.countArchivedReleases() > 0) {
            throw this.testDidNotCleanAfterItself(testName, this.getRemainingReleasesDetails(), this.getRemainingArchivedReleasesDetails());
        }
        int triggerCount = this.countTriggers();
        if (triggerCount > 0) {
            throw new TestCleanupException(new StringBuilder(38).append(testName).append("Found ").append(triggerCount).append(" remaining triggers in database:").append(this.NL()).append(this.getRemainingTriggersDetails().mkString(this.NL())).toString());
        }
        if (this.countFolders() > 1) {
            Seq folders = (Seq)this.getRemainingFolderDetails().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String id = (String)A1._1();
                        String path = (String)A1._2();
                        object = new StringBuilder(4).append(id).append(" -> ").append(path).toString();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String> x1) {
                    Tuple2<String, String> tuple2 = x1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new TestCleanupException(new StringBuilder(28).append(testName).append("There are leftover folders: ").append(folders).toString());
        }
    }

    private int countFolders() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.FOLDERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$1) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private TestCleanupException testDidNotCleanAfterItself(String testName, Seq<Tuple2<String, String>> active, Seq<Tuple2<String, String>> archived) {
        int numActive = active.size();
        int numArchived = archived.size();
        int numTotal = numActive + numArchived;
        return new TestCleanupException(new StringBuilder(62).append(testName).append("Found ").append(numTotal).append(" remaining releases (").append(numActive).append(" from database and ").append(numArchived).append(" from archive):\n").append(SqlStorageFacade.all$1(active, archived)).toString());
    }

    private int countReleases() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.RELEASES$.MODULE$.CI_UID()).append(") FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$2) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private int countTriggers() {
        return BoxesRunTime.unboxToInt((Object)this.jdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(Schema.TRIGGERS$.MODULE$.CI_UID()).append(") FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$3) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    private Seq<String> getRemainingTriggersDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE()).append(", ").append(Schema.TRIGGERS$.MODULE$.ID()).append(" FROM ").append(Schema.TRIGGERS$.MODULE$.TABLE()).toString(), (rs, x$4) -> new StringBuilder(19).append("Trigger: ").append(rs.getString(1)).append(" with id: ").append(rs.getString(2)).toString())).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingFolderDetails() {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.FOLDERS$.MODULE$.FOLDER_ID()).append(", ").append(Schema.FOLDERS$.MODULE$.FOLDER_PATH()).append(" FROM ").append(Schema.FOLDERS$.MODULE$.TABLE()).toString(), (rs, x$5) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala()).toSeq();
    }

    private Seq<Tuple2<String, String>> getRemainingReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(Schema.RELEASES$.MODULE$.RELEASE_ID()).append(", ").append(Schema.RELEASES$.MODULE$.RELEASE_TITLE()).append(" FROM ").append(Schema.RELEASES$.MODULE$.TABLE()).toString(), (rs, x$6) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private Seq<Tuple2<String, String>> getRemainingArchivedReleasesDetails() {
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.reportingJdbcTemplate.query(new StringBuilder(15).append("SELECT ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(", ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TITLE_COLUMN()).append(" FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$7) -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rs.getString(1)), (Object)rs.getString(2)))).asScala();
    }

    private int countArchivedReleases() {
        return BoxesRunTime.unboxToInt((Object)this.reportingJdbcTemplate.queryForObject(new StringBuilder(20).append("SELECT COUNT(").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_ID_COLUMN()).append(") FROM ").append(ArchivedReleases$.MODULE$.REPORT_RELEASES_TABLE_NAME()).toString(), (rs, x$8) -> BoxesRunTime.boxToInteger((int)rs.getInt(1))));
    }

    @PreDestroy
    public void cleanXlDb() {
        JdbcTemplate sqlJdbcTemplate = this.jdbcTemplate;
        this.deleteTableContent("XL_VERSION", sqlJdbcTemplate);
        this.wipeOutDatabase();
        this.wipeOutArchiveDatabase();
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext();
    }

    public void setApplicationContext(ApplicationContext x$1) {
        this.applicationContext_$eq(x$1);
    }

    public static final /* synthetic */ void $anonfun$wipeOutArchiveDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out reporting database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$wipeOutDatabase$1(SqlStorageFacade $this, Liquibase liquibase) {
        try {
            $this.logger().info("Wipe-out repository database tables");
            liquibase.dropAll();
        }
        catch (Exception e) {
            $this.logger().warn("Unable to wipe-out database", (Throwable)e);
        }
    }

    private static final String showEntry$1(String tag, Tuple2 entry) {
        Tuple2 tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        String title = (String)tuple2._2();
        String string = new StringBuilder(9).append(id).append(" -> '").append(title).append("' (").append(tag).append(")").toString();
        return string;
    }

    private static final String all$1(Seq active$1, Seq archived$1) {
        return ((TraversableOnce)((TraversableLike)active$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("active", entry), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)archived$1.map((Function1 & Serializable & scala.Serializable)entry -> SqlStorageFacade.showEntry$1("archive", entry), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString("", "\n * ", "\n");
    }

    @Autowired
    public SqlStorageFacade(FolderService folderService, SqlTeamRepository teamRepository, ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, DependencyPersistence dependencyPersistence, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, ArchivingService archivingService, TriggerRepository triggerRepository, TaskPersistence taskPersistence, @Qualifier(value="xlrRepositoryJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate) {
        this.folderService = folderService;
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.dependencyPersistence = dependencyPersistence;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.archivingService = archivingService;
        this.triggerRepository = triggerRepository;
        this.taskPersistence = taskPersistence;
        this.jdbcTemplate = jdbcTemplate;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        BeforeUpgrade.$init$((BeforeUpgrade)this);
        TestAuthentication.$init$((TestAuthentication)this);
        LiquibaseSupport.$init$((LiquibaseSupport)this);
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        this.NL = System.lineSeparator();
    }
}

