/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.ConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.ConfigurationItemsReaderWriter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.xlrelease.XLReleaseIntegrationTest;
import com.xebialabs.xlrelease.api.v1.NonEncryptingPasswordItemReaderWriter;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.rules.LoginRule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.junit.Before;
import org.junit.Rule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.restdocs.JUnitRestDocumentation;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.operation.preprocess.Preprocessors;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.payload.RequestFieldsSnippet;
import org.springframework.restdocs.payload.ResponseFieldsSnippet;
import org.springframework.restdocs.request.ParameterDescriptor;
import org.springframework.restdocs.request.RequestDocumentation;
import org.springframework.restdocs.request.RequestParametersSnippet;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public abstract class BaseApiDocumentationTest
extends XLReleaseIntegrationTest {
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Autowired
    private ObjectMapper jacksonObjectMapper;
    @Autowired
    private ConfigurationItemReaderWriter configurationItemReaderWriter;
    @Autowired
    private NonEncryptingPasswordItemReaderWriter nonEncryptingPasswordItemReaderWriter;
    @Autowired
    private ConfigurationItemsReaderWriter configurationItemsReaderWriter;
    @Rule
    public JUnitRestDocumentation restDocumentation = new JUnitRestDocumentation("build/generated-snippets");
    @Rule
    public LoginRule loginRule = LoginRule.loginWithRoleAdmin((String)"admin");
    protected MockMvc mockMvc;
    protected RestDocumentationResultHandler documentationHandler;
    ResponseFieldsSnippet releaseFullSearch = PayloadDocumentation.responseFields((FieldDescriptor[])new FieldDescriptor[0]).andWithPrefix("live.", this.releaseSearch("active")).andWithPrefix("live.releases[].", this.releaseFields()).andWithPrefix("archived.", this.releaseSearch("archive")).andWithPrefix("archived.releases[].", this.releaseFields());
    private String globalSuffix = "from both active and archive databases";
    private String currentSuffix = "from the active database";
    private String archivedSuffix = "from the archive database";
    ResponseFieldsSnippet releaseCountResults = PayloadDocumentation.relaxedResponseFields((FieldDescriptor[])new FieldDescriptor[0]).andWithPrefix("all.", this.releaseCount(this.globalSuffix)).andWithPrefix("all.byStatus.", this.releaseCountByStatus(this.globalSuffix)).andWithPrefix("live.", this.releaseCount(this.currentSuffix)).andWithPrefix("live.byStatus.", this.releaseCountByStatus(this.currentSuffix)).andWithPrefix("archived.", this.releaseCount(this.archivedSuffix)).andWithPrefix("archived.byStatus.", this.releaseCountByStatus(this.archivedSuffix));

    @Before
    public void setUp() {
        this.documentationHandler = MockMvcRestDocumentation.document((String)"{class-name}/{method-name}", (OperationRequestPreprocessor)Preprocessors.preprocessRequest((OperationPreprocessor[])new OperationPreprocessor[]{Preprocessors.prettyPrint()}), (OperationResponsePreprocessor)Preprocessors.preprocessResponse((OperationPreprocessor[])new OperationPreprocessor[]{Preprocessors.prettyPrint()}), (Snippet[])new Snippet[0]);
        this.mockMvc = ((DefaultMockMvcBuilder)((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).apply((MockMvcConfigurer)MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)this.restDocumentation).uris().withScheme("http").withHost("localhost").withPort(5516))).alwaysDo((ResultHandler)this.documentationHandler)).build();
        RequestLocal.initMap();
    }

    protected RequestParametersSnippet paginatedRequestParametersSnippet() {
        return RequestDocumentation.requestParameters((ParameterDescriptor[])new ParameterDescriptor[]{((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"page").description((Object)"The page to fetch, zero-based; default value is 0")).optional(), ((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"resultsPerPage").description((Object)"Number of results per page, default value is 100")).optional(), ((ParameterDescriptor)RequestDocumentation.parameterWithName((String)"depth").description((Object)"The depth of object tree, zero-based; default value is 1. Items fetched with depth 0 contain only basic properties like 'id' and 'type'. Items fetched with depth 1 contain simple properties (). Collections and references to other items are fetched only for basic properties.")).optional()});
    }

    protected RequestFieldsSnippet ciRequestFieldsSnippet(Type ciType) {
        return PayloadDocumentation.relaxedRequestFields(this.ciFields(ciType)).and(this.ignoredFields());
    }

    protected ResponseFieldsSnippet ciResponseFieldsSnippet(Type ciType) {
        return this.ciResponseFieldsSnippet(ciType, "");
    }

    protected ResponseFieldsSnippet ciResponseFieldsSnippet(Type ciType, String prefix) {
        return PayloadDocumentation.relaxedResponseFields((FieldDescriptor[])new FieldDescriptor[0]).andWithPrefix(prefix, this.ciFields(ciType)).andWithPrefix(prefix, this.ignoredFields());
    }

    protected RequestFieldsSnippet variableRequestSnippet() {
        return PayloadDocumentation.relaxedRequestFields((FieldDescriptor[])new FieldDescriptor[]{(FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"key").description((Object)"The unique name of the variable in the way it is used in template or release, without curly braces"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"value").description((Object)"Value of the release variable or default value of the template variable"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"requiresValue").description((Object)"Shows if an empty value is a valid value for this variable"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"showOnReleaseStart").description((Object)"Shows if this variable will be shown on create release page")});
    }

    protected RequestFieldsSnippet releaseFiltersSnippet() {
        return PayloadDocumentation.relaxedRequestFields((FieldDescriptor[])new FieldDescriptor[]{(FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"title").type((Object)"String").description((Object)"Case-insensitive matches the part of the release title"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"tags").type((Object)"String").description((Object)"Matches the releases containing all of the specified tags"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"timeFrame").type((Object)"String").description((Object)"The time-frame to search releases in. Valid values: LAST_MONTH, LAST_THREE_MONTHS, LAST_SIX_MONTHS, LAST_YEAR. Specify RANGE to filter by a custom from-to date range"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"from").type((Object)"Long").description((Object)"Matches the releases with end date after or equal to this date"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"to").type((Object)"Long").description((Object)"Matches the releases with start date before this date"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"active").description((Object)"Matches the releases with the IN_PROGRESS, FAILED, FAILING or PAUSED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"planned").description((Object)"Matches the releases with the PLANNED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"inProgress").description((Object)"Matches the releases with the IN_PROGRESS status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"paused").description((Object)"Matches the releases with the PAUSED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"failing").description((Object)"Matches the releases with the FAILING status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"failed").description((Object)"Matches the releases with the FAILED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"inactive").description((Object)"Matches the releases with the COMPLETED or ABORTED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"completed").description((Object)"Matches the releases with the COMPLETED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"aborted").description((Object)"Matches the releases with the ABORTED status"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"onlyMine").description((Object)"Matches the releases with me as the owner"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"onlyFlagged").description((Object)"Matches the releases which need attention or are at risk"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"onlyArchived").description((Object)"Matches the releases which have been archived"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"parentId").type((Object)"String").description((Object)"Matches the releases stored under this folder"), ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"orderBy").type((Object)"String").description((Object)"The order of the returning set: risk, start_date, end_date, title (only available for templates)")).optional()});
    }

    protected RequestFieldsSnippet scmDataParameters() {
        return PayloadDocumentation.relaxedRequestFields((FieldDescriptor[])new FieldDescriptor[]{(FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"kind").description((Object)"Kind of scm used"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"commit").description((Object)"Commit id of the scm data"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"author").description((Object)"Author of the commit"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"date").description((Object)"Date of the commit"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"message").description((Object)"Message attached to the commit"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"remote").description((Object)"Remove URL of the commit"), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"fileName").description((Object)"Filename of the SCM applied")});
    }

    protected String toJson(ConfigurationItem ci) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.configurationItemReaderWriter.writeTo(ci, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJsonWithPlainTextPassword(ConfigurationItem ci) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.nonEncryptingPasswordItemReaderWriter.writeTo(ci, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJson(List<ConfigurationItem> cis) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.configurationItemsReaderWriter.writeTo(cis, null, null, null, MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    protected String toJson(Object ci) throws Exception {
        return this.jacksonObjectMapper.writeValueAsString(ci);
    }

    String toJsonWithFields(Object ci) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return mapper.writeValueAsString(ci);
    }

    private List<FieldDescriptor> ciFields(Type type) {
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        List typeFieldDescriptors = type.getDescriptor().getPropertyDescriptors().stream().map(pd -> {
            FieldDescriptor fieldDescriptor = ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)pd.getName()).description((Object)pd.getDescription())).type((Object)this.determineJsonType((PropertyDescriptor)pd));
            if (!pd.isRequired()) {
                fieldDescriptor = fieldDescriptor.optional();
            }
            if (pd.isHidden() || "internal".equals(pd.getCategory())) {
                fieldDescriptor = ((FieldDescriptor)fieldDescriptor.ignored()).optional();
            }
            return fieldDescriptor;
        }).collect(Collectors.toList());
        fieldDescriptors.addAll(this.basicCiFields(type));
        fieldDescriptors.addAll(typeFieldDescriptors);
        return fieldDescriptors;
    }

    private List<FieldDescriptor> releaseSearch(String database) {
        return Lists.newArrayList((Object[])new FieldDescriptor[]{((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"page").description((Object)String.format("The page of Release results from the %s database", database))).type((Object)JsonFieldType.NUMBER), ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"size").description((Object)String.format("The number of results in this page from the %s database", database))).type((Object)JsonFieldType.NUMBER), ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"releases").description((Object)String.format("The list of Releases found from the %s database", database))).type((Object)JsonFieldType.ARRAY)});
    }

    private List<FieldDescriptor> releaseFields() {
        List<FieldDescriptor> releaseFields = this.ciFields(Type.valueOf(Release.class));
        releaseFields.addAll(this.ignoredFields());
        return releaseFields;
    }

    private List<FieldDescriptor> releaseCount(String suffix) {
        return Lists.newArrayList((Object[])new FieldDescriptor[]{((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"total").description((Object)String.format("Number of releases matching the filters, %s", suffix))).type((Object)JsonFieldType.NUMBER), ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"byStatus").description((Object)String.format("Number of releases matching the filters, by ReleaseStatus and %s", suffix))).type((Object)JsonFieldType.OBJECT)});
    }

    private FieldDescriptor countByStatus(ReleaseStatus status, String suffix) {
        return ((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)status.name()).description((Object)String.format("Number of %s releases matching the filters, %s", status.value(), suffix))).type((Object)JsonFieldType.NUMBER).optional();
    }

    private List<FieldDescriptor> releaseCountByStatus(String suffix) {
        return Arrays.stream(ReleaseStatus.values()).filter(s -> !s.equals((Object)ReleaseStatus.TEMPLATE)).map(s -> this.countByStatus((ReleaseStatus)s, suffix)).collect(Collectors.toList());
    }

    private List<FieldDescriptor> basicCiFields(Type type) {
        return Arrays.asList((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"id").description((Object)"This field contains ID of object. It is required but not used on update operations. When creating objects just send 'null'."), (FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"type").description((Object)String.format("This field represents type of '%s'.", type)));
    }

    private List<FieldDescriptor> ignoredFields() {
        return Arrays.asList(((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$token").description((Object)"The CI optimistic locking hash-tag, please remove it from the API!")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$createdAt").description((Object)"The date when this CI was created")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$createdBy").description((Object)"The user that created this CI")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$lastModifiedAt").description((Object)"The date when this CI was last modified")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$lastModifiedBy").description((Object)"The last user that modified this CI")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"$scmTraceabilityDataId").description((Object)"The ID of the SCM Data associated to this CI")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"createdDate").description((Object)"The date when this CI was created")).ignored()).optional(), ((FieldDescriptor)((FieldDescriptor)PayloadDocumentation.fieldWithPath((String)"modifiedDate").description((Object)"The date when this CI was last modified")).ignored()).optional());
    }

    private JsonFieldType determineJsonType(PropertyDescriptor pd) {
        switch (pd.getKind()) {
            case BOOLEAN: {
                return JsonFieldType.BOOLEAN;
            }
            case CI: {
                return JsonFieldType.VARIES;
            }
            case INTEGER: {
                return JsonFieldType.NUMBER;
            }
            case ENUM: {
                return JsonFieldType.STRING;
            }
            case LIST_OF_CI: {
                return JsonFieldType.ARRAY;
            }
            case LIST_OF_STRING: {
                return JsonFieldType.ARRAY;
            }
            case SET_OF_CI: {
                return JsonFieldType.ARRAY;
            }
            case SET_OF_STRING: {
                return JsonFieldType.ARRAY;
            }
            case MAP_STRING_STRING: {
                return JsonFieldType.OBJECT;
            }
        }
        return JsonFieldType.STRING;
    }
}

