/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.SpringSessionConverterFactory;
import com.xebialabs.xlrelease.config.XlrConfig;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SpringSessionConfiguration
extends JdbcHttpSessionConfiguration {
    private ClassLoader classLoader;
    private SpringSessionConverterFactory converterFactory;

    public SpringSessionConfiguration(@Autowired XlrConfig xlrConfig, @Autowired ServerConfiguration serverConfiguration, @Autowired(required=false) SpringSessionConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
        int sessionTimeoutSeconds = serverConfiguration.getClientSessionTimeoutMinutes() * 60;
        int maxInactiveInterval = sessionTimeoutSeconds == 0 ? 2592000 : sessionTimeoutSeconds;
        super.setMaxInactiveIntervalInSeconds(Integer.valueOf(maxInactiveInterval));
        super.setCleanupCron(xlrConfig.server_session_storage_cleanupCron());
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, @Qualifier(value="xlrRepositoryDataSourceProxy") ObjectProvider<DataSource> dataSource) {
        super.setDataSource(springSessionDataSource, dataSource);
    }

    @Autowired
    public void setTransactionManager(@Qualifier(value="xlrRepositoryTransactionManager") PlatformTransactionManager transactionManager) {
        super.setTransactionManager(transactionManager);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.classLoader = classLoader;
    }

    @Bean
    public JdbcIndexedSessionRepository sessionRepository() {
        JdbcIndexedSessionRepository repo = super.sessionRepository();
        GenericConversionService conversionService = this.createConversionServiceWithBeanClassLoader();
        repo.setConversionService((ConversionService)conversionService);
        return repo;
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader() {
        DefaultConversionService conversionService = new DefaultConversionService();
        if (this.converterFactory != null) {
            conversionService.addConverter(this.converterFactory.buildSerializer(this.classLoader));
            conversionService.addConverter(this.converterFactory.buildDeserializer(this.classLoader));
        } else {
            conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
            conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader));
        }
        return conversionService;
    }
}

