/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.ReleaseDependenciesView;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.converters.DependencyViewConverter;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/dependencies")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class DependencyResource {
    private PermissionChecker permissions;
    private DependencyService dependencyService;
    private DependencyViewConverter dependencyViewConverter;
    private ReleaseActorService releaseActorService;
    private TaskGranularPermissions taskPermissionChecker;

    @Autowired
    public DependencyResource(PermissionChecker permissions, DependencyService dependencyService, DependencyViewConverter dependencyViewConverter, ReleaseActorService releaseActorService, TaskGranularPermissions taskPermissionChecker) {
        this.permissions = permissions;
        this.dependencyService = dependencyService;
        this.dependencyViewConverter = dependencyViewConverter;
        this.releaseActorService = releaseActorService;
        this.taskPermissionChecker = taskPermissionChecker;
    }

    public DependencyResource() {
    }

    @PUT
    @Timed
    @Path(value="{dependencyId:.*Dependency[^/-]*}")
    public DependencyView updateDependency(@PathParam(value="dependencyId") @IdParam String dependencyId, DependencyView dependencyView) {
        String releaseId = Ids.releaseIdFrom((String)dependencyId);
        Dependency dependency = this.getDirectivesAndUpdate(releaseId, dependencyId, dependencyView);
        return new DependencyView(dependency);
    }

    private Dependency getDirectivesAndUpdate(String releaseId, String dependencyId, DependencyView dependencyView) {
        Dependency dependency = new Dependency();
        if (this.taskPermissionChecker.hasDirectiveToUpdateAllProperties(releaseId) || this.taskPermissionChecker.hasEditTaskConfigurationGranularPermission(releaseId)) {
            this.checkViewPermissionIfNecessary(dependencyView);
            dependency = this.releaseActorService.updateDependency(releaseId, dependencyId, dependencyView.toTargetIdOrVariable());
        }
        return dependency;
    }

    @DELETE
    @Timed
    @Path(value="{dependencyId:.*Dependency[^/-]*}")
    public void deleteDependency(@PathParam(value="dependencyId") @IdParam String dependencyId) {
        String releaseId = Ids.releaseIdFrom((String)dependencyId);
        this.permissions.checkEditTask(releaseId);
        this.releaseActorService.deleteDependency(releaseId, dependencyId);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}")
    public ReleaseDependenciesView getReleaseDependencies(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="asReleases") boolean asReleases, @QueryParam(value="properties") List<String> properties, @QueryParam(value="extensions") List<String> extensions) {
        this.permissions.checkView(releaseId);
        List<String> activeIncomingGateIds = this.dependencyService.findActiveIncomingGateIds(releaseId);
        List<String> activeOutgoingTargetIds = this.dependencyService.findActiveOutgoingTargetIds(releaseId);
        if (asReleases) {
            activeIncomingGateIds = this.toReleaseIds(activeIncomingGateIds);
            activeOutgoingTargetIds = this.toReleaseIds(activeOutgoingTargetIds);
        }
        List<DependencyNode> incomingDependenciesView = this.dependencyViewConverter.toDependencyNodes(activeIncomingGateIds, properties, extensions);
        List<DependencyNode> outgoingDependenciesView = this.dependencyViewConverter.toDependencyNodes(activeOutgoingTargetIds, properties, extensions);
        return new ReleaseDependenciesView(releaseId, incomingDependenciesView, outgoingDependenciesView);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tree")
    public ReleaseTree getReleaseTree(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        return this.dependencyService.getReleaseTree(releaseId);
    }

    private List<String> toReleaseIds(List<String> targetId) {
        return targetId.stream().map(Ids::releaseIdFrom).distinct().collect(Collectors.toList());
    }

    private void checkViewPermissionIfNecessary(DependencyView dependencyView) {
        if (dependencyView.hasFixedTarget()) {
            this.permissions.checkView(Ids.releaseIdFrom((String)dependencyView.toTargetId()));
        }
    }
}

