/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.annotation.Timed;
import com.typesafe.config.Config;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow$;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.DelayQueue;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u0007\u000f\u0001]A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005Y!)1\u0007\u0001C\u0001i!Aa\t\u0001b\u0001\n\u0003qq\t\u0003\u0004V\u0001\u0001\u0006I\u0001\u0013\u0005\t-\u0002A)\u0019!C\u0005/\")1\r\u0001C!I\")A\u000f\u0001C#k\")A\u0010\u0001C\u0005{\"1q\u0010\u0001C!\u0003\u0003Aq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\u0003\u001f\u0011+g-Y;mi*{'-U;fk\u0016T!a\u0004\t\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\t\u0013\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0014)\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002+\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0007\u0010#!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u001d%\u0011\u0011E\u0004\u0002\t\u0015>\u0014\u0017+^3vKB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006g24GG\u001b\u0006\u0002O\u0005AqM]5{u2,G-\u0003\u0002*I\t9Aj\\4hS:<\u0017!\u00046pEJ+\u0007o\\:ji>\u0014\u00180F\u0001-!\ti\u0003'D\u0001/\u0015\tyc\"\u0001\u0006sKB|7/\u001b;pefL!!\r\u0018\u0003\u001b){'MU3q_NLGo\u001c:z\u00039QwN\u0019*fa>\u001c\u0018\u000e^8ss\u0002\na\u0001P5oSRtDCA\u001b7!\ty\u0002\u0001C\u0003+\u0007\u0001\u0007A\u0006\u000b\u0002\u0004qA\u0011\u0011\bR\u0007\u0002u)\u00111\bP\u0001\u000bC:tw\u000e^1uS>t'BA\u001f?\u0003\u001d1\u0017m\u0019;pefT!a\u0010!\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0005\u0013\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\r\u000b1a\u001c:h\u0013\t)%HA\u0005BkR|w/\u001b:fI\u0006IAn\\2bY*{'m]\u000b\u0002\u0011B\u0019\u0011\n\u0015*\u000e\u0003)S!a\u0013'\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002N\u001d\u0006!Q\u000f^5m\u0015\u0005y\u0015\u0001\u00026bm\u0006L!!\u0015&\u0003\u0015\u0011+G.Y=Rk\u0016,X\r\u0005\u0002 '&\u0011AK\u0004\u0002\u0004\u0015>\u0014\u0017A\u00037pG\u0006d'j\u001c2tA\u00051an\u001c3f\u0013\u0012,\u0012\u0001\u0017\t\u00033\u0002t!A\u00170\u0011\u0005mSR\"\u0001/\u000b\u0005u3\u0012A\u0002\u001fs_>$h(\u0003\u0002`5\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\ty&$\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0003K\"\u0004\"!\u00074\n\u0005\u001dT\"\u0001B+oSRDQ![\u0004A\u0002I\u000b1A[8cQ\t91\u000e\u0005\u0002me6\tQN\u0003\u0002<]*\u0011q\u000e]\u0001\b[\u0016$(/[2t\u0015\t\tH#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\t\u0019XNA\u0003US6,G-A\u0002hKR$\u0012A\u0015\u0015\u0003\u0011]\u0004\"\u0001\u001f>\u000e\u0003eT!a\u000f\u000e\n\u0005mL(a\u0002;bS2\u0014XmY\u0001\u0005Y>\u001c7\u000e\u0006\u0002S}\")\u0011.\u0003a\u0001%\u00061a-\u001b8jg\"$2!ZA\u0002\u0011\u0015I'\u00021\u0001SQ\tQ1.A\tti>\u0004xk\u001c:lKJ$\u0006N]3bIN$2!ZA\u0006\u0011\u001d\tia\u0003a\u0001\u0003\u001f\tQaY8v]R\u00042!GA\t\u0013\r\t\u0019B\u0007\u0002\u0004\u0013:$\u0018\u0001C2b]\u000e,G.\u00134\u0015\u0007\u0015\fI\u0002C\u0004\u0002\u001c1\u0001\r!!\b\u0002\u0013A\u0014X\rZ5dCR,\u0007#BA\u0010\u0003K\u0011VBAA\u0011\u0015\r\t\u0019\u0003T\u0001\tMVt7\r^5p]&!\u0011qEA\u0011\u0005%\u0001&/\u001a3jG\u0006$X\rK\u0002\u0001\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c\u0001\u0015AC:uKJ,w\u000e^=qK&!\u0011QGA\u0018\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class DefaultJobQueue
implements JobQueue,
Logging {
    private String nodeId;
    private final JobRepository jobRepository;
    private final DelayQueue<Job> localJobs;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public DelayQueue<Job> localJobs() {
        return this.localJobs;
    }

    private String nodeId$lzycompute() {
        DefaultJobQueue defaultJobQueue = this;
        synchronized (defaultJobQueue) {
            if (!this.bitmap$0) {
                String string;
                ClusterMode clusterMode = XlrConfig$.MODULE$.getInstance().clusterMode();
                boolean bl = ClusterMode.Full$.MODULE$.equals(clusterMode) ? true : ClusterMode.HotStandby$.MODULE$.equals(clusterMode);
                if (bl) {
                    Config clusterConfig = XlrConfig$.MODULE$.getInstance().cluster().config().getConfig("node");
                    string = new StringBuilder(1).append(clusterConfig.getString("hostname")).append(":").append(clusterConfig.getInt("clusterPort")).toString();
                } else if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                    string = "default";
                } else {
                    throw new MatchError((Object)clusterMode);
                }
                this.nodeId = string;
                this.bitmap$0 = true;
            }
        }
        return this.nodeId;
    }

    private String nodeId() {
        return !this.bitmap$0 ? this.nodeId$lzycompute() : this.nodeId;
    }

    @Override
    @Timed
    public void submit(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("submitted job ").append(job).toString());
        job.id_$eq(this.jobRepository().create(JobRow$.MODULE$.apply(job)).id());
        this.localJobs().add(job);
    }

    @Override
    public final Job get() {
        Job job;
        block3: {
            Try try_;
            block4: {
                while (true) {
                    Job job2;
                    if ((job2 = (Job)this.localJobs().take()) instanceof StopWorkerThread) {
                        StopWorkerThread stopWorkerThread = (StopWorkerThread)job2;
                        this.logger().debug((Function0 & Serializable)() -> "giving StopWorkerThread");
                        job = stopWorkerThread;
                        break block3;
                    }
                    try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.lock(job2));
                    if (try_ instanceof Success) break block4;
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    if (!(exception instanceof OptimisticLockingFailureException)) {
                        this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> exception);
                        continue;
                    }
                    this.logger().warn((Function0 & Serializable)() -> new StringBuilder(19).append("Unable to lock job ").append(job2).toString());
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(7).append("giving ").append(reservedJob).toString());
            Job job3 = reservedJob;
            job = job3;
        }
        return job;
    }

    private Job lock(Job job) {
        job.version_$eq(job.version() + 1L);
        job.status_$eq(JobStatus.RESERVED);
        job.node_$eq(this.nodeId());
        job.startTime_$eq(Instant.now().truncatedTo(ChronoUnit.MILLIS));
        this.jobRepository().updateWithVersionCheck(JobRow$.MODULE$.apply(job));
        return job;
    }

    @Override
    @Timed
    public void finish(Job job) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(14).append("finishing job ").append(job).toString());
        this.jobRepository().delete(JobRow$.MODULE$.apply(job));
    }

    @Override
    public void stopWorkerThreads(int count) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("stopping ").append(count).append(" worker threads").toString());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> this.localJobs().add(new StopWorkerThread()));
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.localJobs().removeIf(predicate);
    }

    @Autowired
    public DefaultJobQueue(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
        Logging.$init$((Logging)this);
        this.localJobs = new DelayQueue();
    }
}

