/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.InstrumentedExecutorService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001\u0002\u0010 \u0001!B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003C\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t3\u0002\u0011)\u0019!C\u00015\"A\u0011\r\u0001B\u0001B\u0003%1\f\u0003\u0005c\u0001\t\u0015\r\u0011\"\u0001d\u0011!Q\u0007A!A!\u0002\u0013!\u0007\"B6\u0001\t\u0003a\u0007\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011B;\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0013Q\bbCA\u0006\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bA!\"!\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003|\u0011%\tY\u0002\u0001a\u0001\n\u0013\ti\u0002C\u0005\u0002,\u0001\u0001\r\u0011\"\u0003\u0002.!A\u0011\u0011\u0007\u0001!B\u0013\ty\u0002C\u0004\u0002<\u0001!\t!!\u0010\t\u0011\u0005E\u0003\u0001\"\u0001 \u0003{Aa!a\u0015\u0001\t\u0013Q\bbBA+\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003?\u0002A\u0011AA1\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002&\u0002!\t!a*\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\nYqk\u001c:l\u001b\u0006t\u0017mZ3s\u0015\t\u0001\u0013%A\u0005tG\",G-\u001e7fe*\u0011!eI\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001J\u0013\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aUj\u0011!\r\u0006\u0003eM\nQa\u001d7gi)T\u0011\u0001N\u0001\tOJL'P\u001f7fI&\u0011a'\r\u0002\b\u0019><w-\u001b8h\u0003%AHN]\"p]\u001aLw-F\u0001:!\tQT(D\u0001<\u0015\ta\u0014%\u0001\u0004d_:4\u0017nZ\u0005\u0003}m\u0012\u0011\u0002\u00177s\u0007>tg-[4\u0002\u0015ad'oQ8oM&<\u0007%\u0001\u0005k_\n\fV/Z;f+\u0005\u0011\u0005CA\"E\u001b\u0005y\u0012BA# \u0005!QuNY)vKV,\u0017!\u00036pEF+X-^3!\u00035QwN\u0019*fa>\u001c\u0018\u000e^8ssV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M?\u0005Q!/\u001a9pg&$xN]=\n\u00059[%!\u0004&pEJ+\u0007o\\:ji>\u0014\u00180\u0001\bk_\n\u0014V\r]8tSR|'/\u001f\u0011\u0002\u001f\r|W\u000e]8tSR,wk\u001c:lKJ,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+~\tqa^8sW\u0016\u00148/\u0003\u0002X)\ny1i\\7q_NLG/Z,pe.,'/\u0001\td_6\u0004xn]5uK^{'o[3sA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A.\u0011\u0005q{V\"A/\u000b\u0005y\u000b\u0013aB:feZL7-Z\u0005\u0003Av\u0013aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK2,\u0017m]3TKJ4\u0018nY3!\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f+\u0005!\u0007CA3i\u001b\u00051'BA4\"\u0003\u0019\t7\r^8sg&\u0011\u0011N\u001a\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0015e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\u001dign\u001c9reN\u0004\"a\u0011\u0001\t\u000b]j\u0001\u0019A\u001d\t\u000b\u0001k\u0001\u0019\u0001\"\t\u000b\u001dk\u0001\u0019A%\t\u000bAk\u0001\u0019\u0001*\t\u000bek\u0001\u0019A.\t\u000b\tl\u0001\u0019\u00013\u0002\u001f5\f\u0007\u0010\u00165sK\u0006$7oQ8v]R,\u0012A\u001e\t\u0003U]L!\u0001_\u0016\u0003\u0007%sG/\u0001\u0006uQJ,\u0017\r\u001a)p_2,\u0012a\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018AC2p]\u000e,(O]3oi*!\u0011\u0011AA\u0002\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003~\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0004;ie\u0016\fG\rU8pY~#S-\u001d\u000b\u0005\u0003\u001f\t)\u0002E\u0002+\u0003#I1!a\u0005,\u0005\u0011)f.\u001b;\t\u0011\u0005]\u0001#!AA\u0002m\f1\u0001\u001f\u00132\u0003-!\bN]3bIB{w\u000e\u001c\u0011\u0002%MDW\u000f\u001e3po:Le\u000e\u0015:pOJ,7o]\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003Ki\u0018AB1u_6L7-\u0003\u0003\u0002*\u0005\r\"!D!u_6L7MQ8pY\u0016\fg.\u0001\ftQV$Hm\\<o\u0013:\u0004&o\\4sKN\u001cx\fJ3r)\u0011\ty!a\f\t\u0013\u0005]1#!AA\u0002\u0005}\u0011aE:ikR$wn\u001e8J]B\u0013xn\u001a:fgN\u0004\u0003f\u0001\u000b\u00026A\u0019!&a\u000e\n\u0007\u0005e2F\u0001\u0005w_2\fG/\u001b7f\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003\u0003\u001fA3!FA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n!\"\u00198o_R\fG/[8o\u0015\t\tY%A\u0003kCZ\f\u00070\u0003\u0003\u0002P\u0005\u0015#!\u0004)pgR\u001cuN\\:ueV\u001cG/\u0001\u0007ti\u0006\u0014H\u000f\u00165sK\u0006$7/A\u0007hKR$\u0006N]3bIB{w\u000e\\\u0001\tg\",H\u000fZ8x]\"\u001a\u0001$!\u0017\u0011\t\u0005\r\u00131L\u0005\u0005\u0003;\n)E\u0001\u0006Qe\u0016$Um\u001d;s_f\f\u0001cZ3u#V,W/\u001a3UCN\\\u0017\nZ:\u0015\t\u0005\r\u0014q\u0010\t\u0007\u0003K\n\u0019(!\u001f\u000f\t\u0005\u001d\u0014q\u000e\t\u0004\u0003SZSBAA6\u0015\r\tigJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E4&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\n9HA\u0002TKRT1!!\u001d,!\u0011\t)'a\u001f\n\t\u0005u\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\u0005\u0015\u00041\u0001\u0002\u0004\u00069!/\u001a7fCN,\u0007\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%\u0015%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u001b\u000b9IA\u0004SK2,\u0017m]3\u0002\u000fI,7m\u001c<feR!\u0011qBAJ\u0011\u001d\t)J\u0007a\u0001\u0003/\u000bA\u0001^1tWB!\u0011QQAM\u0013\u0011\tY*a\"\u0003\tQ\u000b7o[\u0001\u0012G\u0006t7-\u001a7SKN,'O^3e\u0015>\u0014G\u0003BA\b\u0003CCq!a)\u001c\u0001\u0004\tI(\u0001\u0004uCN\\\u0017\nZ\u0001\u0007gV\u0014W.\u001b;\u0015\t\u0005=\u0011\u0011\u0016\u0005\b\u0003Wc\u0002\u0019AAW\u0003\rQwN\u0019\t\u0004\u0007\u0006=\u0016bAAY?\t\u0019!j\u001c2\u0002!\u0005\u0014wN\u001d;K_\n\u0014\u0015\u0010V1tW&#G\u0003BA\b\u0003oCq!a)\u001e\u0001\u0004\tI\bK\u0002\u0001\u0003w\u0003B!!0\u0002L6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!!2\u0002H\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002J\u0006\u0019qN]4\n\t\u00055\u0017q\u0018\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class WorkManager
implements Logging {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final JobRepository jobRepository;
    private final CompositeWorker compositeWorker;
    private final ReleaseService releaseService;
    private final ReleaseActorService releaseActorService;
    private ExecutorService threadPool;
    private volatile AtomicBoolean shutdownInProgress;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public JobRepository jobRepository() {
        return this.jobRepository;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = true;
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        return !this.bitmap$0 ? this.maxThreadsCount$lzycompute() : this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private void shutdownInProgress_$eq(AtomicBoolean x$1) {
        this.shutdownInProgress = x$1;
    }

    @PostConstruct
    public void initialize() {
        this.startThreads();
    }

    public void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.threadPool().execute(() -> {
            BooleanRef run = BooleanRef.create((boolean)true);
            while (run.elem && !this.shutdownInProgress().get()) {
                Some some;
                try {
                    some = new Some((Object)this.jobQueue().get((Function1<Job, Object>)(Function1 & Serializable)job -> BoxesRunTime.boxToBoolean((boolean)WorkManager.$anonfun$startThreads$3(this, job))));
                }
                catch (InterruptedException e) {
                    this.logger().info((Function0 & Serializable)() -> "Thread is being terminated by shutdown");
                    run.elem = false;
                    some = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Unhandled exception when getting task from the queue", (Function0 & Serializable)() -> e);
                    some = None$.MODULE$;
                }
                Some jobOption = some;
                jobOption.foreach((Function1 & Serializable)x0$1 -> {
                    WorkManager.$anonfun$startThreads$7(this, run, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorService getThreadPool() {
        void var1_1;
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        return this.xlrConfig().metrics().enabled() ? new InstrumentedExecutorService(executors, XlrMetricRegistry$.MODULE$.metricRegistry(), "taskExecution") : var1_1;
    }

    @PreDestroy
    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.threadPool().shutdown();
            this.jobQueue().stopWorkerThreads(this.maxThreadsCount());
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
        } else {
            this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
        }
    }

    public scala.collection.immutable.Set<String> getQueuedTaskIds(Release release) {
        Buffer taskIdsInProgress = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)WorkManager.$anonfun$getQueuedTaskIds$1(task)))).map((Function1 & Serializable)task -> Ids.getFolderlessId((String)task.getId()));
        return taskIdsInProgress.isEmpty() ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$) : (scala.collection.immutable.Set)this.jobRepository().findQueuedTaskIdsByReleaseUid(release.getCiUid()).toSet().intersect((Set)taskIdsInProgress.toSet());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void recover(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Recovering task '").append(task.getId()).append("'").toString());
        Task task2 = task;
        if (task.isPreconditionInProgress()) {
            this.jobQueue().submit(new PreconditionJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFacetInProgress()) {
            this.jobQueue().submit(new FacetCheckJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task.isFailureHandlerInProgress()) {
            this.jobQueue().submit(new FailureHandlerJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), task)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            if (task.isAbortScriptInProgress() || task.isInProgress()) {
                this.jobQueue().submit(new CustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), customScriptTask), (Duration)Duration$.MODULE$.Zero()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof ScriptTask) {
            ScriptTask scriptTask = (ScriptTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new ScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), scriptTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new CreateReleaseTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), createReleaseTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (task2 instanceof NotificationTask) {
            NotificationTask notificationTask = (NotificationTask)task2;
            if (task.isInProgress()) {
                this.jobQueue().submit(new NotificationTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService(), notificationTask)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Task '").append(task.getId()).append("' does not meet any criteria to recover").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void cancelReservedJob(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Cancelling reserved job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Aborting scheduled job ").append(taskId).toString());
        this.jobRepository().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            boolean bl;
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                bl = taskJob.taskId().equals(taskId);
            } else {
                bl = false;
            }
            return bl;
        });
    }

    public static final /* synthetic */ boolean $anonfun$startThreads$3(WorkManager $this, Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            $this.releaseActorService().backpressureWait(taskJob.taskId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return !$this.shutdownInProgress().get();
    }

    public static final /* synthetic */ void $anonfun$startThreads$7(WorkManager $this, BooleanRef run$1, Job x0$1) {
        Job job = x0$1;
        if (job instanceof StopWorkerThread) {
            $this.logger().debug((Function0 & Serializable)() -> "Received StopWorkerThread, stopping");
            run$1.elem = false;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                try {
                    boxedUnit = (BoxedUnit)$this.compositeWorker().execute().apply((Object)job);
                }
                catch (Exception e) {
                    $this.logger().error((Function0 & Serializable)() -> new StringBuilder(40).append("Unhandled exception when executing task ").append(job).toString(), (Function0 & Serializable)() -> e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                $this.jobQueue().finish(job);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getQueuedTaskIds$1(Task task) {
        return task.isInProgress() || task.isFailureHandlerInProgress() || task.isAbortScriptInProgress() || task.isPreconditionInProgress() || task.isFacetInProgress();
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, JobRepository jobRepository, CompositeWorker compositeWorker, ReleaseService releaseService, ReleaseActorService releaseActorService) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.jobRepository = jobRepository;
        this.compositeWorker = compositeWorker;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
        this.shutdownInProgress = new AtomicBoolean(false);
    }
}

