/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependencyViewConverter {
    private ReleaseService releaseService;
    private PhaseService phaseService;
    private TaskService taskService;
    private ReleaseViewConverter releaseViewConverter;

    @Autowired
    public DependencyViewConverter(ReleaseService releaseService, PhaseService phaseService, TaskService taskService, ReleaseViewConverter releaseViewConverter) {
        this.releaseService = releaseService;
        this.phaseService = phaseService;
        this.taskService = taskService;
        this.releaseViewConverter = releaseViewConverter;
    }

    public List<DependencyNode> toDependencyNodes(List<String> planItemIds, List<String> properties, List<String> extensions) {
        return planItemIds.stream().map(node -> this.toDependencyNode((String)node, properties, extensions)).collect(Collectors.toList());
    }

    protected DependencyNode toDependencyNode(String planItemId, List<String> properties, List<String> extensions) {
        DependencyNode dependency = new DependencyNode();
        String releaseId = Ids.releaseIdFrom((String)planItemId);
        Release release = this.releaseService.findById(releaseId);
        dependency.setRelease(this.releaseViewConverter.toOverviewView(release, properties, extensions, 3));
        dependency.setReleaseId(releaseId);
        dependency.setReleaseTitle(release.getTitle());
        dependency.setStartDate(release.getStartDate());
        dependency.setDueDate(release.getDueDate());
        dependency.setScheduledStartDate(release.getScheduledStartDate());
        dependency.setEndDate(release.getEndDate());
        dependency.setFlag(Flag.toFlag(release));
        if (Ids.isPhaseId((String)planItemId)) {
            dependency.setPhaseId(planItemId);
            dependency.setPhaseTitle(VariableHelper.replaceAll((String)this.phaseService.getTitle(planItemId), (Map)release.getAllStringVariableValues()));
        } else if (Ids.isTaskId((String)planItemId)) {
            dependency.setTaskId(planItemId);
            dependency.setTaskTitle(VariableHelper.replaceAll((String)this.taskService.getTitle(planItemId), (Map)release.getAllStringVariableValues()));
            Task task = release.getTask(planItemId);
            if (task instanceof CustomScriptTask) {
                PythonScript pythonScript = ((CustomScriptTask)task).getPythonScript();
                dependency.setTaskColor(pythonScript.getTaskColor());
                dependency.setTaskIconClass(pythonScript.getIconClass());
                dependency.setTaskIconLocation(pythonScript.getIconLocation());
            }
            String phaseId = Ids.phaseIdFrom((String)planItemId);
            dependency.setPhaseId(phaseId);
            dependency.setPhaseTitle(VariableHelper.replaceAll((String)this.phaseService.getTitle(phaseId), (Map)release.getAllStringVariableValues()));
        }
        return dependency;
    }
}

