/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetConfiguredFacetsCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseVariableRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FacetConfigurationService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\f\u0019\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011=\u0003!\u0011!Q\u0001\nAC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t5\u0002\u0011\t\u0011)A\u00057\"Aa\f\u0001B\u0001B\u0003%q\fC\u0003t\u0001\u0011\u0005A\u000fC\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u0011q\n\u0001\u0005\u0002\u0005E\u0003bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!&\u0001\t\u0003\t9\nC\u0004\u00026\u0002!\t!a.\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAy\u0001\u0011%\u00111\u001f\u0002\r\r\u0006\u001cW\r^*feZL7-\u001a\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0006g24GG\u001b\u0006\u0002[\u0005AqM]5{u2,G-\u0003\u00020U\t9Aj\\4hS:<\u0017!\u00074bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\u000e\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00027g\tIb)Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s\u00039!\u0018m]6SKB|7/\u001b;pef\u0004\"AM\u001d\n\u0005i\u001a$A\u0004+bg.\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011Q\bQ\u0007\u0002})\u0011qHG\u0001\u0007KZ,g\u000e^:\n\u0005\u0005s$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001\u0012M]2iSZLgnZ*feZL7-\u001a\t\u0003\t\u0016k\u0011\u0001G\u0005\u0003\rb\u0011\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00023\u0013&\u0011!j\r\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"\u0001R'\n\u00059C\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f!C^1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ssB\u0011!'U\u0005\u0003%N\u0012\u0011DU3mK\u0006\u001cXMV1sS\u0006\u0014G.\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011Q\u000bW\u0007\u0002-*\u0011qKG\u0001\u0007C\u000e$xN]:\n\u0005e3&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017!\u0005;bg.\f5mY3tgN+'O^5dKB\u0011A\tX\u0005\u0003;b\u0011\u0011\u0003V1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f\u0003e1\u0017mY3u\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\u0011\u0003\u0017BA1\u0019\u0005e1\u0015mY3u\u0007>tg-[4ve\u0006$\u0018n\u001c8TKJ4\u0018nY3)\t)\u0019\u0017O\u001d\t\u0003I>l\u0011!\u001a\u0006\u0003M\u001e\f!\"\u00198o_R\fG/[8o\u0015\tA\u0017.A\u0004gC\u000e$xN]=\u000b\u0005)\\\u0017!\u00022fC:\u001c(B\u00017n\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qK\nI\u0011)\u001e;po&\u0014X\rZ\u0001\te\u0016\fX/\u001b:fIf\t\u0001!\u0001\u0004=S:LGO\u0010\u000b\fkZ<\b0\u001f>|yvtx\u0010\u0005\u0002E\u0001!)\u0001g\u0003a\u0001c!)qg\u0003a\u0001q!)1h\u0003a\u0001y!)!i\u0003a\u0001\u0007\")qi\u0003a\u0001\u0011\")1j\u0003a\u0001\u0019\")qj\u0003a\u0001!\")1k\u0003a\u0001)\")!l\u0003a\u00017\")al\u0003a\u0001?\"\"qpY9sQ\tY1-A\u0002hKR$B!!\u0003\u0002\u001aA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!\u00024bG\u0016$(bAA\n5\u00051Am\\7bS:LA!a\u0006\u0002\u000e\t)a)Y2fi\"9\u00111\u0004\u0007A\u0002\u0005u\u0011a\u00024bG\u0016$\u0018\n\u001a\t\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005%\u0002cAA\u0012I5\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0001\u0013A\u0002\u001fs_>$h(C\u0002\u0002,\u0011\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016I!\u001aA\"!\u000e\u0011\t\u0005]\u00121I\u0007\u0003\u0003sQ1AZA\u001e\u0015\u0011\ti$a\u0010\u0002\u000f5,GO]5dg*\u0019\u0011\u0011\t\u0010\u0002\u0011\r|G-\u00195bY\u0016LA!!\u0012\u0002:\t)A+[7fI\u000611M]3bi\u0016$B!!\u0003\u0002L!9\u0011qB\u0007A\u0002\u0005%\u0001fA\u0007\u00026\u0005Y2M]3bi\u0016\f\u0005\u000f\u001d7zS:<7i\u001c8gS\u001e,(/\u0019;j_:$b!a\u0015\u0002j\u0005-\u0004CBA+\u0003?\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011)H/\u001b7\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002X\t!A*[:u!\u0011\tY!!\u001a\n\t\u0005\u001d\u0014Q\u0002\u0002\u0014)\u0006\u001c8NU3q_J$\u0018N\\4SK\u000e|'\u000f\u001a\u0005\b\u0003\u001fq\u0001\u0019AA2\u0011\u001d\tiG\u0004a\u0001\u0003_\n!c\u0019:fCR,WK\\2p]\u001aLw-\u001e:fIB\u00191%!\u001d\n\u0007\u0005MDEA\u0004C_>dW-\u00198)\u00079\t)$\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003w\n\t\tE\u0002$\u0003{J1!a %\u0005\u0011)f.\u001b;\t\u000f\u0005mq\u00021\u0001\u0002\u001e!\u001aq\"!\u000e\u0002\rU\u0004H-\u0019;f)\u0011\tI!!#\t\u000f\u0005=\u0001\u00031\u0001\u0002\n!\u001a\u0001#!\u000e\u0002\u0017%\u001c\u0018*\\7vi\u0006\u0014G.\u001a\u000b\u0005\u0003_\n\t\nC\u0004\u0002\u0010E\u0001\r!!\u0003)\u0007E\t)$\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0005\u00033\u000bY\n\u0005\u0004\u0002V\u0005}\u0013\u0011\u0002\u0005\b\u0003;\u0013\u0002\u0019AAP\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!)\u000206\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+A\u0003g_Jl7O\u0003\u0003\u0002*\u0006-\u0016A\u0001<2\u0015\r\tiKG\u0001\u0004CBL\u0017\u0002BAY\u0003G\u0013ABR1dKR4\u0015\u000e\u001c;feND3AEA\u001b\u0003\u0019)\u00070[:ugR!\u0011qNA]\u0011\u001d\tYb\u0005a\u0001\u0003;A3aEA\u001b\u0003I\u0019'/Z1uK:+wOV1sS\u0006\u0014G.Z:\u0015\r\u0005m\u0014\u0011YAg\u0011\u001d\t\u0019\r\u0006a\u0001\u0003\u000b\fqA]3mK\u0006\u001cX\r\u0005\u0003\u0002H\u0006%WBAA\t\u0013\u0011\tY-!\u0005\u0003\u000fI+G.Z1tK\"9\u0011q\u0002\u000bA\u0002\u0005%\u0011!D4fi\u001a\u000b7-\u001a;UsB,7\u000f\u0006\u0003\u0002T\u0006-\bCBA+\u0003?\n)\u000e\u0005\u0003\u0002X\u0006\u001dXBAAm\u0015\u0011\tY.!8\u0002\u000fI,g\r\\3di*!\u0011QVAp\u0015\u0011\t\t/a9\u0002\rAdWoZ5o\u0015\r\t)\u000fH\u0001\tI\u0016\u0004Hn\\=ji&!\u0011\u0011^Am\u0005)!Um]2sSB$xN\u001d\u0005\b\u0003[,\u0002\u0019AA\u000f\u0003!\u0011\u0017m]3UsB,\u0007fA\u000b\u00026\u0005Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002|\u0005U\bbBA\b-\u0001\u0007\u0011\u0011\u0002\u0015\u0004\u0001\u0005e\b\u0003BA~\u0005\u0003i!!!@\u000b\u0007\u0005}8.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u0001\u0002~\n91+\u001a:wS\u000e,\u0007")
public class FacetService
implements Logging {
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private final TaskAccessService taskAccessService;
    @Autowired(required=false)
    private final FacetConfigurationService facetConfigurationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet create(Facet facet) {
        void var3_3;
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.MINIMAL());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        facet.setId(Ids.getName((String)this.ciIdService.getUniqueId(Type.valueOf(Facet.class), "")));
        Facet createdFacet = this.facetRepositoryDispatcher.create(facet);
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return var3_3;
    }

    @Timed
    public List<TaskReportingRecord> createApplyingConfiguration(TaskReportingRecord facet2, boolean createUnconfigured) {
        List list;
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = this.facetConfigurationService != null ? this.facetConfigurationService.configureFacet(facet2) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskReportingRecord[]{facet2})));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean hasConfiguration = tuple2._1$mcZ$sp();
        scala.collection.immutable.Seq facets = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasConfiguration), (Object)facets);
        Tuple2 tuple24 = tuple23;
        boolean hasConfiguration2 = tuple24._1$mcZ$sp();
        scala.collection.immutable.Seq facets2 = (scala.collection.immutable.Seq)tuple24._2();
        if (createUnconfigured || hasConfiguration2) {
            facets2.foreach((Function1 & Serializable)facet -> this.create((Facet)facet));
            this.eventBus.publish((XLReleaseEvent)new FacetConfiguredFacetsCreatedEvent(facet2, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava(), hasConfiguration2));
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)facets2).asJava();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepositoryDispatcher.get(facetId, this.facetRepositoryDispatcher.get$default$2());
        TaskBasicData taskBasicData = this.taskRepository.findTaskBasicData(facet.getTargetId());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTaskType(taskBasicData.taskType());
        this.facetRepositoryDispatcher.delete(facetId, this.facetRepositoryDispatcher.delete$default$2());
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    @Timed
    public Facet update(Facet facet) {
        this.validate(facet);
        Object task = this.taskRepository.findById(facet.getTargetId(), ResolveOptions$.MODULE$.MINIMAL());
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)task);
        Facet originalFacet = this.facetRepositoryDispatcher.get(facet.getId(), this.facetRepositoryDispatcher.get$default$2());
        Facet updatedFacet = this.facetRepositoryDispatcher.update(facet);
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return updatedFacet;
    }

    @Timed
    public boolean isImmutable(Facet facet) {
        return facet.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Timed
    public List<Facet> search(FacetFilters filters) {
        List list;
        String containerId;
        filters.setTypes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Option$.MODULE$.apply((Object)filters.getTypes()).map((Function1 & Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().flatMap((Function1 & Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).asJava());
        String string = containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        if (this.archivingService.exists(Ids.releaseIdFrom((String)containerId))) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(24).append("Search in ARCHIVE for ").append(filters.getParentId()).append("/").append(filters.getTargetId()).append("/").append(filters.getTypes()).toString());
            list = CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.archiveRepository())).search(filters)).asJava();
        } else {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(21).append("Search in LIVE for ").append(filters.getParentId()).append("/").append(filters.getTargetId()).append("/").append(filters.getTypes()).toString());
            list = CollectionConverters$.MODULE$.SeqHasAsJava(((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher.liveRepository())).search(filters)).asJava();
        }
        return list;
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepositoryDispatcher.exists(facetId, this.facetRepositoryDispatcher.exists$default$2());
    }

    private void createNewVariables(Release release, Facet facet) {
        block0: {
            Buffer newVariables = CollectionConverters$.MODULE$.ListHasAsScala(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
            if (!newVariables.nonEmpty()) break block0;
            newVariables.foreach((Function1 & Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
        }
    }

    @Timed
    public List<Descriptor> getFacetTypes(String baseType) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf((String)baseType))).asScala().map((Function1 & Serializable)x$3 -> x$3.getDescriptor())).filter((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$2(desc)))).filterNot((Function1 & Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$getFacetTypes$3(desc)))).toList().sortBy((Function1 & Serializable)x$4 -> x$4.getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    private void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (!FacetScope.TASK.equals(facetScope)) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Target type ").append(facet.getScope()).append(" is not supported.").toString());
        }
        Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)"Target ID is not a valid task ID.", (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)new StringBuilder(56).append("Task with the ID '").append(facet.getTargetId()).append("' does not exist or has been archived.").toString(), (Object[])new Object[0]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$2(Descriptor desc) {
        return !desc.isVirtual();
    }

    public static final /* synthetic */ boolean $anonfun$getFacetTypes$3(Descriptor desc) {
        return desc.getType().instanceOf(Type.valueOf(TaskReportingRecord.class));
    }

    @Autowired
    public FacetService(FacetRepositoryDispatcher facetRepositoryDispatcher, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, ReleaseVariableRepository variableRepository, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, @Autowired(required=false) FacetConfigurationService facetConfigurationService) {
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.facetConfigurationService = facetConfigurationService;
        Logging.$init$((Logging)this);
    }
}

