/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlrelease.api.internal.converters.CustomLogoSettingsConverter;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.SystemMessageSettings;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.views.ArchivingSettingsView;
import com.xebialabs.xlrelease.views.CustomLogoSettingsView;
import com.xebialabs.xlrelease.views.PollingSettingsView;
import com.xebialabs.xlrelease.views.ReportsSettingsView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SettingsResource {
    private static final Logger logger = LoggerFactory.getLogger(SettingsResource.class);
    private PermissionChecker permissions;
    private ConfigurationRepository configurationRepository;
    private ConfigurationService configurationService;
    private CustomLogoSettingsConverter customLogoSettingsConverter;
    private XLReleaseEventBus eventBus;

    @Autowired
    public SettingsResource(PermissionChecker permissionChecker, ConfigurationRepository configurationRepository, ConfigurationService configurationService, CustomLogoSettingsConverter customLogoSettingsConverter, XLReleaseEventBus eventBus) {
        this.permissions = permissionChecker;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.customLogoSettingsConverter = customLogoSettingsConverter;
        this.eventBus = eventBus;
    }

    @GET
    @Timed
    @Path(value="reports")
    public ReportsSettingsView getReportsSettings() {
        ReportsSettings reportsSettings = (ReportsSettings)this.configurationRepository.read("Configuration/reports/ReportsSettings");
        return new ReportsSettingsView(reportsSettings);
    }

    @GET
    @Timed
    @Path(value="polling-interval")
    public PollingSettingsView getPollingInterval() {
        PollingSettings pollingSettings = (PollingSettings)this.configurationRepository.read("Configuration/settings/PollingSettings");
        return new PollingSettingsView(pollingSettings);
    }

    @GET
    @Timed
    @Path(value="archiving-settings")
    public ArchivingSettingsView getArchivingSettings() {
        ArchivingSettings archivingSettings = (ArchivingSettings)this.configurationRepository.read("Configuration/settings/ArchivingSettings");
        return new ArchivingSettingsView(archivingSettings);
    }

    @GET
    @Timed
    @Path(value="theme")
    public ThemeSettings getThemeSettings() {
        return this.configurationService.getThemeSettings();
    }

    @GET
    @Timed
    @Path(value="system-message")
    public SystemMessageSettings getSystemMessage() {
        return (SystemMessageSettings)this.configurationRepository.read("Configuration/settings/SystemMessageSettings");
    }

    @GET
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public Response read(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        if (id.equals("Configuration/settings/ThemeSettings")) {
            ThemeSettings themeSettings = this.getThemeSettings();
            return Response.ok((Object)themeSettings).build();
        }
        try {
            Object configuration = this.configurationRepository.read(id);
            return Response.ok(configuration).build();
        }
        catch (NotFoundException e) {
            logger.debug(e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration create(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        configurationItem.setId(id);
        this.fixSmtpAuthenticationProperties(configurationItem);
        this.configurationRepository.create(configurationItem);
        Object conf = this.configurationRepository.read(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(conf));
        return conf;
    }

    @PUT
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration update(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.fixSmtpAuthenticationProperties(configurationItem);
        return this.configurationService.createOrUpdate(id, configurationItem);
    }

    @DELETE
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public void delete(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.delete(id);
    }

    @GET
    @Path(value="content-type/image")
    public List<String> getCustomLogoContentTypes() {
        return CustomLogoContentType.getBrowserTypes();
    }

    @POST
    @Timed
    @Path(value="custom-logo/upload")
    @Consumes(value={"multipart/form-data"})
    public CustomLogoSettings setCustomLogo(@Context HttpServletRequest request) throws IOException {
        this.permissions.check(PlatformPermissions.ADMIN);
        try {
            ServletFileUpload upload = new ServletFileUpload();
            FileItemIterator fileItems = upload.getItemIterator(request);
            return this.configurationService.saveCustomLogo(this.customLogoSettingsConverter.fromFileItemIterator(fileItems));
        }
        catch (IllegalArgumentException | FileUploadException ex) {
            throw new BadRequestException(ex);
        }
    }

    @GET
    @Path(value="custom-logo/download")
    public Response downloadCustomLogo() {
        try {
            CustomLogoSettings customLogoSettings = (CustomLogoSettings)this.configurationRepository.read("Configuration/settings/CustomLogoSettings");
            CustomLogoSettingsView customLogoSettingsView = this.customLogoSettingsConverter.toView(customLogoSettings);
            StreamingOutput output = stream -> {
                ByteArrayInputStream is = new ByteArrayInputStream(customLogoSettingsView.getContent());
                OverthereUtils.write((InputStream)is, (OutputStream)stream);
            };
            return Response.ok((Object)output, (String)customLogoSettingsView.getContentType()).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="features")
    public List<FeatureSettings> getFeatureSettings() {
        return this.configurationService.getFeatureSettings();
    }

    @PUT
    @Timed
    @Path(value="features")
    public List<FeatureSettings> updateFeatureSettings(List<FeatureSettings> features) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.saveFeatureSettings(features);
        return this.configurationService.getFeatureSettings();
    }

    private void fixSmtpAuthenticationProperties(BaseConfiguration baseConfiguration) {
        BaseConfigurationItem authentication;
        if (baseConfiguration.getType().equals((Object)Type.valueOf((String)"xlrelease.SmtpServer")) && baseConfiguration.hasProperty("authentication") && (authentication = (BaseConfigurationItem)baseConfiguration.getProperty("authentication")) != null && authentication.getType().equals((Object)Type.valueOf((String)"xlrelease.OAuth2SmtpAuthentication"))) {
            if (authentication.hasProperty("accessToken")) {
                authentication.setProperty("accessToken", null);
            }
            if (authentication.hasProperty("expiresAt")) {
                authentication.setProperty("expiresAt", null);
            }
        }
    }
}

