/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.plugin.manager.cli.PluginManagerCli;
import com.xebialabs.plugin.manager.sql.SqlPluginRepository;
import com.xebialabs.xlrelease.ReleaseServer;
import com.xebialabs.xlrelease.XLReleaseBootstrapper$;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ResourceUtils;

public final class PluginManagerCliBootstrapper$ {
    public static final PluginManagerCliBootstrapper$ MODULE$ = new PluginManagerCliBootstrapper$();

    public void main(String[] args) {
        ReleaseServer.outputReleaseInfo();
        XLReleaseServerLaunchOptions launchOptions = XLReleaseServerLaunchOptions.parseCommandLine(args);
        if (launchOptions == null) {
            System.exit(0);
        }
        File serverConfFile = ResourceUtils.getFile((String)XlrConfig$.MODULE$.bootConfig().confFile_location());
        ServerConfigFile confFile = new ServerConfigFile(serverConfFile);
        XLReleaseBootstrapper$.MODULE$.releaseServer_$eq(new ReleaseServer(launchOptions, confFile));
        XLReleaseBootstrapper$.MODULE$.releaseServer().prepareConfigs();
        this.runPluginManagerCli();
        System.exit(0);
    }

    public void runPluginManagerCli() {
        HikariDataSource ds = this.dataSource();
        SqlPluginRepository repository = this.sqlPluginRepository(ds);
        PluginManagerCli cli = this.pluginManagerCli(repository);
        cli.run();
        ds.close();
    }

    public HikariDataSource dataSource() {
        XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
        HikariConfig cfg = new HikariConfig();
        cfg.setDriverClassName(xlrConfig.xlrRepositoryDriver());
        cfg.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl());
        cfg.setUsername(xlrConfig.xlrRepositoryUsername());
        cfg.setPassword(xlrConfig.xlrRepositoryPassword());
        return new HikariDataSource(cfg);
    }

    public SqlPluginRepository sqlPluginRepository(HikariDataSource dataSource) {
        return new SqlPluginRepository(new JdbcTemplate((DataSource)dataSource));
    }

    public PluginManagerCli pluginManagerCli(SqlPluginRepository sqlPluginRepository) {
        return new PluginManagerCli(sqlPluginRepository, "jar");
    }

    private PluginManagerCliBootstrapper$() {
    }
}

